/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordRandomAccess;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.std.DirectLongLongSortedList;
import java.io.Closeable;

public interface RecordCursor
extends RecordRandomAccess,
Closeable,
SymbolTableSource {
    public static void calculateSize(RecordCursor cursor, SqlExecutionCircuitBreaker circuitBreaker, Counter counter) {
        if (circuitBreaker != null) {
            while (cursor.hasNext()) {
                counter.inc();
                circuitBreaker.statefulThrowExceptionIfTripped();
            }
        } else {
            while (cursor.hasNext()) {
                counter.inc();
            }
        }
    }

    public static long fromBool(boolean b) {
        return b ? 1L : 0L;
    }

    public static void skipRows(RecordCursor cursor, Counter rowCount) throws DataUnavailableException {
        while (rowCount.get() > 0L && cursor.hasNext()) {
            rowCount.dec();
        }
    }

    default public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, Counter counter) {
        if (circuitBreaker != null) {
            while (this.hasNext()) {
                counter.inc();
                circuitBreaker.statefulThrowExceptionIfTripped();
            }
        } else {
            while (this.hasNext()) {
                counter.inc();
            }
        }
    }

    @Override
    public void close();

    public Record getRecord();

    public Record getRecordB();

    @Override
    default public SymbolTable getSymbolTable(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() throws DataUnavailableException;

    default public boolean isUsingIndex() {
        return false;
    }

    default public void longTopK(DirectLongLongSortedList list, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public SymbolTable newSymbolTable(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public long preComputedStateSize();

    public long size() throws DataUnavailableException;

    default public void skipRows(Counter rowCount) throws DataUnavailableException {
        while (rowCount.get() > 0L && this.hasNext()) {
            rowCount.dec();
        }
    }

    public void toTop();

    public static class Counter {
        private long value;

        public void add(long val) {
            this.value += val;
        }

        public void clear() {
            this.value = 0L;
        }

        public void dec() {
            --this.value;
        }

        public void dec(long val) {
            this.value -= val;
        }

        public long get() {
            return this.value;
        }

        public void inc() {
            ++this.value;
        }

        public void set(long val) {
            this.value = val;
        }
    }
}

