/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewRefreshTask;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.mv.MatViewStateStore;
import io.questdb.cairo.mv.MatViewTelemetryFacade;
import io.questdb.cairo.mv.MatViewTimerTask;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.ConcurrentQueue;
import io.questdb.mp.Queue;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.tasks.TelemetryMatViewTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatViewStateStoreImpl
implements MatViewStateStore {
    private static final Log LOG = LogFactory.getLog(MatViewStateStoreImpl.class);
    private static final ThreadLocal<MatViewTimerTask> tlTimerTask = new ThreadLocal<MatViewTimerTask>(MatViewTimerTask::new);
    private final Function<CharSequence, AtomicLong> createLastNotifiedTxn;
    private final ConcurrentHashMap<AtomicLong> lastNotifiedTxnByTableName = new ConcurrentHashMap(false);
    private final MicrosecondClock microsecondClock;
    private final ConcurrentHashMap<MatViewState> stateByTableDirName = new ConcurrentHashMap();
    private final ThreadLocal<MatViewRefreshTask> taskHolder = new ThreadLocal<MatViewRefreshTask>(MatViewRefreshTask::new);
    private final Queue<MatViewRefreshTask> taskQueue = ConcurrentQueue.createConcurrentQueue(MatViewRefreshTask::new);
    private final Telemetry<TelemetryMatViewTask> telemetry;
    private final MatViewTelemetryFacade telemetryFacade;
    private final Queue<MatViewTimerTask> timerTaskQueue;

    public MatViewStateStoreImpl(CairoEngine engine) {
        this.telemetry = engine.getTelemetryMatView();
        this.telemetryFacade = this.telemetry.isEnabled() ? this::storeMatViewTelemetry : (event, tableToken, baseTableTxn, errorMessage, latencyUs) -> {};
        this.timerTaskQueue = engine.getMatViewTimerQueue();
        this.microsecondClock = engine.getConfiguration().getMicrosecondClock();
        this.createLastNotifiedTxn = name -> new AtomicLong();
    }

    public static boolean notifyBaseTableCommit(AtomicLong lastNotifiedBaseTableTxn, long seqTxn) {
        long lastNotified;
        boolean retry;
        while (retry = Math.abs(lastNotified = lastNotifiedBaseTableTxn.get()) < seqTxn && !lastNotifiedBaseTableTxn.compareAndSet(lastNotified, seqTxn)) {
        }
        return lastNotified <= 0L;
    }

    public static boolean notifyOnBaseTableRefreshed(AtomicLong lastNotifiedTxn, long seqTxn) {
        lastNotifiedTxn.compareAndSet(seqTxn, -seqTxn);
        long lastNotified = lastNotifiedTxn.get();
        return lastNotified != Long.MIN_VALUE && lastNotified != -seqTxn;
    }

    @Override
    public MatViewState addViewState(MatViewDefinition viewDefinition) {
        TableToken viewToken = viewDefinition.getMatViewToken();
        MatViewState state = new MatViewState(viewDefinition, this.telemetryFacade);
        MatViewState prevState = this.stateByTableDirName.putIfAbsent(viewToken.getDirName(), state);
        if (prevState != null) {
            Misc.free(state);
            throw CairoException.critical(0).put("materialized view state already exists [dir=").put(viewToken.getDirName());
        }
        this.lastNotifiedTxnByTableName.computeIfAbsent(viewDefinition.getBaseTableName(), this.createLastNotifiedTxn);
        if (viewDefinition.getRefreshType() != 0 || viewDefinition.getPeriodLength() > 0) {
            MatViewTimerTask timerTask = tlTimerTask.get();
            this.timerTaskQueue.enqueue(timerTask.ofAdd(viewToken));
        }
        return state;
    }

    @Override
    public void clear() {
        this.close();
        this.taskQueue.clear();
        this.stateByTableDirName.clear();
        this.lastNotifiedTxnByTableName.clear();
    }

    @Override
    public void close() {
        for (MatViewState state : this.stateByTableDirName.values()) {
            Misc.free(state);
        }
    }

    @Override
    public void createViewState(MatViewDefinition viewDefinition) {
        this.addViewState(viewDefinition).init();
    }

    @Override
    public void enqueueFullRefresh(TableToken matViewToken) {
        this.enqueueTaskIfStateExists(matViewToken, 1, null);
    }

    @Override
    public void enqueueIncrementalRefresh(TableToken matViewToken) {
        this.enqueueTaskIfStateExists(matViewToken, 0, null);
    }

    @Override
    public void enqueueInvalidate(TableToken matViewToken, String invalidationReason) {
        this.enqueueTaskIfStateExists(matViewToken, 3, invalidationReason);
    }

    @Override
    public void enqueueInvalidateDependentViews(TableToken baseTableToken, String invalidationReason) {
        this.enqueueMatViewTask(null, baseTableToken, 3, invalidationReason, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    @Override
    public void enqueueRangeRefresh(TableToken matViewToken, long rangeFrom, long rangeTo) {
        this.enqueueTaskIfStateExists(matViewToken, 2, null, rangeFrom, rangeTo);
    }

    public void enqueueTaskIfStateExists(TableToken matViewToken, int operation, String invalidationReason, long rangeFrom, long rangeTo) {
        MatViewState state = this.stateByTableDirName.get(matViewToken.getDirName());
        if (state != null && !state.isDropped()) {
            this.enqueueMatViewTask(matViewToken, null, operation, invalidationReason, rangeFrom, rangeTo);
        }
    }

    @Override
    public void enqueueUpdateRefreshIntervals(TableToken matViewToken) {
        this.enqueueTaskIfStateExists(matViewToken, 4, null);
    }

    @Override
    public MatViewState getViewState(TableToken matViewToken) {
        MatViewState state = this.stateByTableDirName.get(matViewToken.getDirName());
        if (state != null) {
            if (state.isDropped()) {
                this.stateByTableDirName.remove(matViewToken.getDirName(), state);
            }
            return state;
        }
        return null;
    }

    @Override
    public void notifyBaseInvalidated(TableToken baseTableToken) {
        AtomicLong lastNotifiedTxn = this.lastNotifiedTxnByTableName.get(baseTableToken.getTableName());
        if (lastNotifiedTxn != null) {
            lastNotifiedTxn.set(Long.MIN_VALUE);
        }
    }

    @Override
    public void notifyBaseRefreshed(MatViewRefreshTask task, long seqTxn) {
        AtomicLong lastNotifiedTxn = this.lastNotifiedTxnByTableName.get(task.baseTableToken.getTableName());
        if (lastNotifiedTxn != null && MatViewStateStoreImpl.notifyOnBaseTableRefreshed(lastNotifiedTxn, seqTxn)) {
            task.refreshTriggerTimestamp = this.microsecondClock.getTicks();
            this.taskQueue.enqueue(task);
        }
    }

    @Override
    public void notifyBaseTableCommit(MatViewRefreshTask task, long seqTxn) {
        TableToken baseTableToken = task.baseTableToken;
        AtomicLong lastNotifiedBaseTableTxn = this.lastNotifiedTxnByTableName.get(baseTableToken.getTableName());
        task.refreshTriggerTimestamp = this.microsecondClock.getTicks();
        if (task.operation != 0) {
            this.taskQueue.enqueue(task);
            LOG.debug().$("notified [baseTable=").$(baseTableToken).$(", op=").$(MatViewRefreshTask.getRefreshOperationName(task.operation)).I$();
        } else if (lastNotifiedBaseTableTxn != null) {
            if (MatViewStateStoreImpl.notifyBaseTableCommit(lastNotifiedBaseTableTxn, seqTxn)) {
                this.taskQueue.enqueue(task);
                LOG.debug().$("notified [baseTable=").$(baseTableToken).$(", op=incremental_refresh").I$();
            } else {
                LOG.debug().$("no need to notify to refresh job [baseTable=").$(baseTableToken).I$();
            }
        }
    }

    @Override
    public void removeViewState(TableToken matViewToken) {
        MatViewState state = this.stateByTableDirName.remove(matViewToken.getDirName());
        if (state != null) {
            state.markAsDropped();
            state.tryCloseIfDropped();
            MatViewTimerTask timerTask = tlTimerTask.get();
            this.timerTaskQueue.enqueue(timerTask.ofRemove(matViewToken));
        }
    }

    @Override
    public boolean tryDequeueRefreshTask(MatViewRefreshTask task) {
        return this.taskQueue.tryDequeue(task);
    }

    @Override
    public void updateViewDefinition(@NotNull TableToken matViewToken, @NotNull MatViewDefinition newDefinition) {
        MatViewState state = this.stateByTableDirName.get(matViewToken.getDirName());
        if (state != null) {
            state.setViewDefinition(newDefinition);
            MatViewTimerTask timerTask = tlTimerTask.get();
            this.timerTaskQueue.enqueue(timerTask.ofUpdate(matViewToken));
        }
    }

    private void enqueueMatViewTask(@Nullable TableToken matViewToken, @Nullable TableToken baseTableToken, int operation, String invalidationReason, long rangeFrom, long rangeTo) {
        MatViewRefreshTask task = this.taskHolder.get();
        task.clear();
        task.matViewToken = matViewToken;
        task.baseTableToken = baseTableToken;
        task.operation = operation;
        task.invalidationReason = invalidationReason;
        task.rangeFrom = rangeFrom;
        task.rangeTo = rangeTo;
        if (MatViewRefreshTask.isRefreshOperation(operation)) {
            task.refreshTriggerTimestamp = this.microsecondClock.getTicks();
        }
        this.taskQueue.enqueue(task);
    }

    private void enqueueTaskIfStateExists(TableToken matViewToken, int operation, String invalidationReason) {
        this.enqueueTaskIfStateExists(matViewToken, operation, invalidationReason, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    private void storeMatViewTelemetry(short event, TableToken tableToken, long baseTableTxn, CharSequence errorMessage, long latencyUs) {
        TelemetryMatViewTask.store(this.telemetry, event, tableToken.getTableId(), baseTableTxn, errorMessage, latencyUs);
    }
}

