/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.mv.MatViewDependencyList;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Mutable;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.ReadOnlyObjList;
import java.util.ArrayDeque;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class MatViewGraph
implements Mutable {
    private static final ThreadLocal<MatViewDefinition> tlDefinitionTask = new ThreadLocal();
    private static final io.questdb.std.ThreadLocal<LowerCaseCharSequenceHashSet> tlSeen = new io.questdb.std.ThreadLocal<LowerCaseCharSequenceHashSet>(LowerCaseCharSequenceHashSet::new);
    private static final io.questdb.std.ThreadLocal<ArrayDeque<CharSequence>> tlStack = new io.questdb.std.ThreadLocal<ArrayDeque>(ArrayDeque::new);
    private final Function<CharSequence, MatViewDependencyList> createDependencyList;
    private final ConcurrentHashMap<MatViewDefinition> definitionsByTableDirName = new ConcurrentHashMap();
    private final ConcurrentHashMap<MatViewDependencyList> dependentViewsByTableName = new ConcurrentHashMap(false);
    private final BiFunction<CharSequence, MatViewDefinition, MatViewDefinition> updateDefinitionRef;

    public MatViewGraph() {
        this.createDependencyList = name -> new MatViewDependencyList();
        this.updateDefinitionRef = this::updateDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addView(MatViewDefinition viewDefinition) {
        TableToken viewToken = viewDefinition.getMatViewToken();
        MatViewDefinition prevDefinition = this.definitionsByTableDirName.putIfAbsent(viewToken.getDirName(), viewDefinition);
        if (prevDefinition != null) {
            return false;
        }
        MatViewGraph matViewGraph = this;
        synchronized (matViewGraph) {
            if (this.hasDependencyLoop(viewDefinition.getBaseTableName(), viewToken)) {
                throw CairoException.critical(0).put("circular dependency detected for materialized view [view=").put(viewToken.getTableName()).put(", baseTable=").put(viewDefinition.getBaseTableName()).put(']');
            }
            MatViewDependencyList list = this.getOrCreateDependentViews(viewDefinition.getBaseTableName());
            ObjList<TableToken> matViews = list.lockForWrite();
            try {
                matViews.add(viewToken);
            }
            finally {
                list.unlockAfterWrite();
            }
        }
        return true;
    }

    @Override
    public void clear() {
        this.definitionsByTableDirName.clear();
        this.dependentViewsByTableName.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDependentViews(TableToken baseTableToken, ObjList<TableToken> sink) {
        MatViewDependencyList list = this.getOrCreateDependentViews(baseTableToken.getTableName());
        ReadOnlyObjList<TableToken> matViews = list.lockForRead();
        try {
            sink.addAll(matViews);
        }
        finally {
            list.unlockAfterRead();
        }
    }

    public MatViewDefinition getViewDefinition(TableToken matViewToken) {
        return this.definitionsByTableDirName.get(matViewToken.getDirName());
    }

    public void getViews(ObjList<TableToken> sink) {
        for (MatViewDefinition viewDefinition : this.definitionsByTableDirName.values()) {
            sink.add(viewDefinition.getMatViewToken());
        }
    }

    public void orderByDependentViews(ObjHashSet<TableToken> tables, ObjList<TableToken> orderedSink) {
        orderedSink.clear();
        ObjHashSet<TableToken> seen = new ObjHashSet<TableToken>();
        ArrayDeque<TableToken> stack = new ArrayDeque<TableToken>();
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            TableToken token = tables.get(i);
            if (seen.contains(token)) continue;
            this.orderByDependentViews(token, seen, stack, orderedSink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(TableToken viewToken) {
        String baseTableName;
        MatViewDependencyList dependentViews;
        MatViewDefinition viewDefinition = this.definitionsByTableDirName.remove(viewToken.getDirName());
        if (viewDefinition != null && (dependentViews = this.dependentViewsByTableName.get(baseTableName = viewDefinition.getBaseTableName())) != null) {
            ObjList<TableToken> matViews = dependentViews.lockForWrite();
            try {
                int n = matViews.size();
                for (int i = 0; i < n; ++i) {
                    TableToken matView = matViews.get(i);
                    if (!matView.equals(viewToken)) continue;
                    matViews.remove(i);
                    break;
                }
            }
            finally {
                dependentViews.unlockAfterWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateToken(TableToken updatedToken) {
        MatViewDefinition viewDefinition = this.definitionsByTableDirName.get(updatedToken.getDirName());
        if (viewDefinition != null) {
            viewDefinition.updateToken(updatedToken);
            MatViewDependencyList viewList = this.dependentViewsByTableName.get(viewDefinition.getBaseTableName());
            if (viewList != null) {
                ObjList<TableToken> matViews = viewList.lockForWrite();
                try {
                    int n = matViews.size();
                    for (int i = 0; i < n; ++i) {
                        if (!Chars.equalsIgnoreCase(matViews.get(i).getDirName(), updatedToken.getDirName())) continue;
                        matViews.set(i, updatedToken);
                        return;
                    }
                }
                finally {
                    viewList.unlockAfterWrite();
                }
            }
        }
    }

    public void updateViewDefinition(@NotNull TableToken viewToken, @NotNull MatViewDefinition newDefinition) {
        tlDefinitionTask.set(newDefinition);
        if (this.definitionsByTableDirName.computeIfPresent(viewToken.getDirName(), this.updateDefinitionRef) == null) {
            throw CairoException.nonCritical().put("previous view definition was not found: ").put(viewToken.getTableName());
        }
    }

    @NotNull
    private MatViewDependencyList getOrCreateDependentViews(CharSequence baseTableName) {
        return this.dependentViewsByTableName.computeIfAbsent(baseTableName, this.createDependencyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDependencyLoop(CharSequence baseTableName, TableToken newMatViewToken) {
        LowerCaseCharSequenceHashSet seen = tlSeen.get();
        ArrayDeque<CharSequence> stack = tlStack.get();
        seen.clear();
        stack.clear();
        if (Chars.equalsIgnoreCase(baseTableName, newMatViewToken.getTableName())) {
            return true;
        }
        stack.push(newMatViewToken.getTableName());
        while (!stack.isEmpty()) {
            MatViewDependencyList dependentViews;
            CharSequence currentTableName = stack.pop();
            if (!seen.add(currentTableName) || (dependentViews = this.dependentViewsByTableName.get(currentTableName)) == null) continue;
            ReadOnlyObjList<TableToken> matViews = dependentViews.lockForRead();
            try {
                int n = matViews.size();
                for (int i = 0; i < n; ++i) {
                    TableToken matView = matViews.get(i);
                    if (Chars.equalsIgnoreCase(matView.getTableName(), baseTableName)) {
                        boolean bl = true;
                        return bl;
                    }
                    stack.push(matView.getTableName());
                }
            }
            finally {
                dependentViews.unlockAfterRead();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderByDependentViews(TableToken current, ObjHashSet<TableToken> seen, ArrayDeque<TableToken> stack, ObjList<TableToken> sink) {
        stack.push(current);
        while (!stack.isEmpty()) {
            TableToken top = stack.peek();
            if (!seen.contains(top)) {
                MatViewDependencyList list = this.dependentViewsByTableName.get(top.getTableName());
                if (list == null) {
                    sink.add(top);
                    seen.add(top);
                    stack.pop();
                    continue;
                }
                boolean allDependentSeen = true;
                ReadOnlyObjList<TableToken> views = list.lockForRead();
                try {
                    int n = views.size();
                    for (int i = 0; i < n; ++i) {
                        TableToken view = views.get(i);
                        if (seen.contains(view)) continue;
                        stack.push(view);
                        allDependentSeen = false;
                    }
                }
                finally {
                    list.unlockAfterRead();
                }
                if (!allDependentSeen) continue;
                sink.add(top);
                seen.add(top);
                stack.pop();
                continue;
            }
            stack.pop();
        }
    }

    private MatViewDefinition updateDefinition(CharSequence tableDirName, MatViewDefinition existingDefinition) {
        if (existingDefinition == null) {
            return null;
        }
        MatViewDefinition newDefinition = tlDefinitionTask.get();
        assert (newDefinition != null);
        tlDefinitionTask.set(null);
        return newDefinition;
    }
}

