/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.mv.SampleByIntervalIterator;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.LongList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedOffsetIntervalIterator
extends SampleByIntervalIterator {
    private long maxTimestamp;
    private long minTimestamp;
    private long timestampHi;
    private long timestampLo;

    @Override
    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    @Override
    public long getTimestampHi() {
        return this.timestampHi;
    }

    @Override
    public long getTimestampLo() {
        return this.timestampLo;
    }

    public FixedOffsetIntervalIterator of(@NotNull TimestampSampler sampler, long offset, @Nullable LongList intervals, long minTs, long maxTs, int step) {
        super.of(sampler, intervals);
        sampler.setStart(offset);
        this.minTimestamp = sampler.round(minTs);
        this.maxTimestamp = sampler.nextTimestamp(sampler.round(maxTs));
        this.toTop(step);
        return this;
    }

    @Override
    protected boolean next0() {
        if (this.timestampHi == this.maxTimestamp) {
            return false;
        }
        this.timestampLo = this.timestampHi;
        this.timestampHi = Math.min(this.sampler.nextTimestamp(this.timestampHi, this.step), this.maxTimestamp);
        return true;
    }

    @Override
    protected void toTop0() {
        this.timestampLo = Long.MIN_VALUE;
        this.timestampHi = this.minTimestamp;
    }
}

