/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.FrameColumnPool;
import io.questdb.cairo.frm.FrameColumnTypePool;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileIndexedFrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileVarFrameColumn;
import io.questdb.cairo.frm.file.MemoryFixFrameColumn;
import io.questdb.cairo.frm.file.MemoryVarFrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.mp.ConcurrentPool;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class ContiguousFileColumnPool
implements FrameColumnPool,
Closeable {
    private final ColumnTypePool columnTypePool = new ColumnTypePool();
    private final ConcurrentQueuePool<ContiguousFileFixFrameColumn> fixColumnPool = new ConcurrentQueuePool<ContiguousFileFixFrameColumn>(() -> new ContiguousFileFixFrameColumn(configuration));
    private final ConcurrentQueuePool<MemoryFixFrameColumn> fixMemColumnPool = new ConcurrentQueuePool<MemoryFixFrameColumn>(MemoryFixFrameColumn::new);
    private final ConcurrentQueuePool<ContiguousFileFixFrameColumn> indexedColumnPool = new ConcurrentQueuePool<ContiguousFileFixFrameColumn>(() -> new ContiguousFileIndexedFrameColumn(configuration));
    private final ConcurrentQueuePool<ContiguousFileVarFrameColumn> varColumnPool = new ConcurrentQueuePool<ContiguousFileVarFrameColumn>(() -> new ContiguousFileVarFrameColumn(configuration));
    private final ConcurrentQueuePool<MemoryVarFrameColumn> varMemColumnPool = new ConcurrentQueuePool<MemoryVarFrameColumn>(MemoryVarFrameColumn::new);
    private boolean isClosed;

    public ContiguousFileColumnPool(CairoConfiguration configuration) {
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public FrameColumnTypePool getPool(int columnType) {
        return this.columnTypePool;
    }

    private class ColumnTypePool
    implements FrameColumnTypePool {
        private ColumnTypePool() {
        }

        @Override
        public FrameColumn create(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, int indexBlockCapacity, long columnTop, int columnIndex, boolean isEmpty, boolean canWrite) {
            boolean isIndexed;
            boolean bl = isIndexed = indexBlockCapacity > 0;
            if (ColumnType.isVarSize(columnType)) {
                ContiguousFileVarFrameColumn column = this.getVarColumn();
                if (canWrite) {
                    column.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
                } else {
                    column.ofRO(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex, isEmpty);
                }
                return column;
            }
            if (columnType == 12 && canWrite && isIndexed) {
                ContiguousFileIndexedFrameColumn indexedColumn = this.getIndexedColumn();
                indexedColumn.ofRW(partitionPath, columnName, columnTxn, columnType, indexBlockCapacity, columnTop, columnIndex, isEmpty);
                return indexedColumn;
            }
            ContiguousFileFixFrameColumn column = this.getFixColumn();
            if (canWrite) {
                column.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
            } else {
                column.ofRO(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex, isEmpty);
            }
            return column;
        }

        @Override
        public FrameColumn createFromMemoryColumn(int columnIndex, int columnType, long rowCount, MemoryCR columnMemoryPrimary, MemoryCR columnMemorySecondary) {
            if (!ColumnType.isVarSize(columnType)) {
                MemoryFixFrameColumn column = this.getMemFixColumn();
                column.of(columnIndex, columnType, rowCount, columnMemoryPrimary);
                return column;
            }
            MemoryVarFrameColumn column = this.getMemVarColumn();
            column.of(columnIndex, columnType, rowCount, columnMemoryPrimary, columnMemorySecondary);
            return column;
        }

        private ContiguousFileFixFrameColumn getFixColumn() {
            return ContiguousFileColumnPool.this.fixColumnPool.pop();
        }

        private ContiguousFileIndexedFrameColumn getIndexedColumn() {
            return (ContiguousFileIndexedFrameColumn)ContiguousFileColumnPool.this.indexedColumnPool.pop();
        }

        private MemoryFixFrameColumn getMemFixColumn() {
            return ContiguousFileColumnPool.this.fixMemColumnPool.pop();
        }

        private MemoryVarFrameColumn getMemVarColumn() {
            return ContiguousFileColumnPool.this.varMemColumnPool.pop();
        }

        private ContiguousFileVarFrameColumn getVarColumn() {
            return ContiguousFileColumnPool.this.varColumnPool.pop();
        }
    }

    private class ConcurrentQueuePool<T extends FrameColumn>
    implements RecycleBin<T> {
        private final ObjectFactory<T> factory;
        private final ConcurrentPool<T> pool = new ConcurrentPool();

        public ConcurrentQueuePool(ObjectFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public boolean isClosed() {
            return ContiguousFileColumnPool.this.isClosed;
        }

        public T pop() {
            FrameColumn item = (FrameColumn)this.pool.pop();
            if (item != null) {
                return (T)item;
            }
            item = (FrameColumn)this.factory.newInstance();
            item.setRecycleBin(this);
            return (T)item;
        }

        @Override
        public void put(T frame) {
            this.pool.push(frame);
        }
    }
}

