/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.std.IntList;

public class DerivedArrayView
extends ArrayView {
    public static void computeBroadcastShape(ArrayView left, ArrayView right, IntList shapeOut, int leftArgPosition) {
        int nDimsA = left.getDimCount();
        int nDimsB = right.getDimCount();
        int maxDims = Math.max(nDimsA, nDimsB);
        shapeOut.setPos(maxDims);
        for (int i = 1; i <= maxDims; ++i) {
            int dimLenB;
            int posA = nDimsA - i;
            int posB = nDimsB - i;
            int dimLenA = posA >= 0 ? left.shape.get(posA) : 1;
            int n = dimLenB = posB >= 0 ? right.shape.get(posB) : 1;
            if (dimLenA == dimLenB) {
                shapeOut.setQuick(maxDims - i, dimLenA);
                continue;
            }
            if (dimLenA == 1) {
                shapeOut.setQuick(maxDims - i, dimLenB);
                continue;
            }
            if (dimLenB == 1) {
                shapeOut.setQuick(maxDims - i, dimLenA);
                continue;
            }
            throw CairoException.nonCritical().position(leftArgPosition).put("arrays have incompatible shapes [leftShape=").put(left.shapeToString()).put(", rightShape=").put(right.shapeToString()).put(']');
        }
    }

    public void appendDimensions(int count) {
        if (count == 0) {
            return;
        }
        if (count + this.getDimCount() > 32) {
            throw CairoException.nonCritical().put("cannot add ").put(count).put(" dimensions, would exceed maximum array dimensions (").put(32L).put(")");
        }
        for (int i = 0; i < count; ++i) {
            this.shape.add(1);
            this.strides.add(0);
        }
        this.type = ColumnType.encodeArrayType(this.getElemType(), this.getDimCount() + count);
    }

    public void broadcast(IntList targetShape) {
        int targetDims = targetShape.size();
        int originalDims = this.getDimCount();
        assert (targetDims >= originalDims);
        if (originalDims < targetDims) {
            this.prependDimensions(targetDims - originalDims);
        }
        boolean changed = false;
        for (int i = 0; i < targetDims; ++i) {
            int thisDimLen = this.shape.getQuick(i);
            int targetDimLen = targetShape.getQuick(i);
            if (targetDimLen == 1) continue;
            if (thisDimLen == 1) {
                this.strides.setQuick(i, 0);
                this.shape.setQuick(i, targetDimLen);
                changed = true;
                continue;
            }
            assert (thisDimLen == targetDimLen) : "incompatible target shape";
        }
        if (changed) {
            this.isVanilla = false;
        }
    }

    public void flatten() {
        assert (this.isVanilla) : "flatten() only allowed on a vanilla array";
        this.shape.clear();
        this.shape.add(this.getCardinality());
        this.strides.clear();
        this.strides.add(1);
        this.type = ColumnType.encodeArrayType(this.getElemType(), 1);
    }

    public void of(ArrayView other) {
        this.type = other.getType();
        this.flatView = other.flatView();
        this.flatViewOffset = other.getFlatViewOffset();
        this.flatViewLength = other.getFlatViewLength();
        this.isVanilla = other.isVanilla;
        this.shape.clear();
        this.strides.clear();
        int nDims = other.getDimCount();
        for (int i = 0; i < nDims; ++i) {
            this.shape.add(other.getDimLen(i));
            this.strides.add(other.getStride(i));
        }
    }

    public void ofNull() {
        this.type = 33;
        this.flatView = null;
        this.flatViewLength = 0;
        this.flatViewOffset = 0;
        this.shape.clear();
        this.strides.clear();
        this.isVanilla = true;
    }

    public void prependDimensions(int count) {
        if (count == 0) {
            return;
        }
        if (count + this.getDimCount() > 32) {
            throw CairoException.nonCritical().put("cannot add ").put(count).put(" dimensions, would exceed maximum array dimensions (").put(32L).put(")");
        }
        this.shape.rshift(count);
        this.strides.rshift(count);
        for (int i = 0; i < count; ++i) {
            this.shape.setQuick(i, 1);
            this.strides.setQuick(i, 0);
        }
        this.type = ColumnType.encodeArrayType(this.getElemType(), this.getDimCount() + count);
    }

    public void slice(int dim, int lo, int hi) {
        assert (lo >= 0 && hi >= 0) : "lo and hi must be non-negative";
        int dimLen = this.getDimLen(dim);
        if (hi > dimLen) {
            hi = dimLen;
        }
        if (lo == 0 && hi == dimLen) {
            return;
        }
        if (this.isVanilla) {
            for (int i = 0; i < dim; ++i) {
                if (this.shape.getQuick(i) <= 1) continue;
                this.isVanilla = false;
            }
        }
        if (lo < hi) {
            this.flatViewOffset += lo * this.getStride(dim);
            this.flatViewLength = this.flatViewLength / dimLen * (hi - lo);
            this.shape.set(dim, hi - lo);
        } else {
            this.shape.set(dim, 0);
            this.isVanilla = true;
            this.flatViewLength = 0;
        }
    }

    public void subArray(int dim, int index) {
        this.slice(dim, index, index + 1);
        if (this.getDimLen(dim) != 0) {
            this.removeDim(dim);
        } else {
            this.ofNull();
        }
    }

    public void transpose() {
        if (this.isVanilla && this.getDimCount() > 1) {
            this.isVanilla = false;
        }
        this.strides.reverse();
        this.shape.reverse();
    }

    private void removeDim(int dim) {
        assert (dim >= 0 && dim < this.shape.size()) : "dim out of range: " + dim;
        this.shape.removeIndex(dim);
        this.strides.removeIndex(dim);
        this.type = ColumnType.encodeArrayType(this.getElemType(), this.getDimCount() - 1);
    }
}

