/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryMW;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.AnyRecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.O3PartitionPurgeTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableUtils {
    public static final int ANY_TABLE_VERSION = -1;
    public static final String ATTACHABLE_DIR_MARKER = ".attachable";
    public static final String CHECKPOINT_DIRECTORY = ".checkpoint";
    public static final String CHECKPOINT_LEGACY_META_FILE_NAME = "_snapshot";
    public static final String CHECKPOINT_LEGACY_META_FILE_NAME_TXT = "_snapshot.txt";
    public static final String CHECKPOINT_META_FILE_NAME = "_checkpoint_meta.d";
    public static final long COLUMN_NAME_TXN_NONE = -1L;
    public static final String COLUMN_VERSION_FILE_NAME = "_cv";
    public static final String DEFAULT_PARTITION_NAME = "default";
    public static final String DETACHED_DIR_MARKER = ".detached";
    public static final long ESTIMATED_VAR_COL_SIZE = 28L;
    public static final String FILE_SUFFIX_D = ".d";
    public static final String FILE_SUFFIX_I = ".i";
    public static final int INITIAL_TXN = 0;
    public static final String LEGACY_CHECKPOINT_DIRECTORY = "snapshot";
    public static final int LONGS_PER_TX_ATTACHED_PARTITION = 4;
    public static final int LONGS_PER_TX_ATTACHED_PARTITION_MSB = Numbers.msb(4);
    public static final long META_COLUMN_DATA_SIZE = 32L;
    public static final String META_FILE_NAME = "_meta";
    public static final short META_FORMAT_MINOR_VERSION_LATEST = 1;
    public static final long META_OFFSET_COLUMN_TYPES = 128L;
    public static final long META_OFFSET_COUNT = 0L;
    public static final long META_OFFSET_MAX_UNCOMMITTED_ROWS = 20L;
    public static final long META_OFFSET_METADATA_VERSION = 32L;
    public static final long META_OFFSET_O3_MAX_LAG = 24L;
    public static final long META_OFFSET_PARTITION_BY = 4L;
    public static final long META_OFFSET_TABLE_ID = 16L;
    public static final long META_OFFSET_TIMESTAMP_INDEX = 8L;
    public static final long META_OFFSET_VERSION = 12L;
    public static final long META_OFFSET_WAL_ENABLED = 40L;
    public static final long META_OFFSET_META_FORMAT_MINOR_VERSION = 41L;
    public static final long META_OFFSET_TTL_HOURS_OR_MONTHS = 45L;
    public static final String META_PREV_FILE_NAME = "_meta.prev";
    public static final String META_SWAP_FILE_NAME = "_meta.swp";
    public static final int MIN_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(4);
    public static final int NULL_LEN = -1;
    public static final String PARQUET_PARTITION_NAME = "data.parquet";
    public static final String RESTORE_FROM_CHECKPOINT_TRIGGER_FILE_NAME = "_restore";
    public static final String SYMBOL_KEY_REMAP_FILE_SUFFIX = ".r";
    public static final char SYSTEM_TABLE_NAME_SUFFIX = '~';
    public static final int TABLE_DOES_NOT_EXIST = 1;
    public static final int TABLE_EXISTS = 0;
    public static final String TABLE_NAME_FILE = "_name";
    public static final int TABLE_RESERVED = 2;
    public static final int TABLE_TYPE_MAT = 2;
    public static final int TABLE_TYPE_NON_WAL = 0;
    public static final int TABLE_TYPE_WAL = 1;
    public static final String TAB_INDEX_FILE_NAME = "_tab_index.d";
    public static final String TODO_FILE_NAME = "_todo_";
    public static final String TXN_FILE_NAME = "_txn";
    public static final String TXN_SCOREBOARD_FILE_NAME = "_txn_scoreboard";
    public static final int TX_BASE_HEADER_SECTION_PADDING = 12;
    public static final long TX_BASE_OFFSET_VERSION_64 = 0L;
    public static final long TX_BASE_OFFSET_A_32 = 8L;
    public static final long TX_BASE_OFFSET_SYMBOLS_SIZE_A_32 = 12L;
    public static final long TX_BASE_OFFSET_PARTITIONS_SIZE_A_32 = 16L;
    public static final long TX_BASE_OFFSET_B_32 = 32L;
    public static final long TX_BASE_OFFSET_SYMBOLS_SIZE_B_32 = 36L;
    public static final long TX_BASE_OFFSET_PARTITIONS_SIZE_B_32 = 40L;
    public static final int TX_BASE_HEADER_SIZE = (int)Math.max(56L, 64L);
    public static final long TX_OFFSET_MAP_WRITER_COUNT_32 = 128L;
    public static final long TX_OFFSET_TXN_64 = 0L;
    public static final long TX_OFFSET_TRANSIENT_ROW_COUNT_64 = 8L;
    public static final long TX_OFFSET_FIXED_ROW_COUNT_64 = 16L;
    public static final long TX_OFFSET_MIN_TIMESTAMP_64 = 24L;
    public static final long TX_OFFSET_MAX_TIMESTAMP_64 = 32L;
    public static final long TX_OFFSET_STRUCT_VERSION_64 = 40L;
    public static final long TX_OFFSET_DATA_VERSION_64 = 48L;
    public static final long TX_OFFSET_PARTITION_TABLE_VERSION_64 = 56L;
    public static final long TX_OFFSET_COLUMN_VERSION_64 = 64L;
    public static final long TX_OFFSET_TRUNCATE_VERSION_64 = 72L;
    public static final long TX_OFFSET_SEQ_TXN_64 = 80L;
    public static final long TX_OFFSET_CHECKSUM_32 = 88L;
    public static final long TX_OFFSET_LAG_TXN_COUNT_32 = 92L;
    public static final long TX_OFFSET_LAG_ROW_COUNT_32 = 96L;
    public static final long TX_OFFSET_LAG_MIN_TIMESTAMP_64 = 100L;
    public static final long TX_OFFSET_LAG_MAX_TIMESTAMP_64 = 108L;
    public static final int TX_RECORD_HEADER_SIZE = 132;
    public static final String UPGRADE_FILE_NAME = "_upgrade.d";
    static final int COLUMN_VERSION_FILE_HEADER_SIZE = 40;
    static final int META_FLAG_BIT_INDEXED = 1;
    static final int META_FLAG_BIT_SYMBOL_CACHE = 4;
    static final int META_FLAG_BIT_DEDUP_KEY = 8;
    static final byte TODO_RESTORE_META = 2;
    static final byte TODO_TRUNCATE = 1;
    private static final int EMPTY_TABLE_LAG_CHECKSUM = TableUtils.calculateTxnLagChecksum(0L, 0L, 0, Long.MAX_VALUE, Long.MIN_VALUE, 0);
    private static final Log LOG = LogFactory.getLog(TableUtils.class);
    private static final int MAX_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(0x800000);
    private static final int MAX_SYMBOL_CAPACITY = Numbers.ceilPow2(Integer.MAX_VALUE);
    private static final int MAX_SYMBOL_CAPACITY_CACHED = Numbers.ceilPow2(30000000);
    private static final int MIN_SYMBOL_CAPACITY = 2;

    private TableUtils() {
    }

    public static void allocateDiskSpace(FilesFacade ff, long fd, long size) {
        if (ff.length(fd) < size && !ff.allocate(fd, size)) {
            throw CairoException.critical(ff.errno()).put("No space left [size=").put(size).put(", fd=").put(fd).put(']');
        }
    }

    public static void allocateDiskSpaceToPage(FilesFacade ff, long fd, long size) {
        size = Files.ceilPageSize(size);
        TableUtils.allocateDiskSpace(ff, fd, size);
    }

    public static int calculateMetaFormatMinorVersionField(long metadataVersion, int columnCount) {
        return Numbers.encodeLowHighShorts(TableUtils.checksumForMetaFormatMinorVersionField(metadataVersion, columnCount), (short)1);
    }

    public static int calculateTxRecordSize(int bytesSymbols, int bytesPartitions) {
        return 132 + bytesSymbols + 4 + bytesPartitions;
    }

    public static int calculateTxnLagChecksum(long txn, long seqTxn, int lagRowCount, long lagMinTimestamp, long lagMaxTimestamp, int lagTxnCount) {
        long checkSum = lagMinTimestamp;
        checkSum = checkSum * 31L + lagMaxTimestamp;
        checkSum = checkSum * 31L + txn;
        checkSum = checkSum * 31L + seqTxn;
        checkSum = checkSum * 31L + (long)lagRowCount;
        checkSum = checkSum * 31L + (long)lagTxnCount;
        return (int)(checkSum ^ checkSum >>> 32);
    }

    public static int changeColumnTypeInMetadata(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, LowerCaseCharSequenceIntHashMap columnNameIndexMap, ObjList<TableColumnMetadata> columnMetadata) {
        int existingIndex = columnNameIndexMap.get(columnName);
        if (existingIndex < 0) {
            throw CairoException.nonCritical().put("cannot change type, column '").put(columnName).put("' does not exist");
        }
        String columnNameStr = columnMetadata.getQuick(existingIndex).getColumnName();
        int columnIndex = columnMetadata.size();
        columnMetadata.add(new TableColumnMetadata(columnNameStr, columnType, isIndexed, indexValueBlockCapacity, false, null, columnIndex, false, existingIndex + 1, symbolCacheFlag, symbolCapacity));
        columnMetadata.getQuick(existingIndex).markDeleted();
        columnNameIndexMap.put(columnNameStr, columnIndex);
        return existingIndex;
    }

    public static LPSZ charFileName(Path path, CharSequence columnName, long columnNameTxn) {
        path.concat(columnName).put(".c");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    public static long checkMemSize(MemoryMR metaMem, long minSize) {
        long memSize = metaMem.size();
        if (memSize < minSize) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(minSize);
        }
        return memSize;
    }

    public static short checksumForMetaFormatMinorVersionField(long metadataVersion, int columnCount) {
        int metaVersionInt = Numbers.decodeLowInt(metadataVersion) ^ Numbers.decodeHighInt(metadataVersion);
        int checksumInt = 13 * metaVersionInt + 37 * columnCount;
        short checksum = (short)(Numbers.decodeLowShort(checksumInt) ^ Numbers.decodeHighShort(checksumInt));
        if (checksum == 0) {
            checksum = -1337;
        }
        return (short)checksum;
    }

    public static int compressColumnCount(RecordMetadata metadata) {
        int count = 0;
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (metadata.getColumnType(i) <= 0) continue;
            ++count;
        }
        return count;
    }

    public static void createColumnVersionFile(MemoryMARW mem) {
        mem.extend(40L);
        mem.jumpTo(40L);
        mem.zero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createConvertFile(FilesFacade ff, Path path, byte walFlag) {
        long addr = 0L;
        long fd = -1L;
        try {
            fd = ff.openRW(path.concat("_convert").$(), 0);
            if (fd < 1L) {
                throw CairoException.critical(ff.errno()).put("Could not open file [path=").put(path).put(']');
            }
            addr = Unsafe.malloc(1L, 62);
            if (addr < 1L) {
                throw CairoException.critical(ff.errno()).put("Could not allocate 1 byte");
            }
            Unsafe.getUnsafe().putByte(addr, walFlag);
            ff.write(fd, addr, 1L, 0L);
        }
        finally {
            if (addr > 0L) {
                Unsafe.free(addr, 1L, 62);
            }
            ff.close(fd);
        }
    }

    @NotNull
    public static Function createCursorFunction(FunctionParser functionParser, @NotNull QueryModel model, @NotNull SqlExecutionContext executionContext) throws SqlException {
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        Function function = functionParser.parseFunction(tableNameExpr, AnyRecordMetadata.INSTANCE, executionContext);
        if (!ColumnType.isCursor(function.getType())) {
            Misc.free(function);
            throw SqlException.$(tableNameExpr.position, "function must return CURSOR");
        }
        return function;
    }

    public static void createTable(CairoConfiguration configuration, MemoryMARW memory, Path path, TableStructure structure, int tableVersion, int tableId, CharSequence dirName) {
        FilesFacade ff = configuration.getFilesFacade();
        String root = configuration.getDbRoot();
        int mkDirMode = configuration.getMkDirMode();
        TableUtils.createTable(ff, (CharSequence)root, mkDirMode, memory, path, structure, tableVersion, tableId, dirName);
    }

    public static void createTable(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, Path path, TableStructure structure, int tableVersion, int tableId, CharSequence dirName) {
        TableUtils.createTable(ff, root, mkDirMode, memory, path, dirName, structure, tableVersion, tableId);
    }

    public static void createTable(FilesFacade ff, CharSequence root, int mkDirMode, TableStructure structure, int tableVersion, int tableId, CharSequence dirName) {
        try (Path path = new Path();
             MemoryCMARW mem = Vm.getCMARWInstance();){
            TableUtils.createTable(ff, root, mkDirMode, (MemoryMARW)mem, path, dirName, structure, tableVersion, tableId);
        }
    }

    public static void createTable(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, Path path, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        TableUtils.createTableOrMatView(ff, root, mkDirMode, memory, null, path, tableDir, structure, tableVersion, tableId);
    }

    public static void createTableNameFile(MemoryMAR mem, CharSequence charSequence) {
        mem.putStr(charSequence);
        mem.putByte((byte)0);
        mem.sync(false);
        mem.close(true, (byte)1);
    }

    public static void createTableOrMatView(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, @Nullable BlockFileWriter blockFileWriter, Path path, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        LOG.debug().$("create table [name=").$safe(tableDir).I$();
        path.of(root).concat(tableDir).$();
        if (ff.isDirOrSoftLinkDir(path.$())) {
            throw CairoException.critical(ff.errno()).put("table directory already exists [path=").put(path).put(']');
        }
        int rootLen = path.size();
        boolean dirCreated = false;
        try {
            if (ff.mkdirs(path.slash(), mkDirMode) != 0) {
                throw CairoException.critical(ff.errno()).put("could not create [dir=").put(path.trimTo(rootLen).$()).put(']');
            }
            dirCreated = true;
            TableUtils.createTableOrMatViewFiles(ff, memory, blockFileWriter, path, rootLen, tableDir, structure, tableVersion, tableId);
        }
        catch (Throwable e) {
            if (dirCreated) {
                ff.rmdir(path.trimTo(rootLen).slash());
            }
            throw e;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static void createTableOrMatViewFiles(FilesFacade ff, MemoryMARW memory, @Nullable BlockFileWriter blockFileWriter, Path path, int rootLen, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        TableUtils.createTableOrMatViewFiles(ff, memory, blockFileWriter, path, rootLen, tableDir, structure, tableVersion, tableId, TXN_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableOrMatViewFiles(FilesFacade ff, MemoryMARW memory, @Nullable BlockFileWriter blockFileWriter, Path path, int rootLen, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId, CharSequence txnFileName) {
        long dirFd = !ff.isRestrictedFileSystem() ? TableUtils.openRONoCache(ff, path.trimTo(rootLen).$(), LOG) : 0L;
        try (MemoryMARW mem = memory;){
            mem.smallFile(ff, path.trimTo(rootLen).concat(META_FILE_NAME).$(), 0);
            mem.jumpTo(0L);
            int count = structure.getColumnCount();
            path.trimTo(rootLen);
            TableUtils.writeMetadata(structure, tableVersion, tableId, mem);
            mem.sync(false);
            int symbolMapCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!ColumnType.isSymbol(structure.getColumnType(i))) continue;
                MapWriter.createSymbolMapFiles(ff, mem, path.trimTo(rootLen), structure.getColumnName(i), -1L, structure.getSymbolCapacity(i), structure.getSymbolCacheFlag(i));
                ++symbolMapCount;
            }
            mem.smallFile(ff, path.trimTo(rootLen).concat(COLUMN_VERSION_FILE_NAME).$(), 0);
            TableUtils.createColumnVersionFile(mem);
            mem.sync(false);
            mem.close();
            TableUtils.resetTodoLog(ff, path, rootLen, mem);
            path.trimTo(rootLen).concat(TXN_SCOREBOARD_FILE_NAME).$();
            mem.smallFile(ff, path.trimTo(rootLen).concat(TABLE_NAME_FILE).$(), 0);
            TableUtils.createTableNameFile(mem, TableUtils.getTableNameFromDirName(tableDir));
            if (structure.isMatView()) {
                assert (blockFileWriter != null);
                try (BlockFileWriter writer = blockFileWriter;){
                    writer.of(path.trimTo(rootLen).concat("_mv").$());
                    MatViewDefinition.append(structure.getMatViewDefinition(), writer);
                }
            }
            mem.smallFile(ff, path.trimTo(rootLen).concat(txnFileName).$(), 0);
            TableUtils.createTxn(mem, symbolMapCount, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            mem.sync(false);
        }
        finally {
            if (dirFd > 0L) {
                ff.fsyncAndClose(dirFd);
            }
        }
    }

    public static void createTableOrMatViewInVolume(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, Path path, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        TableUtils.createTableOrMatViewInVolume(ff, root, mkDirMode, memory, null, path, tableDir, structure, tableVersion, tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableOrMatViewInVolume(FilesFacade ff, CharSequence root, int mkDirMode, MemoryMARW memory, @Nullable BlockFileWriter blockFileWriter, Path path, CharSequence tableDir, TableStructure structure, int tableVersion, int tableId) {
        LOG.info().$("create table in volume [path=").$(path).I$();
        Path normalPath = Path.getThreadLocal2(root).concat(tableDir);
        assert (normalPath != path);
        if (ff.isDirOrSoftLinkDir(normalPath.$())) {
            throw CairoException.critical(ff.errno()).put("table directory already exists [path=").put(normalPath).put(']');
        }
        if (ff.isDirOrSoftLinkDir(path.$())) {
            throw CairoException.critical(ff.errno()).put("table directory already exists in volume [path=").put(path).put(']');
        }
        int rootLen = path.size();
        try {
            if (ff.mkdirs(path.slash(), mkDirMode) != 0) {
                throw CairoException.critical(ff.errno()).put("could not create [dir=").put(path).put(']');
            }
            if (ff.softLink(path.trimTo(rootLen).$(), normalPath.$()) != 0) {
                if (!ff.rmdir(path.slash())) {
                    LOG.error().$("cannot remove table directory in volume [errno=").$(ff.errno()).$(", path=").$(path.trimTo(rootLen).$()).I$();
                }
                throw CairoException.critical(ff.errno()).put("could not create soft link [src=").put(path.trimTo(rootLen).$()).put(", tableDir=").put(tableDir).put(']');
            }
            TableUtils.createTableOrMatViewFiles(ff, memory, blockFileWriter, path, rootLen, tableDir, structure, tableVersion, tableId);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static void createTxn(MemoryMW txMem, int symbolMapCount, long txn, long seqTxn, long dataVersion, long partitionTableVersion, long structureVersion, long columnVersion, long truncateVersion) {
        txMem.putInt(8L, TX_BASE_HEADER_SIZE);
        txMem.putInt(12L, symbolMapCount * 8);
        txMem.putInt(16L, 0);
        TableUtils.resetTxn(txMem, TX_BASE_HEADER_SIZE, symbolMapCount, txn, seqTxn, dataVersion, partitionTableVersion, structureVersion, columnVersion, truncateVersion);
        txMem.setTruncateSize(TX_BASE_HEADER_SIZE + 132);
    }

    public static LPSZ dFile(Path path, @NotNull CharSequence columnName, long columnTxn) {
        path.concat(columnName).put(FILE_SUFFIX_D);
        if (columnTxn > -1L) {
            path.put('.').put(columnTxn);
        }
        return path.$();
    }

    public static LPSZ dFile(Path path, CharSequence columnName) {
        return TableUtils.dFile(path, columnName, -1L);
    }

    public static long estimateAvgRecordSize(RecordMetadata metadata) {
        long recSize = 0L;
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int columnType = metadata.getColumnType(i);
            if (ColumnType.isVarSize(columnType)) {
                recSize += 28L;
                continue;
            }
            if (columnType <= 0) continue;
            recSize += (long)ColumnType.sizeOf(columnType);
        }
        return recSize;
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name) {
        return TableUtils.exists(ff, path.of(root).concat(name));
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, Utf8Sequence name) {
        return TableUtils.exists(ff, path.of(root).concat(name));
    }

    public static int existsInVolume(FilesFacade ff, Path volumePath, CharSequence name) {
        return TableUtils.exists(ff, volumePath.concat(name));
    }

    public static void freeTransitionIndex(long address) {
        if (address == 0L) {
            return;
        }
        Unsafe.free(address, Unsafe.getUnsafe().getInt(address), 55);
    }

    public static int getColumnCount(MemoryMR metaMem, long offset) {
        int columnCount = metaMem.getInt(offset);
        if (columnCount < 0) {
            throw TableUtils.validationException(metaMem).put("Incorrect columnCount: ").put(columnCount);
        }
        return columnCount;
    }

    public static CharSequence getColumnName(MemoryMR metaMem, long memSize, long offset, int columnIndex) {
        int strLength = TableUtils.getInt(metaMem, memSize, offset);
        if (strLength == -1) {
            throw TableUtils.validationException(metaMem).put("NULL column name at [").put(columnIndex).put(']');
        }
        return TableUtils.getCharSequence(metaMem, memSize, offset, strLength);
    }

    public static long getColumnNameOffset(int columnCount) {
        return 128L + (long)columnCount * 32L;
    }

    public static int getColumnType(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L);
    }

    public static int getColumnType(MemoryMR metaMem, long memSize, long offset, int columnIndex) {
        int type = TableUtils.getInt(metaMem, memSize, offset);
        if (type >= 0 && ColumnType.sizeOf(type) == -1) {
            throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(columnIndex).put(']');
        }
        return type;
    }

    public static int getInt(MemoryR metaMem, long memSize, long offset) {
        if (memSize < offset + 4L) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(offset + 4L);
        }
        return metaMem.getInt(offset);
    }

    public static int getMaxUncommittedRows(TableRecordMetadata metadata, CairoEngine engine) {
        if (!metadata.isWalEnabled() && metadata instanceof TableWriterMetadata) {
            return ((TableWriterMetadata)metadata).getMaxUncommittedRows();
        }
        try (TableMetadata tableMetadata = engine.getTableMetadata(metadata.getTableToken());){
            int n = tableMetadata.getMaxUncommittedRows();
            return n;
        }
    }

    public static long getNullLong(int columnType, int longIndex) {
        switch (ColumnType.tagOf(columnType)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0L;
            }
            case 12: {
                return Numbers.encodeLowHighInts(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            case 9: {
                return Numbers.encodeLowHighInts(Float.floatToIntBits(Float.NaN), Float.floatToIntBits(Float.NaN));
            }
            case 10: {
                return Double.doubleToLongBits(Double.NaN);
            }
            case 5: {
                return Numbers.encodeLowHighInts(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 19: 
            case 24: 
            case 32: {
                return Long.MIN_VALUE;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return -1L;
            }
            case 25: {
                return 0L;
            }
            case 18: 
            case 26: {
                return -1L;
            }
            case 11: {
                return Numbers.encodeLowHighInts(-1, -1);
            }
            case 27: {
                return -1L;
            }
        }
        assert (false) : "Invalid column type: " + columnType;
        return 0L;
    }

    public static long getO3MaxLag(TableRecordMetadata metadata, CairoEngine engine) {
        if (!metadata.isWalEnabled()) {
            if (metadata instanceof TableWriterMetadata) {
                return ((TableWriterMetadata)metadata).getO3MaxLag();
            }
            try (TableMetadata tableMetadata = engine.getTableMetadata(metadata.getTableToken());){
                long l = tableMetadata.getO3MaxLag();
                return l;
            }
        }
        return 0L;
    }

    public static int getPartitionBy(TableRecordMetadata metadata, CairoEngine engine) {
        if (!metadata.isWalEnabled() && metadata instanceof TableWriterMetadata) {
            return ((TableWriterMetadata)metadata).getPartitionBy();
        }
        try (TableMetadata tableMetadata = engine.getTableMetadata(metadata.getTableToken());){
            int n = tableMetadata.getPartitionBy();
            return n;
        }
    }

    public static long getPartitionTableIndexOffset(long partitionTableOffset, int index) {
        return partitionTableOffset + 4L + (long)index * 8L;
    }

    public static long getPartitionTableSizeOffset(int symbolWriterCount) {
        return TableUtils.getSymbolWriterIndexOffset(symbolWriterCount);
    }

    public static int getReplacingColumnIndex(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L + 4L + 8L + 4L + 8L) - 1;
    }

    public static int getSymbolCapacity(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L + 4L + 8L + 4L);
    }

    public static long getSymbolWriterIndexOffset(int index) {
        return 132L + (long)index * 8L;
    }

    public static long getSymbolWriterTransientIndexOffset(int index) {
        return TableUtils.getSymbolWriterIndexOffset(index) + 4L;
    }

    @NotNull
    public static String getTableDir(boolean mangleDirNames, @NotNull String tableName, int tableId, boolean isWal) {
        Object dirName = tableName;
        if (isWal) {
            dirName = (String)dirName + "~";
            dirName = (String)dirName + tableId;
        } else if (mangleDirNames) {
            dirName = (String)dirName + "~";
        }
        return dirName;
    }

    public static CharSequence getTableNameFromDirName(CharSequence privateName) {
        int suffixIndex = Chars.indexOf(privateName, '~');
        if (suffixIndex == -1) {
            return privateName;
        }
        return Chars.toString(privateName).substring(0, suffixIndex);
    }

    public static int getTimestampIndex(MemoryMR metaMem, long offset, int columnCount) {
        int timestampIndex = metaMem.getInt(offset);
        if (timestampIndex < -1 || timestampIndex >= columnCount) {
            throw TableUtils.validationException(metaMem).put("Timestamp index is outside of range, timestampIndex=").put(timestampIndex);
        }
        return timestampIndex;
    }

    public static void handleMetadataLoadException(CharSequence tableName, long deadline, CairoException ex, MillisecondClock millisecondClock, long spinLockTimeout) {
        if (ex.errnoFileCannotRead()) {
            if (millisecondClock.getTicks() >= deadline) {
                throw CairoException.critical(ex.getErrno()).put("Metadata read timeout [src=writer, timeout=").put(spinLockTimeout).put("ms, err=").put(ex.getFlyweightMessage()).put(']');
            }
        } else {
            throw ex;
        }
        LOG.info().$("error reloading metadata [table=").$safe(tableName).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
        Os.pause();
    }

    public static LPSZ iFile(Path path, CharSequence columnName, long columnTxn) {
        path.concat(columnName).put(FILE_SUFFIX_I);
        if (columnTxn > -1L) {
            path.put('.').put(columnTxn);
        }
        return path.$();
    }

    public static LPSZ iFile(Path path, CharSequence columnName) {
        return TableUtils.iFile(path, columnName, -1L);
    }

    public static boolean isFinalTableName(String tableName, CharSequence tempTablePrefix) {
        return !Chars.startsWith((CharSequence)tableName, tempTablePrefix);
    }

    public static boolean isMatViewDefinitionFileExists(CairoConfiguration configuration, Path path, CharSequence dirName) {
        FilesFacade ff = configuration.getFilesFacade();
        path.of(configuration.getDbRoot()).concat(dirName).concat("_mv");
        return ff.exists(path.$());
    }

    public static boolean isMatViewStateFileExists(CairoConfiguration configuration, Path path, CharSequence dirName) {
        FilesFacade ff = configuration.getFilesFacade();
        path.of(configuration.getDbRoot()).concat(dirName).concat("_mv.s");
        return ff.exists(path.$());
    }

    public static boolean isMetaFormatUpToDate(MemoryR metaMem) {
        int metaFormatMinorVersionField = metaMem.getInt(41L);
        short savedChecksum = Numbers.decodeLowShort(metaFormatMinorVersionField);
        short actualChecksum = TableUtils.checksumForMetaFormatMinorVersionField(metaMem.getLong(32L), metaMem.getInt(0L));
        short savedMetaFormatMinorVersion = Numbers.decodeHighShort(metaFormatMinorVersionField);
        return savedChecksum == actualChecksum && savedMetaFormatMinorVersion >= 1;
    }

    public static boolean isSymbolCached(MemoryR metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 4L) != 0L;
    }

    public static boolean isValidColumnName(CharSequence columnName, int fsFileNameLimit) {
        int length = columnName.length();
        if (length > fsFileNameLimit) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = columnName.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\u007f': 
                case '\ufeff': {
                    return false;
                }
            }
        }
        return length > 0;
    }

    public static boolean isValidTableName(CharSequence tableName, int fsFileNameLimit) {
        int length = tableName.length();
        if (length > fsFileNameLimit) {
            return false;
        }
        block4: for (int i = 0; i < length; ++i) {
            char c = tableName.charAt(i);
            switch (c) {
                case '.': {
                    if (i != 0 && i != length - 1 && tableName.charAt(i - 1) != '.') continue block4;
                    return false;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\u007f': 
                case '\ufeff': {
                    return false;
                }
            }
        }
        return length > 0 && tableName.charAt(0) != ' ' && tableName.charAt(length - 1) != ' ';
    }

    public static int lengthOf(@Nullable CharSequence columnValue) {
        return columnValue != null ? columnValue.length() : -1;
    }

    public static long lock(FilesFacade ff, LPSZ path, boolean verbose) {
        if (Files.VIRTIO_FS_DETECTED && !ff.touch(path)) {
            if (verbose) {
                LOG.error().$("cannot touch '").$(path).$("' to lock [errno=").$(ff.errno()).I$();
            }
            return -1L;
        }
        long fd = ff.openRWNoCache(path, 0);
        if (fd == -1L) {
            if (verbose) {
                LOG.error().$("cannot open '").$(path).$("' to lock [errno=").$(ff.errno()).I$();
            }
            return -1L;
        }
        if (ff.lock(fd) != 0) {
            if (verbose) {
                LOG.error().$("cannot lock '").$(path).$("' [errno=").$(ff.errno()).$(", fd=").$(fd).I$();
            }
            ff.close(fd);
            return -1L;
        }
        if (verbose) {
            LOG.debug().$("locked '").$(path).$("' [fd=").$(fd).I$();
        }
        return fd;
    }

    public static long lock(FilesFacade ff, LPSZ path) {
        return TableUtils.lock(ff, path, true);
    }

    public static LPSZ lockName(Path path) {
        return path.put(".lock").$();
    }

    public static long mapAppendColumnBuffer(FilesFacade ff, long fd, long offset, long size, boolean rw, int memoryTag) {
        long alignedOffset = Files.floorPageSize(offset);
        long alignedExtraLen = offset - alignedOffset;
        long mapAddr = rw ? TableUtils.mapRWNoAlloc(ff, fd, size + alignedExtraLen, alignedOffset, memoryTag) : TableUtils.mapRO(ff, fd, size + alignedExtraLen, alignedOffset, memoryTag);
        ff.madvise(mapAddr, size + alignedExtraLen, rw ? Files.POSIX_MADV_RANDOM : Files.POSIX_MADV_SEQUENTIAL);
        return mapAddr + alignedExtraLen;
    }

    public static void mapAppendColumnBufferRelease(FilesFacade ff, long address, long offset, long size, int memoryTag) {
        long alignedOffset = Files.floorPageSize(offset);
        long alignedExtraLen = offset - alignedOffset;
        ff.munmap(address - alignedExtraLen, size + alignedExtraLen, memoryTag);
    }

    public static long mapRO(FilesFacade ff, long fd, long size, int memoryTag) {
        return TableUtils.mapRO(ff, fd, size, 0L, memoryTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapRO(FilesFacade ff, LPSZ path, Log log, long size, int memoryTag) {
        long fd = TableUtils.openRO(ff, path, log);
        try {
            long l = TableUtils.mapRO(ff, fd, size, memoryTag);
            return l;
        }
        finally {
            ff.close(fd);
        }
    }

    public static long mapRO(FilesFacade ff, long fd, long size, long offset, int memoryTag) {
        assert (fd != -1L);
        assert (offset % Files.PAGE_SIZE == 0L);
        long address = ff.mmap(fd, size, offset, 1, memoryTag);
        if (address == -1L) {
            throw CairoException.critical(ff.errno()).put("could not mmap ").put(" [size=").put(size).put(", offset=").put(offset).put(", fd=").put(fd).put(", memUsed=").put(Unsafe.getMemUsed()).put(", fileLen=").put(ff.length(fd)).put(']');
        }
        return address;
    }

    public static long mapRW(FilesFacade ff, long fd, long size, int memoryTag) {
        return TableUtils.mapRW(ff, fd, size, 0L, memoryTag);
    }

    public static long mapRW(FilesFacade ff, long fd, long size, long offset, int memoryTag) {
        assert (fd != -1L);
        assert (offset % Files.PAGE_SIZE == 0L);
        TableUtils.allocateDiskSpace(ff, fd, size + offset);
        return TableUtils.mapRWNoAlloc(ff, fd, size, offset, memoryTag);
    }

    public static long mapRWNoAlloc(FilesFacade ff, long fd, long size, long offset, int memoryTag) {
        long addr = ff.mmap(fd, size, offset, 2, memoryTag);
        if (addr > -1L) {
            return addr;
        }
        int errno = ff.errno();
        if (Os.type != 3 || errno != 112) {
            throw CairoException.critical(ff.errno()).put("could not mmap column [fd=").put(fd).put(", size=").put(size).put(']');
        }
        throw CairoException.critical(ff.errno()).put("No space left [size=").put(size).put(", fd=").put(fd).put(']');
    }

    public static long mapRWOrClose(FilesFacade ff, long fd, long size, int memoryTag) {
        try {
            return TableUtils.mapRW(ff, fd, size, memoryTag);
        }
        catch (CairoException e) {
            ff.close(fd);
            throw e;
        }
    }

    public static long mremap(FilesFacade ff, long fd, long prevAddress, long prevSize, long newSize, int mapMode, int memoryTag) {
        return TableUtils.mremap(ff, fd, prevAddress, prevSize, newSize, 0L, mapMode, memoryTag);
    }

    public static long mremap(FilesFacade ff, long fd, long prevAddress, long prevSize, long newSize, long offset, int mapMode, int memoryTag) {
        long page = ff.mremap(fd, prevAddress, prevSize, newSize, offset, mapMode, memoryTag);
        if (page == -1L) {
            int errno = ff.errno();
            throw CairoException.critical(errno).put("could not remap file [previousSize=").put(prevSize).put(", newSize=").put(newSize).put(", offset=").put(offset).put(", fd=").put(fd).put(']');
        }
        return page;
    }

    public static void msync(FilesFacade ff, long addr, long len, boolean async) {
        long alignedAddr = Files.floorPageSize(addr);
        long alignedExtraLen = addr - alignedAddr;
        ff.msync(alignedAddr, len + alignedExtraLen, async);
    }

    public static LPSZ offsetFileName(Path path, CharSequence columnName, long columnNameTxn) {
        path.concat(columnName).put(".o");
        if (columnNameTxn > -1L) {
            path.put('.').put(columnNameTxn);
        }
        return path.$();
    }

    public static void oldPartitionName(Path path, long txn) {
        path.put("-x-").put(txn);
    }

    public static long openAppend(FilesFacade ff, LPSZ path, Log log) {
        long fd = ff.openAppend(path);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).I$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open append [file=").put(path).put(']');
    }

    public static long openFileRWOrFail(FilesFacade ff, LPSZ path, int opts) {
        return TableUtils.openRW(ff, path, LOG, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openRO(FilesFacade ff, Path path, CharSequence fileName, Log log) {
        int rootLen = path.size();
        path.concat(fileName);
        try {
            long l = TableUtils.openRO(ff, path.$(), log);
            return l;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static long openRO(FilesFacade ff, LPSZ path, Log log) {
        long fd = ff.openRO(path);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).I$();
            return fd;
        }
        int errno = ff.errno();
        if (Files.errnoFileCannotRead(errno)) {
            throw CairoException.critical(errno).put("could not open, file does not exist: ").put(path).put(']');
        }
        throw CairoException.critical(errno).put("could not open read-only [file=").put(path).put(']');
    }

    public static long openRONoCache(FilesFacade ff, LPSZ path, Log log) {
        long fd = ff.openRONoCache(path);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).I$();
            return fd;
        }
        int errno = ff.errno();
        if (Files.errnoFileCannotRead(errno)) {
            throw CairoException.critical(errno).put("could not open, file does not exist: ").put(path).put(']');
        }
        throw CairoException.critical(errno).put("could not open read-only [file=").put(path).put(']');
    }

    public static long openRW(FilesFacade ff, LPSZ path, Log log, int opts) {
        long fd = ff.openRW(path, opts);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).I$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-write [file=").put(path).put(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openSmallFile(FilesFacade ff, Path path, int rootLen, MemoryMR metaMem, CharSequence fileName, int memoryTag) {
        path.concat(fileName);
        try {
            metaMem.smallFile(ff, path.$(), memoryTag);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static void overwriteTableNameFile(Path tablePath, MemoryMAR memory, FilesFacade ff, @NotNull CharSequence tableName) {
        Path nameFilePath = tablePath.concat(TABLE_NAME_FILE);
        memory.smallFile(ff, nameFilePath.$(), 12);
        memory.jumpTo(0L);
        TableUtils.createTableNameFile(memory, tableName);
        memory.close(true, (byte)1);
    }

    public static void populateRecordHashMap(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor cursor, Map map, RecordSink recordSink, RecordChain chain) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = map.withKey();
            key.put(record, recordSink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                long offset = chain.put(record, -1L);
                value.putLong(0, offset);
                value.putLong(1, offset);
                value.putLong(2, 1L);
                continue;
            }
            value.putLong(1, chain.put(record, value.getLong(1)));
            value.addLong(2, 1L);
        }
    }

    public static int readIntOrFail(FilesFacade ff, long fd, long offset, long tempMem8b, Path path) {
        if (ff.read(fd, tempMem8b, 4L, offset) != 4L) {
            throw CairoException.critical(ff.errno()).put("Cannot read: ").put(path);
        }
        return Unsafe.getUnsafe().getInt(tempMem8b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readLongAtOffset(FilesFacade ff, LPSZ path, long tempMem8b, long offset) {
        long fd = TableUtils.openRO(ff, path, LOG);
        try {
            long l = TableUtils.readLongOrFail(ff, fd, offset, tempMem8b, path);
            return l;
        }
        finally {
            ff.close(fd);
        }
    }

    public static long readLongOrFail(FilesFacade ff, long fd, long offset, long tempMem8b, @Nullable LPSZ path) {
        if (ff.read(fd, tempMem8b, 8L, offset) != 8L) {
            if (path != null) {
                throw CairoException.critical(ff.errno()).put("could not read long [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset);
            }
            throw CairoException.critical(ff.errno()).put("could not read long [fd=").put(fd).put(", offset=").put(offset);
        }
        return Unsafe.getUnsafe().getLong(tempMem8b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTableName(Path path, int rootLen, MemoryCMR mem, FilesFacade ff) {
        long fd = -1L;
        try {
            path.concat(TABLE_NAME_FILE);
            LPSZ $path = path.$();
            fd = ff.openRO($path);
            if (fd < 1L) {
                String string = null;
                return string;
            }
            long fileLen = ff.length(fd);
            if (fileLen > 4L) {
                int charLen = ff.readNonNegativeInt(fd, 0L);
                if ((long)charLen * 2L + 4L != fileLen - 1L) {
                    LOG.error().$("invalid table name file [path=").$(path).$(", headerLen=").$(charLen).$(", fileLen=").$(fileLen).I$();
                    String string = null;
                    return string;
                }
                mem.of(ff, $path, fileLen, fileLen, 0);
                String string = Chars.toString(mem.getStrA(0L));
                return string;
            }
            LOG.error().$("invalid table name file [path=").$(path).$(", fileLen=").$(fileLen).I$();
            String string = null;
            return string;
        }
        finally {
            path.trimTo(rootLen);
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(FilesFacade ff, LPSZ path1) {
        long fd = ff.openRO(path1);
        long bytes = 0L;
        long length = 0L;
        if (fd > -1L) {
            try {
                length = ff.length(fd);
                if (length > 0L && ff.read(fd, bytes = Unsafe.malloc(length, 19), length, 0L) == length) {
                    String string = Utf8s.stringFromUtf8Bytes(bytes, bytes + length);
                    return string;
                }
            }
            finally {
                if (bytes != 0L) {
                    Unsafe.free(bytes, length, 19);
                }
                ff.close(fd);
            }
        }
        return null;
    }

    public static void removeColumnFromMetadata(CharSequence columnName, LowerCaseCharSequenceIntHashMap columnNameIndexMap, ObjList<TableColumnMetadata> columnMetadata) {
        int columnIndex = columnNameIndexMap.get(columnName);
        if (columnIndex < 0) {
            throw CairoException.critical(0).put("Column not found: ").put(columnName);
        }
        columnNameIndexMap.remove(columnName);
        TableColumnMetadata deletedMeta = columnMetadata.getQuick(columnIndex);
        deletedMeta.markDeleted();
    }

    public static void renameColumnInMetadata(CharSequence columnName, CharSequence newName, LowerCaseCharSequenceIntHashMap columnNameIndexMap, ObjList<TableColumnMetadata> columnMetadata) {
        int columnIndex = columnNameIndexMap.get(columnName);
        if (columnIndex < 0) {
            throw CairoException.critical(0).put("Column not found: ").put(columnName);
        }
        String newNameStr = newName.toString();
        columnMetadata.getQuick(columnIndex).rename(newNameStr);
        columnNameIndexMap.removeEntry(columnName);
        columnNameIndexMap.put(newNameStr, columnIndex);
    }

    public static void renameOrFail(FilesFacade ff, LPSZ src, LPSZ dst) {
        if (ff.rename(src, dst) != 0) {
            throw CairoException.critical(ff.errno()).put("could not rename ").put(src).put(" -> ").put(dst);
        }
    }

    public static void resetTodoLog(FilesFacade ff, Path path, int rootLen, MemoryMARW mem) {
        mem.smallFile(ff, path.trimTo(rootLen).concat(TODO_FILE_NAME).$(), 0);
        mem.jumpTo(0L);
        mem.putLong(24L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(8L, 0L);
        mem.putLong(16L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(0L, 0L);
        mem.putLong(32L, 0L);
        mem.jumpTo(40L);
        mem.sync(false);
    }

    public static void resetTxn(MemoryMW txMem, long baseOffset, int symbolMapCount, long txn, long seqTxn, long dataVersion, long partitionTableVersion, long structureVersion, long columnVersion, long truncateVersion) {
        txMem.putLong(baseOffset + 0L, txn);
        txMem.putLong(baseOffset + 8L, 0L);
        txMem.putLong(baseOffset + 16L, 0L);
        txMem.putLong(baseOffset + 24L, Long.MAX_VALUE);
        txMem.putLong(baseOffset + 32L, Long.MIN_VALUE);
        txMem.putLong(baseOffset + 40L, structureVersion);
        txMem.putLong(baseOffset + 48L, dataVersion);
        txMem.putLong(baseOffset + 56L, partitionTableVersion);
        txMem.putLong(baseOffset + 64L, columnVersion);
        txMem.putLong(baseOffset + 72L, truncateVersion);
        txMem.putLong(baseOffset + 80L, seqTxn);
        txMem.putInt(baseOffset + 128L, symbolMapCount);
        txMem.putLong(baseOffset + 100L, Long.MAX_VALUE);
        txMem.putLong(baseOffset + 108L, Long.MIN_VALUE);
        txMem.putInt(baseOffset + 96L, 0);
        txMem.putInt(baseOffset + 92L, 0);
        txMem.putInt(baseOffset + 88L, EMPTY_TABLE_LAG_CHECKSUM);
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            txMem.putInt(baseOffset + offset, 0);
            txMem.putInt(baseOffset + (offset += 4L), 0);
        }
        txMem.putInt(baseOffset + TableUtils.getPartitionTableSizeOffset(symbolMapCount), 0);
    }

    public static void safeReadTxn(TxReader txReader, MillisecondClock clock, long spinLockTimeout) {
        long deadline = clock.getTicks() + spinLockTimeout;
        if (txReader.unsafeReadVersion() == txReader.getVersion()) {
            LOG.debug().$("checked clean txn, version ").$(txReader.getVersion()).$(", txn=").$(txReader.getTxn()).$();
            return;
        }
        while (true) {
            if (txReader.unsafeLoadAll()) {
                LOG.debug().$("loaded clean txn, version ").$(txReader.getVersion()).$(", offset=").$(txReader.getBaseOffset()).$(", size=").$(txReader.getRecordSize()).$(", txn=").$(txReader.getTxn()).$();
                return;
            }
            if (clock.getTicks() > deadline) {
                throw CairoException.critical(0).put("Transaction read timeout [src=writer, timeout=").put(spinLockTimeout).put("ms]");
            }
            LOG.debug().$("loaded __dirty__ txn, version ").$(txReader.getVersion()).$();
            Os.pause();
        }
    }

    public static boolean schedulePurgeO3Partitions(MessageBus messageBus, TableToken tableName, int partitionBy) {
        MPSequence seq = messageBus.getO3PurgeDiscoveryPubSeq();
        while (true) {
            long cursor;
            if ((cursor = seq.next()) > -1L) {
                O3PartitionPurgeTask task = messageBus.getO3PurgeDiscoveryQueue().get(cursor);
                task.of(tableName, partitionBy);
                seq.done(cursor);
                return true;
            }
            if (cursor == -1L) {
                return false;
            }
            Os.pause();
        }
    }

    public static void setNull(int columnType, long addr, long count) {
        switch (ColumnType.tagOf(columnType)) {
            case 1: 
            case 2: {
                Vect.memset(addr, count, 0);
                break;
            }
            case 14: {
                Vect.memset(addr, count, -1);
                break;
            }
            case 3: 
            case 4: {
                Vect.setMemoryShort(addr, (short)0, count);
                break;
            }
            case 15: {
                Vect.setMemoryShort(addr, (short)-1, count);
                break;
            }
            case 5: {
                Vect.setMemoryInt(addr, Integer.MIN_VALUE, count);
                break;
            }
            case 25: {
                Vect.setMemoryInt(addr, 0, count);
                break;
            }
            case 16: {
                Vect.setMemoryInt(addr, -1, count);
                break;
            }
            case 9: {
                Vect.setMemoryFloat(addr, Float.NaN, count);
                break;
            }
            case 12: {
                Vect.setMemoryInt(addr, Integer.MIN_VALUE, count);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count);
                break;
            }
            case 17: {
                Vect.setMemoryLong(addr, -1L, count);
                break;
            }
            case 10: {
                Vect.setMemoryDouble(addr, Double.NaN, count);
                break;
            }
            case 13: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count * 4L);
                break;
            }
            case 19: 
            case 24: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count * 2L);
                break;
            }
        }
    }

    public static void setPathForNativePartition(Path path, int partitionBy, long timestamp, long nameTxn) {
        TableUtils.setSinkForNativePartition(path.slash(), partitionBy, timestamp, nameTxn);
    }

    public static void setPathForParquetPartition(Path path, int partitionBy, long timestamp, long nameTxn) {
        TableUtils.setSinkForNativePartition(path.slash(), partitionBy, timestamp, nameTxn);
        path.concat(PARQUET_PARTITION_NAME);
    }

    public static void setSinkForNativePartition(CharSink<?> sink, int partitionBy, long timestamp, long nameTxn) {
        PartitionBy.setSinkForPartition(sink, partitionBy, timestamp);
        if (nameTxn > -1L) {
            sink.put('.').put(nameTxn);
        }
    }

    public static void setTxReaderPath(@NotNull TxReader reader, @NotNull Path path, int partitionBy) {
        reader.ofRO(path.concat(TXN_FILE_NAME).$(), partitionBy);
    }

    public static int toIndexKey(int symbolKey) {
        assert (symbolKey != Integer.MAX_VALUE);
        return symbolKey == Integer.MIN_VALUE ? 0 : symbolKey + 1;
    }

    public static void validateIndexValueBlockSize(int position, int indexValueBlockSize) throws SqlException {
        if (indexValueBlockSize < MIN_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "min index block capacity is ").put(MIN_INDEX_VALUE_BLOCK_SIZE);
        }
        if (indexValueBlockSize > MAX_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "max index block capacity is ").put(MAX_INDEX_VALUE_BLOCK_SIZE);
        }
    }

    public static void validateMeta(MemoryMR metaMem, LowerCaseCharSequenceIntHashMap nameIndex, int expectedVersion) {
        try {
            int timestampType;
            long memSize = TableUtils.checkMemSize(metaMem, 128L);
            TableUtils.validateMetaVersion(metaMem, 12L, expectedVersion);
            int columnCount = TableUtils.getColumnCount(metaMem, 0L);
            long offset = TableUtils.getColumnNameOffset(columnCount);
            if (memSize < offset) {
                throw TableUtils.validationException(metaMem).put("File is too small, column types are missing ").put(memSize);
            }
            int timestampIndex = TableUtils.getTimestampIndex(metaMem, 8L, columnCount);
            if (timestampIndex != -1 && !ColumnType.isTimestamp(timestampType = TableUtils.getColumnType(metaMem, timestampIndex))) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            for (int i = 0; i < columnCount; ++i) {
                int type = Math.abs(TableUtils.getColumnType(metaMem, i));
                if (ColumnType.sizeOf(type) == -1) {
                    throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(i).put(']');
                }
                if (!TableUtils.isColumnIndexed(metaMem, i)) continue;
                if (!ColumnType.isSymbol(type)) {
                    throw TableUtils.validationException(metaMem).put("Index flag is only supported for SYMBOL").put(" at [").put(i).put(']');
                }
                if (TableUtils.getIndexBlockCapacity(metaMem, i) >= 2) continue;
                throw TableUtils.validationException(metaMem).put("Invalid index value block capacity ").put(TableUtils.getIndexBlockCapacity(metaMem, i)).put(" at [").put(i).put(']');
            }
            int denseCount = 0;
            if (nameIndex != null) {
                for (int i = 0; i < columnCount; ++i) {
                    CharSequence name = TableUtils.getColumnName(metaMem, memSize, offset, i);
                    if (TableUtils.getColumnType(metaMem, i) < 0 || nameIndex.put(name, denseCount++)) {
                        offset += (long)Vm.getStorageLength(name);
                        continue;
                    }
                    throw TableUtils.validationException(metaMem).put("Duplicate column [name=").put(name).put("] at ").put(i);
                }
            }
        }
        catch (Throwable e) {
            if (nameIndex != null) {
                nameIndex.clear();
            }
            throw e;
        }
    }

    public static void validateMetaVersion(MemoryMR metaMem, long metaVersionOffset, int expectedVersion) {
        int metaVersion = metaMem.getInt(metaVersionOffset);
        if (expectedVersion != metaVersion) {
            throw TableUtils.validationException(metaMem).put("Metadata version does not match runtime version [expected=").put(expectedVersion).put(", actual=").put(metaVersion).put(']');
        }
    }

    public static void validateSymbolCapacity(int position, int symbolCapacity) throws SqlException {
        if (symbolCapacity < 2) {
            throw SqlException.$(position, "min symbol capacity is ").put(2);
        }
        if (symbolCapacity > MAX_SYMBOL_CAPACITY) {
            throw SqlException.$(position, "max symbol capacity is ").put(MAX_SYMBOL_CAPACITY);
        }
    }

    public static void validateSymbolCapacityCached(boolean isCached, int symbolCapacity, int cacheKeywordPosition) throws SqlException {
        if (isCached && symbolCapacity > MAX_SYMBOL_CAPACITY_CACHED) {
            throw SqlException.$(cacheKeywordPosition, "max cached symbol capacity is ").put(MAX_SYMBOL_CAPACITY_CACHED);
        }
    }

    public static CairoException validationException(MemoryMR mem) {
        return CairoException.critical(-100).put("Invalid metadata at fd=").put(mem.getFd()).put(". ");
    }

    public static CairoException validationException(MemoryR mem) {
        if (mem instanceof MemoryMR) {
            return CairoException.critical(-100).put("Invalid metadata at fd=").put(((MemoryMR)mem).getFd()).put(". ");
        }
        return CairoException.critical(-100).put("Invalid metadata. ");
    }

    public static void writeIntOrFail(FilesFacade ff, long fd, long offset, int value, long tempMem8b, Path path) {
        Unsafe.getUnsafe().putInt(tempMem8b, value);
        if (ff.write(fd, tempMem8b, 4L, offset) != 4L) {
            throw CairoException.critical(ff.errno()).put("could not write 8 bytes [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset).put(", value=").put(value).put(']');
        }
    }

    public static void writeLongOrFail(FilesFacade ff, long fd, long offset, long value, long tempMem8b, Path path) {
        Unsafe.getUnsafe().putLong(tempMem8b, value);
        if (ff.write(fd, tempMem8b, 8L, offset) != 8L) {
            throw CairoException.critical(ff.errno()).put("could not write 8 bytes [path=").put(path).put(", fd=").put(fd).put(", offset=").put(offset).put(", value=").put(value).put(']');
        }
    }

    public static void writeMetadata(TableStructure tableStruct, int tableVersion, int tableId, MemoryA mem) {
        int i;
        int count = tableStruct.getColumnCount();
        mem.putInt(count);
        mem.putInt(tableStruct.getPartitionBy());
        int timestampIndex = tableStruct.getTimestampIndex();
        assert (timestampIndex == -1 || timestampIndex >= 0 && timestampIndex < count && tableStruct.getColumnType(timestampIndex) == 8) : String.format("timestampIndex %d count %d columnType %d", timestampIndex, count, tableStruct.getColumnType(timestampIndex));
        mem.putInt(timestampIndex);
        mem.putInt(tableVersion);
        mem.putInt(tableId);
        mem.putInt(tableStruct.getMaxUncommittedRows());
        mem.putLong(tableStruct.getO3MaxLag());
        mem.putLong(0L);
        mem.putBool(tableStruct.isWalEnabled());
        mem.putInt(TableUtils.calculateMetaFormatMinorVersionField(0L, count));
        mem.putInt(tableStruct.getTtlHoursOrMonths());
        mem.jumpTo(128L);
        assert (count > 0);
        for (i = 0; i < count; ++i) {
            mem.putInt(tableStruct.getColumnType(i));
            long flags = 0L;
            if (tableStruct.isIndexed(i)) {
                flags |= 1L;
            }
            if (tableStruct.getSymbolCacheFlag(i)) {
                flags |= 4L;
            }
            if (tableStruct.isDedupKey(i)) {
                flags |= 8L;
            }
            mem.putLong(flags);
            mem.putInt(tableStruct.getIndexBlockCapacity(i));
            mem.putInt(tableStruct.getSymbolCapacity(i));
            mem.skip(12L);
        }
        for (i = 0; i < count; ++i) {
            mem.putStr(tableStruct.getColumnName(i));
        }
    }

    private static int exists(FilesFacade ff, Path path) {
        if (ff.exists(path.$())) {
            if (ff.exists(path.concat(TXN_FILE_NAME).$())) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private static CharSequence getCharSequence(MemoryMR metaMem, long memSize, long offset, int strLength) {
        if (strLength < 1 || strLength > 255) {
            throw TableUtils.validationException(metaMem).put("String length of ").put(strLength).put(" is invalid at offset ").put(offset);
        }
        long storageLength = Vm.getStorageLength(strLength);
        if (offset + storageLength > memSize) {
            throw CairoException.critical(0).put("File is too small, size=").put(memSize).put(", required=").put(offset + storageLength);
        }
        return metaMem.getStrA(offset);
    }

    static boolean assertTimestampInOrder(long srcTimestampAddr, long srcDataMax) {
        long prev = Long.MIN_VALUE;
        for (long i = 0L; i < srcDataMax; ++i) {
            long newTs = Unsafe.getUnsafe().getLong(srcTimestampAddr + i * 8L);
            if (newTs < prev) {
                return false;
            }
            prev = newTs;
        }
        return true;
    }

    static void buildColumnListFromMetadataFile(MemoryR metaMem, int columnCount, IntList targetList) {
        int nameOffset = (int)TableUtils.getColumnNameOffset(columnCount);
        targetList.clear();
        int denseSymbolIndex = 0;
        for (int i = 0; i < columnCount; ++i) {
            int strLen = TableUtils.getInt(metaMem, metaMem.size(), nameOffset);
            if (strLen == -1) {
                throw TableUtils.validationException(metaMem).put("NULL column name at [").put(i).put(']');
            }
            if (strLen < 1 || strLen > 255) {
                throw TableUtils.validationException(metaMem).put("String length of ").put(strLen).put(" is invalid at offset ").put(nameOffset);
            }
            int nameLen = (int)Vm.getStorageLength(strLen);
            int replacingColumnIndex = TableUtils.getReplacingColumnIndex(metaMem, i);
            boolean isSymbol = ColumnType.isSymbol(TableUtils.getColumnType(metaMem, i));
            if (replacingColumnIndex > -1 && replacingColumnIndex < columnCount - 1) {
                targetList.set(3 * replacingColumnIndex, i);
                targetList.set(3 * replacingColumnIndex + 1, nameOffset);
                targetList.set(3 * replacingColumnIndex + 2, isSymbol ? denseSymbolIndex : -1);
                targetList.add(-replacingColumnIndex - 1);
                targetList.add(0);
                targetList.add(0);
            } else {
                targetList.add(i);
                targetList.add(nameOffset);
                targetList.add(isSymbol ? denseSymbolIndex : -1);
            }
            nameOffset += nameLen;
            if (!isSymbol) continue;
            ++denseSymbolIndex;
        }
    }

    static void createDirsOrFail(FilesFacade ff, Path path, int mkDirMode) {
        if (ff.mkdirs(path, mkDirMode) != 0) {
            throw CairoException.critical(ff.errno()).put("could not create directories [file=").put(path).put(']');
        }
    }

    static long getColumnFlags(MemoryR metaMem, int columnIndex) {
        return metaMem.getLong(128L + (long)columnIndex * 32L + 4L);
    }

    static int getIndexBlockCapacity(MemoryR metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 32L + 4L + 8L);
    }

    static int getTtlHoursOrMonths(MemoryR metaMem) {
        return TableUtils.isMetaFormatUpToDate(metaMem) ? metaMem.getInt(45L) : 0;
    }

    static boolean isColumnDedupKey(MemoryR metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 8L) != 0L;
    }

    static boolean isColumnIndexed(MemoryR metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 1L) != 0L;
    }

    static int openMetaSwapFile(FilesFacade ff, MemoryMA mem, Path path, int rootLen, int retryCount) {
        try {
            path.concat(META_SWAP_FILE_NAME).$();
            int l = path.size();
            int index = 0;
            while (true) {
                LPSZ lpsz;
                if (index > 0) {
                    path.trimTo(l).put('.').put(index);
                }
                if (ff.removeQuiet(lpsz = path.$())) {
                    try {
                        mem.smallFile(ff, lpsz, 0);
                        mem.jumpTo(0L);
                        int n = index;
                        return n;
                    }
                    catch (CairoException e) {
                        LOG.error().$("could not open swap [file=").$(path).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                        continue;
                    }
                }
                LOG.error().$("could not remove swap [file=").$(path).$(", errno=").$(ff.errno()).I$();
                {
                    if (++index < retryCount) continue;
                    throw CairoException.critical(0).put("Cannot open indexed file. Max number of attempts reached [").put(index).put("]. Last file tried: ").put(path);
                }
                break;
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public static interface FailureCloseable {
        public void close(long var1);
    }
}

