/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GrowOnlyTableNameRegistryStore;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TableNameRegistryStore
extends GrowOnlyTableNameRegistryStore {
    private static final Log LOG = LogFactory.getLog(TableNameRegistryStore.class);
    private final CairoConfiguration configuration;
    private final StringSink nameSink = new StringSink();
    private final TableFlagResolver tableFlagResolver;
    private final MemoryCMR tableNameRoMemory = Vm.getCMRInstance();
    private long lockFd = -1L;
    private long longBuffer;

    public TableNameRegistryStore(CairoConfiguration configuration, TableFlagResolver tableFlagResolver) {
        super(configuration.getFilesFacade());
        this.configuration = configuration;
        this.tableFlagResolver = tableFlagResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findLastTablesFileVersion(FilesFacade ff, Path path, StringSink nameSink) {
        long findPtr = ff.findFirst(path.$());
        if (findPtr == 0L) {
            throw CairoException.critical(0).put("database root directory does not exist at ").put(path);
        }
        try {
            int lastVersion = 0;
            do {
                long pUtf8NameZ = ff.findName(findPtr);
                if (ff.findType(findPtr) != 8) continue;
                nameSink.clear();
                boolean validUtf8 = Utf8s.utf8ToUtf16Z(pUtf8NameZ, nameSink);
                assert (validUtf8) : "invalid UTF-8 in file name";
                if (!Chars.startsWith((CharSequence)nameSink, "tables.d") || nameSink.length() <= "tables.d".length() + 1) continue;
                try {
                    int version = Numbers.parseInt(nameSink, "tables.d".length() + 1, nameSink.length());
                    if (version <= lastVersion) continue;
                    lastVersion = version;
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            } while (ff.findNext(findPtr) > 0);
            int n = lastVersion;
            return n;
        }
        finally {
            ff.findClose(findPtr);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.lockFd != -1L) {
            this.configuration.getFilesFacade().close(this.lockFd);
            this.lockFd = -1L;
        }
    }

    public boolean isLocked() {
        return this.lockFd != -1L;
    }

    public boolean lock() {
        LPSZ path;
        if (this.lockFd != -1L) {
            throw CairoException.critical(0).put("table registry already locked");
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        if (ff.exists(path = Path.getThreadLocal(this.configuration.getDbRoot()).concat("tables.d").put(".lock").$())) {
            ff.touch(path);
        }
        this.lockFd = TableUtils.lock(ff, path);
        return this.lockFd != -1L;
    }

    public boolean reload(ConcurrentHashMap<TableToken> tableNameToTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTokenMap, @Nullable ObjList<TableToken> convertedTables) {
        boolean consistent = this.reloadFromTablesFile(tableNameToTokenMap, dirNameToTokenMap, convertedTables);
        this.reloadFromRootDirectory(tableNameToTokenMap, dirNameToTokenMap);
        return consistent;
    }

    public synchronized void resetMemory() {
        if (!this.isLocked() && !this.lock()) {
            throw CairoException.critical(0).put("table registry is not locked");
        }
        this.tableNameMemory.close();
        LPSZ path = Path.getThreadLocal(this.configuration.getDbRoot()).concat("tables.d").put(".0").$();
        this.configuration.getFilesFacade().remove(path);
        this.tableNameMemory.smallFile(this.configuration.getFilesFacade(), path, 0);
    }

    @Override
    public void writeEntry(TableToken tableToken, int operation) {
        if (!this.isLocked()) {
            throw CairoException.critical(0).put("table registry is not locked");
        }
        super.writeEntry(tableToken, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkWalTableInPendingDropState(TableToken tableToken, FilesFacade ff, Path path, int plimit) {
        if (this.longBuffer == 0L) {
            this.longBuffer = Unsafe.malloc(8L, 19);
        }
        path.trimTo(plimit).concat(tableToken.getDirName()).concat("txn_seq").concat("_meta");
        long seqMetaFd = ff.openRO(path.$());
        if (seqMetaFd == -1L) {
            LOG.error().$("cannot open seq meta file, assume table is being dropped [path=").$(path).I$();
            return true;
        }
        try {
            if (ff.read(seqMetaFd, this.longBuffer, 8L, 8L) == 8L) {
                long structureVersion = Unsafe.getUnsafe().getLong(this.longBuffer);
                boolean bl = structureVersion == -2L;
                return bl;
            }
            LOG.error().$("cannot read structure version, assume table is being dropped [path=").$(path).I$();
            boolean bl = true;
            return bl;
        }
        finally {
            ff.close(seqMetaFd);
        }
    }

    private void clearRegistryToReloadFromFileSystem(ConcurrentHashMap<TableToken> tableNameToTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap, int lastFileVersion, String errorTableName, String errorDirName, TableToken conflictTableToken) {
        LOG.critical().$("duplicate table dir to name mapping found [tableName=").$safe(errorTableName).$(", dirName1=").$(conflictTableToken.getDirNameUtf8()).$(", dirName2=").$safe(errorDirName).I$();
        this.dumpTableRegistry(lastFileVersion);
        if (this.isLocked()) {
            this.tableNameMemory.putLong(0L, 8L);
            this.tableNameMemory.jumpTo(8L);
        }
        tableNameToTableTokenMap.clear();
        dirNameToTableTokenMap.clear();
    }

    private void compactTableNameFile(Map<CharSequence, TableToken> nameTableTokenMap, Map<CharSequence, ReverseTableMapItem> reverseNameMap, int lastFileVersion, FilesFacade ff, Path path) {
        int pathRootLen = path.size();
        path.concat("tables.d").putAscii(".tmp");
        this.tableNameMemory.close(false);
        this.tableNameMemory.smallFile(ff, path.$(), 0);
        this.tableNameMemory.putLong(0L);
        for (ReverseTableMapItem reverseMapItem : reverseNameMap.values()) {
            if (!reverseMapItem.isDropped()) continue;
            this.writeEntry(reverseMapItem.getToken(), 0);
            this.writeEntry(reverseMapItem.getToken(), -1);
        }
        for (TableToken token : nameTableTokenMap.values()) {
            this.writeEntry(token, 0);
        }
        this.tableNameMemory.sync(false);
        long newAppendOffset = this.tableNameMemory.getAppendOffset();
        this.tableNameMemory.close();
        LPSZ path2 = Path.getThreadLocal2(this.configuration.getDbRoot()).concat("tables.d").put('.').put(lastFileVersion + 1).$();
        if (ff.rename(path.$(), path2) == 0) {
            LOG.info().$("compacted tables file [path=").$(path2).I$();
            long currentOffset = newAppendOffset;
            path.trimTo(pathRootLen).concat("tables.d").putAscii('.').put(++lastFileVersion - 1);
            ff.removeQuiet(path.$());
            path.trimTo(pathRootLen).concat("tables.d").putAscii('.').put(lastFileVersion);
            this.tableNameMemory.smallFile(ff, path.$(), 0);
            this.tableNameMemory.jumpTo(currentOffset);
        } else {
            path2 = Path.getThreadLocal2(this.configuration.getDbRoot()).concat("tables.d").put('.').put(lastFileVersion).$();
            this.tableNameMemory.smallFile(ff, path2, 0);
            long appendOffset = this.tableNameMemory.getLong(0L);
            this.tableNameMemory.jumpTo(appendOffset);
            LOG.error().$("could not rename tables file, tables file will not be compacted [from=").$(path).$(", to=").$(path2).I$();
        }
    }

    private void dumpTableRegistry(int lastFileVersion) {
        MemoryMR memory = this.isLocked() ? this.tableNameMemory : this.tableNameRoMemory;
        long mapMem = memory.getLong(0L);
        long currentOffset = 8L;
        LOG.advisoryW().$("dumping table registry [file=").$("tables.d").$('.').$(lastFileVersion).$(", size=").$(mapMem).I$();
        while (currentOffset < mapMem) {
            int operation = memory.getInt(currentOffset);
            String tableName = Chars.toString(memory.getStrA(currentOffset += 4L));
            String dirName = Chars.toString(memory.getStrA(currentOffset += (long)Vm.getStorageLength(tableName)));
            int tableId = memory.getInt(currentOffset += (long)Vm.getStorageLength(dirName));
            int tableType = memory.getInt(currentOffset += 4L);
            currentOffset += 4L;
            LOG.advisoryW().$("operation=").$(operation == 0 ? "add (" : "remove (").$(operation).$("), tableName=").$safe(tableName).$(", dirName=").$safe(dirName).$(", tableId=").$(tableId).$(", tableType=").$(tableType).$(']').$();
            if (operation != 0) continue;
            currentOffset += 64L;
        }
        LOG.advisoryW().$("table registry dump complete").$();
    }

    private int findLastTablesFileVersion(FilesFacade ff, Path path) {
        return TableNameRegistryStore.findLastTablesFileVersion(ff, path, this.nameSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTableId(Path path, CharSequence dirName, FilesFacade ff) {
        path.of(this.configuration.getDbRoot()).concat(dirName).concat("_meta");
        long fd = ff.openRO(path.$());
        if (fd < 1L) {
            return 0;
        }
        try {
            int tableId = ff.readNonNegativeInt(fd, 16L);
            if (tableId < 0) {
                LOG.error().$("cannot read table id from metadata file [path=").$(path).I$();
                int n = 0;
                return n;
            }
            byte isWal = (byte)(ff.readNonNegativeInt(fd, 40L) & 0xFF);
            int n = isWal == 0 ? tableId : -tableId;
            return n;
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadFromRootDirectory(ConcurrentHashMap<TableToken> tableNameToTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap) {
        Path path = Path.getThreadLocal(this.configuration.getDbRoot());
        int plimit = path.size();
        FilesFacade ff = this.configuration.getFilesFacade();
        long findPtr = ff.findFirst(path.$());
        try {
            Utf8StringSink dirNameSink = Misc.getThreadLocalUtf8Sink();
            do {
                String tableName;
                boolean isWal;
                int tableId;
                String dirName;
                if (!ff.isDirOrSoftLinkDirNoDots(path, plimit, ff.findName(findPtr), ff.findType(findPtr), dirNameSink) || dirNameToTableTokenMap.containsKey(dirName = Utf8s.toString(dirNameSink)) || TableUtils.exists(ff, path, (CharSequence)this.configuration.getDbRoot(), dirNameSink) != 0) continue;
                try {
                    tableId = this.readTableId(path, dirName, ff);
                    isWal = tableId < 0;
                    tableId = Math.abs(tableId);
                    tableName = TableUtils.readTableName(path.of(this.configuration.getDbRoot()).concat(dirNameSink), plimit, this.tableNameRoMemory, ff);
                }
                catch (CairoException e) {
                    if (e.errnoFileCannotRead()) continue;
                    throw e;
                }
                finally {
                    this.tableNameRoMemory.close();
                }
                if (tableName == null) {
                    LOG.info().$("could not read table name, table will use directory name [dirName=").$(dirNameSink).I$();
                    tableName = Chars.toString(TableUtils.getTableNameFromDirName(dirName));
                }
                if ((long)tableId <= -1L) continue;
                boolean isProtected = this.tableFlagResolver.isProtected(tableName);
                boolean isSystem = this.tableFlagResolver.isSystem(tableName);
                boolean isPublic = this.tableFlagResolver.isPublic(tableName);
                boolean isMatView = TableUtils.isMatViewDefinitionFileExists(this.configuration, path, dirName);
                TableToken token = new TableToken(tableName, dirName, tableId, isMatView, isWal, isSystem, isProtected, isPublic);
                TableToken existingTableToken = tableNameToTableTokenMap.get(tableName);
                if (existingTableToken != null) {
                    if (this.resolveTableNameConflict(tableNameToTableTokenMap, dirNameToTableTokenMap, token, existingTableToken, ff, path, plimit)) continue;
                    LOG.critical().$("duplicate table name found, table will not be available [dirName=").$(dirNameSink).$(", name=").$safe(tableName).$(", existingTableDir=").$(tableNameToTableTokenMap.get(tableName).getDirNameUtf8()).I$();
                    continue;
                }
                tableNameToTableTokenMap.put(tableName, token);
                dirNameToTableTokenMap.put(dirName, ReverseTableMapItem.of(token));
            } while (ff.findNext(findPtr) > 0);
        }
        finally {
            ff.findClose(findPtr);
            if (this.longBuffer != 0L) {
                this.longBuffer = Unsafe.free(this.longBuffer, 8L, 19);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean reloadFromTablesFile(ConcurrentHashMap<TableToken> tableNameToTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap, @Nullable ObjList<TableToken> convertedTables) {
        int lastFileVersion;
        FilesFacade ff = this.configuration.getFilesFacade();
        Path path = Path.getThreadLocal(this.configuration.getDbRoot());
        int plimit = path.size();
        MemoryMR memory = this.isLocked() ? this.tableNameMemory : this.tableNameRoMemory;
        while (true) {
            lastFileVersion = this.findLastTablesFileVersion(ff, path.trimTo(plimit));
            path.trimTo(plimit).concat("tables.d").putAscii('.').put(lastFileVersion).$();
            try {
                memory.smallFile(ff, path.$(), 0);
                LOG.info().$("reloading tables file [path=").$(path).$(", threadId=").$(Thread.currentThread().getId()).I$();
                if (memory.size() < 16L) continue;
            }
            catch (CairoException e) {
                if (this.isLocked() || !e.errnoFileCannotRead()) throw e;
                if (lastFileVersion == 0) return false;
                continue;
            }
            break;
        }
        long mapMem = memory.getLong(0L);
        long currentOffset = 8L;
        memory.extend(mapMem);
        int forceCompact = 0x3FFFFFFF;
        int tableToCompact = 0;
        while (currentOffset < mapMem) {
            boolean isWal;
            boolean isMatView;
            boolean isPublic;
            boolean isSystem;
            boolean isProtected;
            int operation = memory.getInt(currentOffset);
            String tableName = Chars.toString(memory.getStrA(currentOffset += 4L));
            String dirName = Chars.toString(memory.getStrA(currentOffset += (long)Vm.getStorageLength(tableName)));
            int tableId = memory.getInt(currentOffset += (long)Vm.getStorageLength(dirName));
            int tableType = memory.getInt(currentOffset += 4L);
            currentOffset += 4L;
            if (operation == -1) {
                TableToken token = tableNameToTableTokenMap.remove(tableName);
                if (!ff.exists(path.trimTo(plimit).concat(dirName).$())) {
                    ++tableToCompact;
                    dirNameToTableTokenMap.remove(dirName);
                    continue;
                }
                if (token == null) {
                    isProtected = this.tableFlagResolver.isProtected(tableName);
                    isSystem = this.tableFlagResolver.isSystem(tableName);
                    isPublic = this.tableFlagResolver.isPublic(tableName);
                    isMatView = tableType == 2;
                    isWal = tableType == 1 || isMatView;
                    token = new TableToken(tableName, dirName, tableId, isMatView, isWal, isSystem, isProtected, isPublic);
                }
                dirNameToTableTokenMap.put(dirName, ReverseTableMapItem.ofDropped(token));
                continue;
            }
            assert (operation == 0);
            if (TableUtils.exists(ff, path, (CharSequence)this.configuration.getDbRoot(), dirName) != 0) {
                ++tableToCompact;
            } else {
                TableToken existing = tableNameToTableTokenMap.get(tableName);
                if (existing != null) {
                    this.clearRegistryToReloadFromFileSystem(tableNameToTableTokenMap, dirNameToTableTokenMap, lastFileVersion, tableName, dirName, existing);
                    return false;
                }
                isProtected = this.tableFlagResolver.isProtected(tableName);
                isSystem = this.tableFlagResolver.isSystem(tableName);
                isPublic = this.tableFlagResolver.isPublic(tableName);
                isMatView = tableType == 2;
                isWal = tableType == 1 || isMatView;
                TableToken token = new TableToken(tableName, dirName, tableId, isMatView, isWal, isSystem, isProtected, isPublic);
                tableNameToTableTokenMap.put(tableName, token);
                if (!Chars.startsWith((CharSequence)token.getDirName(), token.getTableName())) {
                    LOG.debug().$("table dir name does not match logical name [table=").$safe(tableName).$(", dirName=").$safe(dirName).I$();
                }
                dirNameToTableTokenMap.put(token.getDirName(), ReverseTableMapItem.of(token));
            }
            currentOffset += 64L;
        }
        if (this.isLocked()) {
            int tableRegistryCompactionThreshold;
            this.tableNameMemory.jumpTo(currentOffset);
            if (convertedTables != null) {
                int n = convertedTables.size();
                for (int i = 0; i < n; ++i) {
                    TableToken token = convertedTables.get(i);
                    TableToken existing = tableNameToTableTokenMap.get(token.getTableName());
                    if (existing != null && !Chars.equals(existing.getDirName(), token.getDirName())) {
                        this.clearRegistryToReloadFromFileSystem(tableNameToTableTokenMap, dirNameToTableTokenMap, lastFileVersion, token.getTableName(), token.getDirName(), existing);
                        return false;
                    }
                    if (token.isWal()) {
                        tableNameToTableTokenMap.put(token.getTableName(), token);
                        dirNameToTableTokenMap.put(token.getDirName(), ReverseTableMapItem.of(token));
                    } else {
                        tableNameToTableTokenMap.remove(token.getTableName());
                        dirNameToTableTokenMap.remove(token.getDirName());
                    }
                    tableToCompact = forceCompact;
                }
            }
            if ((tableRegistryCompactionThreshold = this.configuration.getTableRegistryCompactionThreshold()) > -1 && tableToCompact > tableRegistryCompactionThreshold || tableToCompact >= forceCompact) {
                path.trimTo(plimit);
                LOG.info().$("compacting tables file").$();
                this.compactTableNameFile(tableNameToTableTokenMap, dirNameToTableTokenMap, lastFileVersion, ff, path);
                return true;
            } else {
                this.tableNameMemory.jumpTo(currentOffset);
            }
            return true;
        } else {
            this.tableNameRoMemory.close();
        }
        return true;
    }

    private boolean resolveTableNameConflict(ConcurrentHashMap<TableToken> tableNameToTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap, TableToken newToken, TableToken existingTableToken, FilesFacade ff, Path path, int plimit) {
        boolean existingDropped = false;
        boolean newDropped = false;
        if (existingTableToken.isWal()) {
            existingDropped = this.checkWalTableInPendingDropState(existingTableToken, ff, path, plimit);
        }
        if (!existingDropped) {
            if (newToken.isWal()) {
                newDropped = this.checkWalTableInPendingDropState(newToken, ff, path, plimit);
            }
        } else {
            tableNameToTableTokenMap.remove(existingTableToken.getTableName());
            dirNameToTableTokenMap.remove(existingTableToken.getDirName());
            dirNameToTableTokenMap.put(existingTableToken.getDirName(), ReverseTableMapItem.ofDropped(existingTableToken));
            tableNameToTableTokenMap.put(newToken.getTableName(), newToken);
            dirNameToTableTokenMap.put(newToken.getDirName(), ReverseTableMapItem.of(newToken));
            return true;
        }
        return newDropped;
    }
}

