/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryOM;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.LPSZ;

public class StringTypeDriver
implements ColumnTypeDriver {
    public static final StringTypeDriver INSTANCE = new StringTypeDriver();

    public static void appendValue(MemoryA auxMem, MemoryA dataMem, CharSequence value) {
        auxMem.putLong(dataMem.putStr(value));
    }

    @Override
    public void appendNull(MemoryA auxMem, MemoryA dataMem) {
        auxMem.putLong(dataMem.putNullStr());
    }

    @Override
    public long auxRowsToBytes(long rowCount) {
        return rowCount << 3;
    }

    @Override
    public void configureAuxMemMA(MemoryMA auxMem) {
        auxMem.putLong(0L);
    }

    @Override
    public void configureAuxMemMA(FilesFacade ff, MemoryMA auxMem, LPSZ fileName, long dataAppendPageSize, int memoryTag, int opts, int madviseOpts) {
        auxMem.of(ff, fileName, dataAppendPageSize, -1L, 12, opts, madviseOpts);
        auxMem.putLong(0L);
    }

    @Override
    public void configureAuxMemO3RSS(MemoryARW auxMem) {
        auxMem.putLong(0L);
    }

    @Override
    public void configureAuxMemOM(FilesFacade ff, MemoryOM auxMem, long fd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        auxMem.ofOffset(ff, fd, false, fileName, rowLo << 3, rowHi + 1L << 3, memoryTag, opts);
    }

    @Override
    public void configureDataMemOM(FilesFacade ff, MemoryR auxMem, MemoryOM dataMem, long dataFd, LPSZ fileName, long rowLo, long rowHi, int memoryTag, int opts) {
        dataMem.ofOffset(ff, dataFd, false, fileName, auxMem.getLong(rowLo << 3), auxMem.getLong(rowHi << 3), memoryTag, opts);
    }

    @Override
    public long dedupMergeVarColumnSize(long mergeIndexAddr, long mergeIndexCount, long srcDataFixAddr, long srcOooFixAddr) {
        return Vect.dedupMergeStrBinColumnSize(mergeIndexAddr, mergeIndexCount, srcDataFixAddr, srcOooFixAddr);
    }

    @Override
    public long getAuxVectorOffset(long row) {
        return row << 3;
    }

    @Override
    public long getAuxVectorSize(long storageRowCount) {
        return storageRowCount + 1L << 3;
    }

    @Override
    public long getDataVectorMinEntrySize() {
        return 4L;
    }

    @Override
    public long getDataVectorOffset(long auxMemAddr, long row) {
        return Unsafe.getUnsafe().getLong(auxMemAddr + (row << 3));
    }

    @Override
    public long getDataVectorSize(long auxMemAddr, long rowLo, long rowHi) {
        return this.getDataVectorOffset(auxMemAddr, rowHi + 1L) - this.getDataVectorOffset(auxMemAddr, rowLo);
    }

    @Override
    public long getDataVectorSizeAt(long auxMemAddr, long row) {
        return this.getDataVectorOffset(auxMemAddr, row + 1L);
    }

    @Override
    public long getDataVectorSizeAtFromFd(FilesFacade ff, long auxFd, long row) {
        long dataOffset;
        long auxFileOffset = this.getAuxVectorOffset(row + 1L);
        long l = dataOffset = row > -1L ? ff.readNonNegativeLong(auxFd, auxFileOffset) : 0L;
        if (dataOffset < 0L || dataOffset > 0x10000000000L || row > -1L && dataOffset == 0L) {
            throw CairoException.critical(ff.errno()).put("Invalid variable file length offset read from offset file [auxFd=").put(auxFd).put(", offset=").put(auxFileOffset).put(", fileSize=").put(ff.length(auxFd)).put(", result=").put(dataOffset).put(']');
        }
        return dataOffset;
    }

    @Override
    public long getMinAuxVectorSize() {
        return 8L;
    }

    @Override
    public boolean isSparseDataVector(long auxMemAddr, long dataMemAddr, long rowCount) {
        int row = 0;
        while ((long)row < rowCount) {
            long dStorageLen;
            long offset = Unsafe.getUnsafe().getLong(auxMemAddr + (long)row * 8L);
            long iLen = Unsafe.getUnsafe().getLong(auxMemAddr + (long)(row + 1) * 8L) - offset;
            long dLen = Unsafe.getUnsafe().getInt(dataMemAddr + offset);
            int lenLen = 4;
            long dataLen = dLen * 2L;
            long l = dStorageLen = dLen > 0L ? dataLen + (long)lenLen : (long)lenLen;
            if (iLen != dStorageLen) {
                return true;
            }
            ++row;
        }
        return false;
    }

    @Override
    public long mergeShuffleColumnFromManyAddresses(long indexFormat, long primaryAddressList, long secondaryAddressList, long outPrimaryAddress, long outSecondaryAddress, long mergeIndex, long destVarOffset, long destDataSize) {
        return Vect.mergeShuffleStringColumnFromManyAddresses(indexFormat, (int)this.getDataVectorMinEntrySize(), primaryAddressList, secondaryAddressList, outPrimaryAddress, outSecondaryAddress, mergeIndex, destVarOffset, destDataSize);
    }

    @Override
    public void o3ColumnMerge(long timestampMergeIndexAddr, long timestampMergeIndexCount, long srcAuxAddr1, long srcDataAddr1, long srcAuxAddr2, long srcDataAddr2, long dstAuxAddr, long dstDataAddr, long dstDataOffset) {
        Vect.oooMergeCopyStrColumn(timestampMergeIndexAddr, timestampMergeIndexCount, srcAuxAddr1, srcDataAddr1, srcAuxAddr2, srcDataAddr2, dstAuxAddr, dstDataAddr, dstDataOffset);
    }

    @Override
    public void o3copyAuxVector(FilesFacade ff, long srcAddr, long srcLo, long srcHi, long dstAddr, long dstFileOffset, long dstFd, boolean mixedIOFlag) {
        long len = srcHi + 1L - srcLo + 1L << 3;
        O3Utils.copyFixedSizeCol(ff, srcAddr, srcLo, dstAddr, dstFileOffset, dstFd, mixedIOFlag, len, 3);
    }

    @Override
    public void o3sort(long sortedTimestampsAddr, long sortedTimestampsRowCount, MemoryCR srcDataMem, MemoryCR srcAuxMem, MemoryCARW dstDataMem, MemoryCARW dstAuxMem) {
        long srcDataAddr = srcDataMem.addressOf(0L);
        long srcAuxAddr = srcAuxMem.addressOf(0L);
        long tgtAuxAddr = dstAuxMem.resize(this.getAuxVectorSize(sortedTimestampsRowCount));
        long tgtDataAddr = dstDataMem.resize(this.getDataVectorSizeAt(srcAuxAddr, sortedTimestampsRowCount - 1L));
        assert (srcDataAddr != 0L);
        assert (srcAuxAddr != 0L);
        assert (tgtDataAddr != 0L);
        assert (tgtAuxAddr != 0L);
        long offset = Vect.sortStringColumn(sortedTimestampsAddr, sortedTimestampsRowCount, srcDataAddr, srcAuxAddr, tgtDataAddr, tgtAuxAddr);
        dstDataMem.jumpTo(offset);
        dstAuxMem.jumpTo(sortedTimestampsRowCount << 3);
        dstAuxMem.putLong(offset);
    }

    @Override
    public long setAppendAuxMemAppendPosition(MemoryMA auxMem, MemoryMA dataMem, int columnType, long rowCount) {
        auxMem.jumpTo(rowCount << 3);
        long dataMemOffset = rowCount > 0L ? Unsafe.getUnsafe().getLong(auxMem.getAppendAddress()) : 0L;
        auxMem.jumpTo(rowCount + 1L << 3);
        return dataMemOffset;
    }

    @Override
    public long setAppendPosition(long pos, MemoryMA auxMem, MemoryMA dataMem) {
        if (pos > 0L) {
            auxMem.jumpTo(pos << 3);
            long m1pos = Unsafe.getUnsafe().getLong(auxMem.getAppendAddress());
            auxMem.jumpTo(pos + 1L << 3);
            long dataSizeBytes = m1pos + (pos + 1L << 3);
            dataMem.jumpTo(m1pos);
            return dataSizeBytes;
        }
        dataMem.jumpTo(0L);
        auxMem.jumpTo(0L);
        auxMem.putLong(0L);
        return 8L;
    }

    @Override
    public void setDataVectorEntriesToNull(long dataMemAddr, long rowCount) {
        Vect.memset(dataMemAddr, rowCount * 4L, -1);
    }

    @Override
    public void setFullAuxVectorNull(long auxMemAddr, long rowCount) {
        Vect.setStringColumnNullRefs(auxMemAddr, 0L, rowCount + 1L);
    }

    @Override
    public void setPartAuxVectorNull(long auxMemAddr, long initialOffset, long columnTop) {
        Vect.setStringColumnNullRefs(auxMemAddr, initialOffset, columnTop);
    }

    @Override
    public void shiftCopyAuxVector(long shift, long src, long srcLo, long srcHi, long dstAddr, long dstAddrSize) {
        assert ((srcHi - srcLo + 2L) * 8L <= dstAddrSize);
        Vect.shiftCopyFixedSizeColumnData(shift, src, srcLo, srcHi + 1L, dstAddr);
    }
}

