/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TimestampFinder;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.griffin.engine.table.parquet.RowGroupStatBuffers;
import io.questdb.std.DirectIntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class ParquetTimestampFinder
implements TimestampFinder,
Mutable,
QuietCloseable {
    private final PartitionDecoder partitionDecoder;
    private final RowGroupBuffers rowGroupBuffers = new RowGroupBuffers(65);
    private final RowGroupStatBuffers statBuffers = new RowGroupStatBuffers(65);
    private final DirectIntList timestampIdAndType = new DirectIntList(2L, 19);
    private long maxTimestampApprox;
    private long minTimestampApprox;
    private int partitionIndex = -1;
    private TableReader reader;
    private TableToken tableToken;
    private int timestampIndex;

    public ParquetTimestampFinder(PartitionDecoder partitionDecoder) {
        this.partitionDecoder = partitionDecoder;
    }

    @Override
    public void clear() {
        this.partitionIndex = -1;
        this.tableToken = null;
    }

    @Override
    public void close() {
        Misc.free(this.rowGroupBuffers);
        Misc.free(this.statBuffers);
        Misc.free(this.timestampIdAndType);
        this.clear();
    }

    @Override
    public long findTimestamp(long value, long rowLo, long rowHi) {
        PartitionDecoder.Metadata metadata = this.partitionDecoder.metadata();
        int rowGroupCount = metadata.rowGroupCount();
        long encodedIndex = this.partitionDecoder.findRowGroupByTimestamp(value, rowLo, rowHi, this.timestampIdAndType.get(0L));
        int rowGroupIndex = PartitionDecoder.decodeRowGroupIndex(encodedIndex);
        boolean noNeedToDecode = PartitionDecoder.decodeNoNeedToDecodeFlag(encodedIndex);
        if (rowGroupIndex == -1 && noNeedToDecode) {
            return rowLo - 1L;
        }
        if (rowGroupIndex == rowGroupCount - 1 && noNeedToDecode) {
            return rowHi;
        }
        long offset = 0L;
        for (int i = 0; i < rowGroupCount; ++i) {
            if (i == rowGroupIndex) {
                if (!noNeedToDecode) break;
                return Math.max(rowLo, offset + (long)metadata.rowGroupSize(i)) - 1L;
            }
            offset += (long)metadata.rowGroupSize(i);
        }
        long rowGroupRowLo = Math.max(rowLo - offset, 0L);
        long rowGroupRowHi = Math.min(rowHi - offset, (long)(metadata.rowGroupSize(rowGroupIndex) - 1));
        assert (rowGroupRowLo <= rowGroupRowHi);
        this.partitionDecoder.decodeRowGroup(this.rowGroupBuffers, this.timestampIdAndType, rowGroupIndex, (int)rowGroupRowLo, (int)(rowGroupRowHi + 1L));
        long idx = Vect.binarySearch64Bit(this.rowGroupBuffers.getChunkDataPtr(0), value, 0L, rowGroupRowHi - rowGroupRowLo, 1);
        if (idx < 0L) {
            idx = -idx - 2L;
        }
        return idx + rowGroupRowLo + offset;
    }

    @Override
    public long maxTimestampApproxFromMetadata() {
        return this.maxTimestampApprox;
    }

    @Override
    public long maxTimestampExact() {
        int rowGroupCount = this.partitionDecoder.metadata().rowGroupCount();
        this.partitionDecoder.readRowGroupStats(this.statBuffers, this.timestampIdAndType, rowGroupCount - 1);
        return this.statBuffers.getMaxValueLong(0);
    }

    @Override
    public long minTimestampApproxFromMetadata() {
        return this.minTimestampApprox;
    }

    @Override
    public long minTimestampExact() {
        this.partitionDecoder.readRowGroupStats(this.statBuffers, this.timestampIdAndType, 0);
        return this.statBuffers.getMinValueLong(0);
    }

    public ParquetTimestampFinder of(TableReader reader, int partitionIndex, int timestampIndex) {
        this.partitionIndex = partitionIndex;
        this.reader = reader;
        this.timestampIndex = timestampIndex;
        this.minTimestampApprox = reader.getPartitionMinTimestampFromMetadata(partitionIndex);
        this.maxTimestampApprox = reader.getPartitionMaxTimestampFromMetadata(partitionIndex);
        this.tableToken = reader.getTableToken();
        return this;
    }

    @Override
    public void prepare() {
        this.partitionDecoder.of(this.reader.getParquetAddr(this.partitionIndex), this.reader.getParquetFileSize(this.partitionIndex), 65);
        this.rowGroupBuffers.reopen();
        this.statBuffers.reopen();
        int parquetTimestampIndex = ParquetTimestampFinder.findTimestampIndex(this.partitionDecoder, this.timestampIndex);
        if (parquetTimestampIndex == -1) {
            throw CairoException.critical(0).put("missing timestamp column in parquet partition [table=").put(this.tableToken).put(", partitionIndex=").put(this.partitionIndex).put(", timestampIndex=").put(this.timestampIndex).put(']');
        }
        this.timestampIdAndType.reopen();
        this.timestampIdAndType.clear();
        this.timestampIdAndType.add(parquetTimestampIndex);
        this.timestampIdAndType.add(8);
    }

    @Override
    public long timestampAt(long rowIndex) {
        PartitionDecoder.Metadata metadata = this.partitionDecoder.metadata();
        long rowCount = 0L;
        int n = metadata.rowGroupCount();
        for (int rowGroupIndex = 0; rowGroupIndex < n; ++rowGroupIndex) {
            long size = metadata.rowGroupSize(rowGroupIndex);
            if (rowIndex >= rowCount && rowIndex < rowCount + size) {
                int rowLo = (int)(rowIndex - rowCount);
                this.partitionDecoder.decodeRowGroup(this.rowGroupBuffers, this.timestampIdAndType, rowGroupIndex, rowLo, rowLo + 1);
                return Unsafe.getUnsafe().getLong(this.rowGroupBuffers.getChunkDataPtr(0));
            }
            rowCount += size;
        }
        throw CairoException.critical(0).put("index out of bounds when reading timestamp value in parquet partition [table=").put(this.tableToken).put(", rowIndex=").put(rowIndex).put(", partitionIndex=").put(this.partitionIndex).put(']');
    }

    private static int findTimestampIndex(PartitionDecoder partitionDecoder, int timestampIndex) {
        PartitionDecoder.Metadata metadata = partitionDecoder.metadata();
        int n = metadata.columnCount();
        for (int i = 0; i < n; ++i) {
            if (metadata.columnId(i) != timestampIndex) continue;
            return i;
        }
        return -1;
    }
}

