/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;

public class ColumnVersionWriter
extends ColumnVersionReader {
    private final CairoConfiguration configuration;
    private final MemoryCMARW mem;
    private final boolean partitioned;
    private boolean hasChanges;
    private long size;
    private long version;

    public ColumnVersionWriter(CairoConfiguration configuration, LPSZ fileName, boolean partitioned) {
        FilesFacade ff = configuration.getFilesFacade();
        this.mem = Vm.getCMARWInstance(ff, fileName, ff.getPageSize(), 0L, 9, 0);
        this.configuration = configuration;
        this.partitioned = partitioned;
        this.size = this.mem.size();
        super.ofRO(this.mem);
        if (this.size > 0L) {
            this.version = super.readUnsafe();
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.mem.close(false);
    }

    public void commit() {
        if (!this.hasChanges) {
            return;
        }
        this.doCommit();
        this.hasChanges = false;
    }

    public void copyColumnVersions(long srcTimestamp, long dstTimestamp) {
        int index = this.copyColumnVersions(srcTimestamp, dstTimestamp, this.cachedColumnVersionList);
        if (index > -1) {
            int n = this.cachedColumnVersionList.size();
            while (index < n && this.cachedColumnVersionList.get(index) == srcTimestamp) {
                this.cachedColumnVersionList.setQuick(index, dstTimestamp);
                index += 4;
            }
        }
    }

    public long getOffsetA() {
        return this.mem.getLong(8L);
    }

    public long getOffsetB() {
        return this.mem.getLong(24L);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void overrideColumnVersions(long partitionTimestamp, ColumnVersionReader src) {
        this.copyColumnVersions(partitionTimestamp, partitionTimestamp, src.cachedColumnVersionList);
    }

    @Override
    public long readUnsafe() {
        this.hasChanges = false;
        this.version = super.readUnsafe();
        return this.version;
    }

    public void removeColumnTop(long partitionTimestamp, int columnIndex) {
        int recordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        if (recordIndex >= 0) {
            this.cachedColumnVersionList.setQuick(recordIndex + 3, 0L);
            this.hasChanges = true;
        }
    }

    public void removePartition(long partitionTimestamp) {
        int from = this.cachedColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, partitionTimestamp, -1);
        if (from > -1) {
            int to = this.cachedColumnVersionList.binarySearchBlock(from, BLOCK_SIZE_MSB, partitionTimestamp, 1);
            int len = to - from + 4;
            this.cachedColumnVersionList.removeIndexBlock(from, len);
            this.hasChanges = true;
        }
    }

    public void replaceInitialPartitionRecords(long lastPartitionTimestamp, long transientRowCount) {
        int n = this.cachedColumnVersionList.size();
        for (int i = 0; i < n; i += 4) {
            long partitionTimestamp = this.cachedColumnVersionList.getQuick(i);
            long initialPartitionTimestamp = this.cachedColumnVersionList.get(i + 3);
            int columnIndex = (int)this.cachedColumnVersionList.get(i + 1);
            long columnNameTxn = this.cachedColumnVersionList.getQuick(i + 2);
            if (partitionTimestamp != Long.MIN_VALUE) break;
            if (initialPartitionTimestamp <= lastPartitionTimestamp) continue;
            this.cachedColumnVersionList.set(i + 3, lastPartitionTimestamp);
            int recordIndex = this.getRecordIndex(lastPartitionTimestamp, columnIndex);
            if (recordIndex >= 0) continue;
            this.upsert(lastPartitionTimestamp, columnIndex, columnNameTxn, transientRowCount);
        }
    }

    public void squashPartition(long targetPartitionTimestamp, long sourcePartitionTimestamp) {
        this.removePartition(sourcePartitionTimestamp);
        int n = this.cachedColumnVersionList.size();
        for (int i = 0; i < n; i += 4) {
            long partitionTimestamp = this.cachedColumnVersionList.getQuick(i);
            long defaultPartitionTimestamp = this.cachedColumnVersionList.get(i + 3);
            if (partitionTimestamp != Long.MIN_VALUE) break;
            if (defaultPartitionTimestamp != sourcePartitionTimestamp) continue;
            this.cachedColumnVersionList.set(i + 3, targetPartitionTimestamp);
        }
    }

    public void truncate() {
        if (this.cachedColumnVersionList.size() > 0) {
            long defaultPartitionTimestamp = Long.MIN_VALUE;
            int from = this.cachedColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, -9223372036854775807L, -1);
            if (from < 0) {
                from = -from - 1;
            }
            if (this.partitioned) {
                if (from < this.cachedColumnVersionList.size()) {
                    this.cachedColumnVersionList.setPos(from);
                }
                int n = this.cachedColumnVersionList.size();
                for (int i = 0; i < n; i += 4) {
                    this.cachedColumnVersionList.setQuick(i + 3, Long.MIN_VALUE);
                }
            } else {
                for (int i = from; i < this.cachedColumnVersionList.size(); i += 4) {
                    this.cachedColumnVersionList.setQuick(i + 3, 0L);
                }
            }
            this.hasChanges = true;
            this.commit();
        }
    }

    public void upsert(long timestamp, int columnIndex, long txn, long columnTop) {
        int index;
        int sz = this.cachedColumnVersionList.size();
        boolean insert = true;
        if (index > -1) {
            for (index = this.cachedColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, timestamp, -1); index < sz && this.cachedColumnVersionList.getQuick(index) == timestamp; index += 4) {
                long thisIndex = this.cachedColumnVersionList.getQuick(index + 1);
                if (thisIndex == (long)columnIndex) {
                    if (txn > -1L) {
                        this.cachedColumnVersionList.setQuick(index + 2, txn);
                    }
                    this.cachedColumnVersionList.setQuick(index + 3, columnTop);
                    insert = false;
                } else if (thisIndex <= (long)columnIndex) {
                    continue;
                }
                break;
            }
        } else {
            index = -index - 1;
        }
        if (insert) {
            if (index < sz) {
                this.cachedColumnVersionList.insert(index, 4);
            } else {
                this.cachedColumnVersionList.setPos(Math.max(index + 4, sz + 4));
            }
            this.cachedColumnVersionList.setQuick(index, timestamp);
            this.cachedColumnVersionList.setQuick(index + 1, columnIndex);
            this.cachedColumnVersionList.setQuick(index + 2, txn);
            this.cachedColumnVersionList.setQuick(index + 3, columnTop);
        }
        this.hasChanges = true;
    }

    public void upsertColumnTop(long partitionTimestamp, int columnIndex, long colTop) {
        int recordIndex = this.getRecordIndex(partitionTimestamp, columnIndex);
        if ((long)recordIndex > -1L) {
            this.cachedColumnVersionList.setQuick(recordIndex + 3, colTop);
            this.hasChanges = true;
        } else {
            int defaultRecordIndex = this.getRecordIndex(Long.MIN_VALUE, columnIndex);
            if (defaultRecordIndex >= 0) {
                long columnNameTxn = this.cachedColumnVersionList.getQuick(defaultRecordIndex + 2);
                long defaultPartitionTimestamp = this.cachedColumnVersionList.getQuick(defaultRecordIndex + 3);
                if (defaultPartitionTimestamp > partitionTimestamp || colTop > 0L) {
                    this.upsert(partitionTimestamp, columnIndex, columnNameTxn, colTop);
                }
            } else if (colTop > 0L) {
                this.upsert(partitionTimestamp, columnIndex, -1L, colTop);
            }
        }
    }

    public void upsertDefaultTxnName(int columnIndex, long columnNameTxn, long partitionTimestamp) {
        this.upsert(Long.MIN_VALUE, columnIndex, columnNameTxn, partitionTimestamp);
    }

    private void bumpFileSize(long size) {
        this.mem.setSize(size);
        this.size = size;
    }

    private long calculateSize(int entryCount) {
        return (long)entryCount * 32L;
    }

    private long calculateWriteOffset(long areaSize) {
        boolean currentIsA = this.isCurrentA();
        long currentOffset = currentIsA ? this.getOffsetA() : this.getOffsetB();
        if (40L + areaSize <= (currentOffset = Math.max(currentOffset, 40L))) {
            return 40L;
        }
        long currentSize = currentIsA ? this.getSizeA() : this.getSizeB();
        return currentOffset + currentSize;
    }

    private int copyColumnVersions(long srcTimestamp, long dstTimestamp, LongList srcColumnVersionList) {
        int srcIndex = srcColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, srcTimestamp, -1);
        if (srcIndex < 0) {
            return -1;
        }
        int index = this.cachedColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, dstTimestamp, -1);
        if ((long)index > -1L) {
            this.removePartition(dstTimestamp);
            index = this.cachedColumnVersionList.binarySearchBlock(BLOCK_SIZE_MSB, dstTimestamp, -1);
        }
        if (index >= 0) {
            throw CairoException.critical(0).put("invalid Column Version state ").ts(dstTimestamp).put(" column version state, cannot update partition information");
        }
        index = -index - 1;
        int srcEnd = srcColumnVersionList.binarySearchBlock(srcIndex, BLOCK_SIZE_MSB, srcTimestamp, 1);
        this.cachedColumnVersionList.insertFromSource(index, srcColumnVersionList, srcIndex, srcEnd + 4);
        this.hasChanges = true;
        return index;
    }

    private void doCommit() {
        int entryCount = this.cachedColumnVersionList.size() / 4;
        long areaSize = this.calculateSize(entryCount);
        long writeOffset = this.calculateWriteOffset(areaSize);
        this.bumpFileSize(writeOffset + areaSize);
        this.store(entryCount, writeOffset);
        if (this.isCurrentA()) {
            this.updateB(writeOffset, areaSize);
        } else {
            this.updateA(writeOffset, areaSize);
        }
        Unsafe.getUnsafe().storeFence();
        this.storeNewVersion();
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            this.mem.sync(commitMode == 0);
        }
    }

    private long getSizeA() {
        return this.mem.getLong(16L);
    }

    private long getSizeB() {
        return this.mem.getLong(32L);
    }

    private boolean isCurrentA() {
        return (this.version & 1L) == 0L;
    }

    private void store(int entryCount, long offset) {
        for (int i = 0; i < entryCount; ++i) {
            int x = i * 4;
            this.mem.putLong(offset, this.cachedColumnVersionList.getQuick(x));
            this.mem.putLong(offset + 8L, this.cachedColumnVersionList.getQuick(x + 1));
            this.mem.putLong(offset + 16L, this.cachedColumnVersionList.getQuick(x + 2));
            this.mem.putLong(offset + 24L, this.cachedColumnVersionList.getQuick(x + 3));
            offset += 32L;
        }
    }

    private void storeNewVersion() {
        this.mem.putLong(0L, ++this.version);
    }

    private void updateA(long aOffset, long aSize) {
        this.mem.putLong(8L, aOffset);
        this.mem.putLong(16L, aSize);
    }

    private void updateB(long bOffset, long bSize) {
        this.mem.putLong(24L, bOffset);
        this.mem.putLong(32L, bSize);
    }
}

