/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.MySQLIndexHint;
import net.sf.jsqlparser.expression.SQLServerHints;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.MultiPartName;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntoTableVisitor;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.SampleClause;
import net.sf.jsqlparser.statement.select.UnPivot;

public class Table
extends ASTNodeAccessImpl
implements FromItem,
MultiPartName {
    private static final int NAME_IDX = 0;
    private static final int SCHEMA_IDX = 1;
    private static final int DATABASE_IDX = 2;
    private static final int SERVER_IDX = 3;
    private List<String> partItems = new ArrayList<String>();
    private List<String> partDelimiters = new ArrayList<String>();
    private Alias alias;
    private SampleClause sampleClause;
    private Pivot pivot;
    private UnPivot unpivot;
    private MySQLIndexHint mysqlHints;
    private SQLServerHints sqlServerHints;

    public Table() {
    }

    public Table(String name) {
        this.setName(name);
    }

    public Table(String schemaName, String name) {
        this.setSchemaName(schemaName);
        this.setName(name);
    }

    public Table(Database database, String schemaName, String name) {
        this.setDatabase(database);
        this.setSchemaName(schemaName);
        this.setName(name);
    }

    public Table(String catalogName, String schemaName, String tableName) {
        this.setSchemaName(schemaName);
        this.setDatabase(new Database(catalogName));
        this.setName(tableName);
    }

    public Table(List<String> partItems) {
        if (partItems.size() == 1) {
            this.setName(partItems.get(0));
        } else {
            this.partItems = new ArrayList<String>(partItems);
            Collections.reverse(this.partItems);
        }
    }

    public Table(List<String> partItems, List<String> partDelimiters) {
        if (partItems.size() == 1) {
            this.setName(partItems.get(0));
        } else {
            if (partDelimiters.size() != partItems.size() - 1) {
                throw new IllegalArgumentException("the length of the delimiters list must be 1 less than nameParts");
            }
            this.partItems = new ArrayList<String>(partItems);
            this.partDelimiters = new ArrayList<String>(partDelimiters);
            Collections.reverse(this.partItems);
            Collections.reverse(this.partDelimiters);
        }
    }

    public String getCatalogName() {
        return this.getIndex(2);
    }

    public Database getDatabase() {
        return new Database(this.getIndex(2));
    }

    public String getDatabaseName() {
        return this.getIndex(2);
    }

    public String getUnquotedCatalogName() {
        return MultiPartName.unquote(this.getDatabaseName());
    }

    public String getUnquotedDatabaseName() {
        return MultiPartName.unquote(this.getDatabaseName());
    }

    public void setDatabase(Database database) {
        this.setIndex(2, database.getDatabaseName());
        if (database.getServer() != null) {
            this.setIndex(3, database.getServer().getFullyQualifiedName());
        }
    }

    public Table setDatabaseName(String databaseName) {
        this.setDatabase(new Database(databaseName));
        return this;
    }

    public Table withDatabase(Database database) {
        this.setDatabase(database);
        return this;
    }

    public String getSchemaName() {
        return this.getIndex(1);
    }

    public String getUnquotedSchemaName() {
        return MultiPartName.unquote(this.getSchemaName());
    }

    public Table setSchemaName(String schemaName) {
        this.setIndex(1, schemaName);
        return this;
    }

    public Table withSchemaName(String schemaName) {
        this.setSchemaName(schemaName);
        return this;
    }

    public String getName() {
        int pos;
        String name = this.getIndex(0);
        if (name != null && name.contains("@") && (pos = name.lastIndexOf(64)) > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public void setName(String name) {
        if (MultiPartName.isQuoted(name) && name.contains(".")) {
            this.partItems.clear();
            for (String unquotedIdentifier : MultiPartName.unquote(name).split("\\.")) {
                this.partItems.add("\"" + unquotedIdentifier + "\"");
            }
            Collections.reverse(this.partItems);
        } else {
            this.setIndex(0, name);
        }
    }

    public String getDBLinkName() {
        int pos;
        String name = this.getIndex(0);
        if (name != null && name.contains("@") && (pos = name.lastIndexOf(64)) > 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public Table withName(String name) {
        this.setName(name);
        return this;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    private void setIndex(int idx, String value) {
        int size = this.partItems.size();
        for (int i = 0; i < idx - size + 1; ++i) {
            this.partItems.add(null);
        }
        if (value == null && idx == this.partItems.size() - 1) {
            this.partItems.remove(idx);
        } else {
            this.partItems.set(idx, value);
        }
    }

    private String getIndex(int idx) {
        if (idx < this.partItems.size()) {
            return this.partItems.get(idx);
        }
        return null;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        while (!this.partItems.isEmpty() && (this.partItems.get(this.partItems.size() - 1) == null || this.partItems.get(this.partItems.size() - 1).isEmpty())) {
            this.partItems.remove(this.partItems.size() - 1);
        }
        for (int i = this.partItems.size() - 1; i >= 0; --i) {
            String part = this.partItems.get(i);
            if (part == null) {
                part = "";
            }
            fqn.append(part);
            if (i == 0) continue;
            fqn.append(this.partDelimiters.isEmpty() ? "." : this.partDelimiters.get(i - 1));
        }
        return fqn.toString();
    }

    @Override
    public String getUnquotedName() {
        return MultiPartName.unquote(this.getName());
    }

    @Override
    public <T, S> T accept(FromItemVisitor<T> fromItemVisitor, S context) {
        return fromItemVisitor.visit(this, context);
    }

    public <T, S> T accept(IntoTableVisitor<T> intoTableVisitor, S context) {
        return intoTableVisitor.visit(this, context);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unpivot;
    }

    @Override
    public void setUnPivot(UnPivot unpivot) {
        this.unpivot = unpivot;
    }

    public MySQLIndexHint getIndexHint() {
        return this.mysqlHints;
    }

    public Table withHint(MySQLIndexHint hint) {
        this.setHint(hint);
        return this;
    }

    public void setHint(MySQLIndexHint hint) {
        this.mysqlHints = hint;
    }

    public SQLServerHints getSqlServerHints() {
        return this.sqlServerHints;
    }

    public void setSqlServerHints(SQLServerHints sqlServerHints) {
        this.sqlServerHints = sqlServerHints;
    }

    public SampleClause getSampleClause() {
        return this.sampleClause;
    }

    public Table setSampleClause(SampleClause sampleClause) {
        this.sampleClause = sampleClause;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append(this.getFullyQualifiedName());
        if (this.alias != null) {
            builder.append(this.alias);
        }
        if (this.sampleClause != null) {
            this.sampleClause.appendTo(builder);
        }
        if (this.pivot != null) {
            builder.append(" ").append(this.pivot);
        }
        if (this.unpivot != null) {
            builder.append(" ").append(this.unpivot);
        }
        if (this.mysqlHints != null) {
            builder.append(this.mysqlHints);
        }
        if (this.sqlServerHints != null) {
            builder.append(this.sqlServerHints);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public Table withUnPivot(UnPivot unpivot) {
        return (Table)FromItem.super.withUnPivot(unpivot);
    }

    @Override
    public Table withAlias(Alias alias) {
        return (Table)FromItem.super.withAlias(alias);
    }

    @Override
    public Table withPivot(Pivot pivot) {
        return (Table)FromItem.super.withPivot(pivot);
    }

    public Table withSqlServerHints(SQLServerHints sqlServerHints) {
        this.setSqlServerHints(sqlServerHints);
        return this;
    }

    public List<String> getNameParts() {
        return this.partItems;
    }

    public List<String> getNamePartDelimiters() {
        return this.partDelimiters;
    }
}

