/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.select.Select;

public class CastExpression
extends ASTNodeAccessImpl
implements Expression {
    private static final Pattern PATTERN = Pattern.compile("(^[a-z0-9_]*){1}", 2);
    public String keyword;
    private Expression leftExpression;
    private ColDataType colDataType = null;
    private ArrayList<ColumnDefinition> columnDefinitions = new ArrayList();
    private boolean isImplicitCast = false;
    private String format = null;

    public CastExpression(String keyword, Expression leftExpression, String dataType) {
        this.keyword = keyword;
        this.leftExpression = leftExpression;
        this.colDataType = new ColDataType(dataType);
    }

    public CastExpression(String dataType, String value) {
        this.keyword = null;
        this.isImplicitCast = true;
        this.colDataType = new ColDataType(dataType);
        this.leftExpression = new StringValue(value);
    }

    public CastExpression(ColDataType colDataType, String value) {
        this.keyword = null;
        this.isImplicitCast = true;
        this.colDataType = colDataType;
        this.leftExpression = new StringValue(value);
    }

    public CastExpression(ColDataType colDataType, Long value) {
        this.keyword = null;
        this.isImplicitCast = true;
        this.colDataType = colDataType;
        this.leftExpression = new LongValue(value);
    }

    public CastExpression(ColDataType colDataType, Double value) {
        this.keyword = null;
        this.isImplicitCast = true;
        this.colDataType = colDataType;
        this.leftExpression = new DoubleValue(value);
    }

    public CastExpression(Expression leftExpression, String dataType) {
        this.keyword = null;
        this.leftExpression = leftExpression;
        this.colDataType = new ColDataType(dataType);
    }

    public CastExpression(String keyword) {
        this.keyword = keyword;
    }

    public CastExpression() {
        this("CAST");
    }

    public static boolean isOf(ColDataType colDataType, DataType ... types) {
        return Set.of(types).contains((Object)DataType.from(colDataType.getDataType()));
    }

    public static boolean isTime(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.TIME, DataType.TIME_WITH_TIME_ZONE, DataType.TIME_WITHOUT_TIME_ZONE);
    }

    public static boolean isTimeStamp(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.TIMESTAMP_NS, DataType.TIMESTAMP, DataType.TIMESTAMP_WITHOUT_TIME_ZONE, DataType.DATETIME, DataType.TIMESTAMP_MS, DataType.TIMESTAMP_S, DataType.TIMESTAMPTZ, DataType.TIMESTAMP_WITH_TIME_ZONE);
    }

    public static boolean isDate(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.DATE);
    }

    public static boolean isBLOB(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.BLOB, DataType.BYTEA, DataType.BINARY, DataType.VARBINARY, DataType.BYTES, DataType.VARBYTE);
    }

    public static boolean isFloat(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.REAL, DataType.FLOAT4, DataType.FLOAT, DataType.DOUBLE, DataType.DOUBLE_PRECISION, DataType.FLOAT8);
    }

    public static boolean isInteger(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.TINYINT, DataType.INT1, DataType.SMALLINT, DataType.INT2, DataType.SHORT, DataType.INTEGER, DataType.INT4, DataType.INT, DataType.SIGNED, DataType.BIGINT, DataType.INT8, DataType.LONG, DataType.HUGEINT, DataType.UTINYINT, DataType.USMALLINT, DataType.UINTEGER, DataType.UBIGINT, DataType.UHUGEINT);
    }

    public static boolean isDecimal(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.DECIMAL, DataType.NUMBER, DataType.NUMERIC);
    }

    public static boolean isText(ColDataType colDataType) {
        return CastExpression.isOf(colDataType, DataType.VARCHAR, DataType.NVARCHAR, DataType.CHAR, DataType.NCHAR, DataType.BPCHAR, DataType.STRING, DataType.TEXT, DataType.CLOB);
    }

    public ColDataType getColDataType() {
        return this.colDataType;
    }

    public void setColDataType(ColDataType colDataType) {
        this.colDataType = colDataType;
    }

    public ArrayList<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitions.add(columnDefinition);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isImplicitCast() {
        return this.isImplicitCast;
    }

    public CastExpression setImplicitCast(boolean implicitCast) {
        this.isImplicitCast = implicitCast;
        return this;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Deprecated
    public boolean isUseCastKeyword() {
        return this.keyword != null && !this.keyword.isEmpty();
    }

    @Deprecated
    public void setUseCastKeyword(boolean useCastKeyword) {
        if (useCastKeyword) {
            if (this.keyword == null || this.keyword.isEmpty()) {
                this.keyword = "CAST";
            }
        } else {
            this.keyword = null;
        }
    }

    public String getFormat() {
        return this.format;
    }

    public CastExpression setFormat(String format) {
        this.format = format;
        return this;
    }

    public String toString() {
        String formatStr;
        String string = formatStr = this.format != null && !this.format.isEmpty() ? " FORMAT " + this.format : "";
        if (this.isImplicitCast) {
            return this.colDataType + " " + this.leftExpression;
        }
        if (this.keyword != null && !this.keyword.isEmpty()) {
            return this.columnDefinitions.size() > 1 ? this.keyword + "(" + this.leftExpression + " AS ROW(" + Select.getStringList(this.columnDefinitions) + ")" + formatStr + ")" : this.keyword + "(" + this.leftExpression + " AS " + this.colDataType.toString() + formatStr + ")";
        }
        return this.leftExpression + "::" + this.colDataType.toString();
    }

    public CastExpression withType(ColDataType type) {
        this.setColDataType(type);
        return this;
    }

    public CastExpression withUseCastKeyword(boolean useCastKeyword) {
        this.setUseCastKeyword(useCastKeyword);
        return this;
    }

    public CastExpression withLeftExpression(Expression leftExpression) {
        this.setLeftExpression(leftExpression);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getLeftExpression()));
    }

    public boolean isOf(CastExpression anotherCast) {
        return this.colDataType.equals(anotherCast.colDataType);
    }

    public boolean isOf(DataType ... types) {
        return Set.of(types).contains((Object)DataType.from(this.colDataType.getDataType()));
    }

    public boolean isTime() {
        return CastExpression.isTime(this.colDataType);
    }

    public boolean isTimeStamp() {
        return CastExpression.isTimeStamp(this.colDataType);
    }

    public boolean isDate() {
        return CastExpression.isDate(this.colDataType);
    }

    public boolean isBLOB() {
        return CastExpression.isBLOB(this.colDataType);
    }

    public boolean isFloat() {
        return CastExpression.isFloat(this.colDataType);
    }

    public boolean isInteger() {
        return CastExpression.isInteger(this.colDataType);
    }

    public boolean isDecimal() {
        return CastExpression.isDecimal(this.colDataType);
    }

    public boolean isText() {
        return CastExpression.isText(this.colDataType);
    }

    public static enum DataType {
        ARRAY,
        BIT,
        BITSTRING,
        BLOB,
        BYTEA,
        BINARY,
        VARBINARY,
        BYTES,
        BOOLEAN,
        BOOL,
        ENUM,
        INTERVAL,
        LIST,
        MAP,
        STRUCT,
        TINYINT,
        INT1,
        SMALLINT,
        INT2,
        SHORT,
        INTEGER,
        INT4,
        INT,
        SIGNED,
        BIGINT,
        INT8,
        LONG,
        HUGEINT,
        UTINYINT,
        USMALLINT,
        UINTEGER,
        UBIGINT,
        UHUGEINT,
        DECIMAL,
        NUMBER,
        NUMERIC,
        REAL,
        FLOAT4,
        FLOAT,
        DOUBLE,
        DOUBLE_PRECISION,
        FLOAT8,
        FLOAT64,
        UUID,
        VARCHAR,
        NVARCHAR,
        CHAR,
        NCHAR,
        BPCHAR,
        STRING,
        TEXT,
        CLOB,
        DATE,
        TIME,
        TIME_WITHOUT_TIME_ZONE,
        TIMETZ,
        TIME_WITH_TIME_ZONE,
        TIMESTAMP_NS,
        TIMESTAMP,
        TIMESTAMP_WITHOUT_TIME_ZONE,
        DATETIME,
        TIMESTAMP_MS,
        TIMESTAMP_S,
        TIMESTAMPTZ,
        TIMESTAMP_WITH_TIME_ZONE,
        UNKNOWN,
        VARBYTE,
        JSON;


        public static DataType from(String typeStr) {
            Matcher matcher = PATTERN.matcher(typeStr.trim().replaceAll("\\s+", "_").toUpperCase());
            if (matcher.find()) {
                try {
                    return Enum.valueOf(DataType.class, matcher.group(0));
                }
                catch (Exception ex) {
                    Logger.getLogger(CastExpression.class.getName()).log(Level.FINE, "Type " + typeStr + " unknown", ex);
                    return UNKNOWN;
                }
            }
            Logger.getLogger(CastExpression.class.getName()).log(Level.FINE, "Type " + typeStr + " unknown");
            return UNKNOWN;
        }
    }
}

