/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate.periodic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogPeriodicAlertCalculator {
    private static final Logger log = LoggerFactory.getLogger(LogPeriodicAlertCalculator.class);
    private static final String ROWS = "__rows__";
    private final DataSourceService dataSourceService;
    private final AlarmCommonReduce alarmCommonReduce;

    public LogPeriodicAlertCalculator(DataSourceService dataSourceService, AlarmCommonReduce alarmCommonReduce) {
        this.alarmCommonReduce = alarmCommonReduce;
        this.dataSourceService = dataSourceService;
    }

    public void calculate(AlertDefine define) {
        if (!define.isEnable() || StringUtils.isEmpty((CharSequence)define.getExpr())) {
            log.error("Log define {} is disabled or expression is empty", (Object)define.getName());
            return;
        }
        try {
            this.doCalculate(define);
        }
        catch (Exception e) {
            log.error("Calculate periodic define {} failed: {}", (Object)define.getName(), (Object)e.getMessage());
        }
    }

    private void doCalculate(AlertDefine define) {
        try {
            List<Map<String, Object>> results = this.dataSourceService.query(define.getDatasource(), define.getExpr());
            if (CollectionUtils.isEmpty(results)) {
                return;
            }
            this.afterThresholdRuleMatch(results, define);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getAlertMode(AlertDefine alertDefine) {
        String mode = null;
        if (alertDefine.getLabels() != null) {
            mode = (String)alertDefine.getLabels().get("alert_mode");
        }
        if (mode == null || mode.isEmpty()) {
            return "group";
        }
        return mode;
    }

    private void afterThresholdRuleMatch(List<Map<String, Object>> alertContext, AlertDefine define) {
        String alertMode = this.getAlertMode(define);
        long currentTime = System.currentTimeMillis();
        switch (alertMode) {
            case "individual": {
                for (Map<String, Object> context : alertContext) {
                    this.generateIndividualAlert(define, context, currentTime);
                }
                break;
            }
            case "group": {
                this.generateGroupAlert(define, alertContext, currentTime);
                break;
            }
            default: {
                log.warn("Unknown alert mode for define {}: {}", (Object)define.getName(), (Object)alertMode);
            }
        }
    }

    private void generateIndividualAlert(AlertDefine define, Map<String, Object> context, long currentTime) {
        HashMap<String, String> alertLabels = new HashMap<String, String>(8);
        Map<String, String> commonFingerPrints = this.createCommonFingerprints(define);
        alertLabels.putAll(commonFingerPrints);
        this.addContextToMap(context, alertLabels);
        Map<String, Object> fieldValueMap = this.createFieldValueMap(context, define);
        Map<String, String> alertAnnotations = this.createAlertAnnotations(define, fieldValueMap);
        SingleAlert alert = SingleAlert.builder().labels(alertLabels).annotations(alertAnnotations).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("firing").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTime)).activeAt(Long.valueOf(currentTime)).build();
        this.alarmCommonReduce.reduceAndSendAlarm(alert.clone());
        log.debug("Generated individual alert for define: {}", (Object)define.getName());
    }

    private void addContextToMap(Map<String, Object> context, Map<String, String> alertLabels) {
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (entry.getValue() == null) continue;
            alertLabels.put(entry.getKey(), entry.getValue().toString());
        }
    }

    private void generateGroupAlert(AlertDefine define, List<Map<String, Object>> alertContext, long currentTime) {
        ArrayList<SingleAlert> alerts = new ArrayList<SingleAlert>(alertContext.size());
        Map<String, String> commonFingerPrints = this.createCommonFingerprints(define);
        commonFingerPrints.put(ROWS, String.valueOf(alertContext.size()));
        commonFingerPrints.put("alert_mode", "group");
        for (Map<String, Object> context : alertContext) {
            HashMap<String, String> alertLabels = new HashMap<String, String>(8);
            alertLabels.putAll(commonFingerPrints);
            this.addContextToMap(context, alertLabels);
            Map<String, Object> fieldValueMap = this.createFieldValueMap(context, define);
            Map<String, String> alertAnnotations = this.createAlertAnnotations(define, fieldValueMap);
            SingleAlert alert = SingleAlert.builder().labels(alertLabels).annotations(alertAnnotations).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("firing").triggerTimes(Integer.valueOf(alertContext.size())).startAt(Long.valueOf(currentTime)).activeAt(Long.valueOf(currentTime)).build();
            alerts.add(alert.clone());
        }
        this.alarmCommonReduce.reduceAndSendAlarmGroup(commonFingerPrints, alerts);
        log.debug("Generated group alert for define: {} with {} matching data", (Object)define.getName(), (Object)alertContext.size());
    }

    private Map<String, String> createCommonFingerprints(AlertDefine define) {
        HashMap<String, String> fingerprints = new HashMap<String, String>(8);
        fingerprints.put("alertname", define.getName());
        fingerprints.put("defineid", String.valueOf(define.getId()));
        if (define.getLabels() != null) {
            fingerprints.putAll(define.getLabels());
        }
        return fingerprints;
    }

    private Map<String, Object> createFieldValueMap(Map<String, Object> context, AlertDefine define) {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (entry.getValue() == null) continue;
            fieldValueMap.put(entry.getKey(), entry.getValue().toString());
        }
        if (define.getLabels() != null) {
            fieldValueMap.putAll(define.getLabels());
        }
        return fieldValueMap;
    }

    private Map<String, String> createAlertAnnotations(AlertDefine define, Map<String, Object> fieldValueMap) {
        HashMap<String, String> annotations = new HashMap<String, String>(8);
        if (define.getAnnotations() != null) {
            for (Map.Entry entry : define.getAnnotations().entrySet()) {
                annotations.put((String)entry.getKey(), AlertTemplateUtil.render((String)entry.getValue(), fieldValueMap));
            }
        }
        return annotations;
    }
}

