/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncident;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.manager.pojo.dto.ComponentStatus;
import org.apache.hertzbeat.manager.service.StatusPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Status Page Public API")
@RestController
@RequestMapping(value={"/api/status/page/public"}, produces={"application/json"})
public class StatusPagePublicController {
    @Autowired
    private StatusPageService statusPageService;

    @GetMapping(value={"/org"})
    @Operation(summary="Query Status Page Organization")
    public ResponseEntity<Message<StatusPageOrg>> queryStatusPageOrg() {
        StatusPageOrg statusPageOrg = this.statusPageService.queryStatusPageOrg();
        if (statusPageOrg == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)"Status Page Organization Not Found"));
        }
        return ResponseEntity.ok((Object)Message.success((Object)statusPageOrg));
    }

    @GetMapping(value={"/component"})
    @Operation(summary="Query Status Page Components")
    public ResponseEntity<Message<List<ComponentStatus>>> queryStatusPageComponent() {
        List<ComponentStatus> componentStatusList = this.statusPageService.queryComponentsStatus();
        return ResponseEntity.ok((Object)Message.success(componentStatusList));
    }

    @GetMapping(value={"/component/{id}"})
    @Operation(summary="Query Status Page Component")
    public ResponseEntity<Message<ComponentStatus>> queryStatusPageComponent(@PathVariable(value="id") long id) {
        ComponentStatus componentStatus = this.statusPageService.queryComponentStatus(id);
        return ResponseEntity.ok((Object)Message.success((Object)componentStatus));
    }

    @GetMapping(value={"/incident"})
    @Operation(summary="Query Status Page Incidents")
    public ResponseEntity<Message<Page<StatusPageIncident>>> queryStatusPageIncident(@Parameter(description="Search-Target", example="x") @RequestParam(required=false) String search, @Parameter(description="Start Time", example="1756384301907") @RequestParam(required=false) Long startTime, @Parameter(description="End Time", example="1756384301907") @RequestParam(required=false) Long endTime, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pages", example="10") @RequestParam(defaultValue="10") int pageSize) {
        Page<StatusPageIncident> incidents = this.statusPageService.queryStatusPageIncidents(search, startTime, endTime, pageIndex, pageSize);
        return ResponseEntity.ok((Object)Message.success(incidents));
    }
}

