/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.DnsClass;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;
import org.pcap4j.util.ByteArrays;

public final class DnsResourceRecord
implements Serializable {
    private static final long serialVersionUID = 4951400991563055073L;
    private final DnsDomainName name;
    private final DnsResourceRecordType dataType;
    private final DnsClass dataClass;
    private final int ttl;
    private final short rdLength;
    private final DnsRData rData;

    public static DnsResourceRecord newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsResourceRecord(rawData, offset, length);
    }

    private DnsResourceRecord(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int cursor = 0;
        this.name = DnsDomainName.newInstance(rawData, offset, length);
        if (length - (cursor += this.name.length()) < 10) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build type, class, ttl, and rdlength of DnsResourceRecord. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.dataType = DnsResourceRecordType.getInstance(ByteArrays.getShort(rawData, offset + cursor));
        this.dataClass = DnsClass.getInstance(ByteArrays.getShort(rawData, offset + (cursor += 2)));
        this.ttl = ByteArrays.getInt(rawData, offset + (cursor += 2));
        this.rdLength = ByteArrays.getShort(rawData, offset + (cursor += 4));
        int rdLen = this.getRdLengthAsInt();
        if (length - (cursor += 2) < rdLen) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build rData of DnsResourceRecord (").append(rdLen).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor).append(", dataType: ").append(this.dataType);
            throw new IllegalRawDataException(sb.toString());
        }
        this.rData = rdLen != 0 ? PacketFactories.getFactory(DnsRData.class, DnsResourceRecordType.class).newInstance(rawData, offset + cursor, rdLen, this.dataType) : null;
    }

    private DnsResourceRecord(Builder builder) {
        if (builder == null || builder.name == null || builder.dataType == null || builder.dataClass == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder).append(" builder.name: ").append(builder.name).append(" builder.dataType: ").append(builder.dataType).append(" builder.dataClass: ").append(builder.dataClass);
            throw new NullPointerException(sb.toString());
        }
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.dataClass = builder.dataClass;
        this.ttl = builder.ttl;
        this.rData = builder.rData;
        if (builder.correctLengthAtBuild) {
            int rdLen;
            int n = rdLen = this.rData == null ? 0 : this.rData.length();
            if ((rdLen & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("(rData.length() & 0xFFFF0000) must be zero. rData: " + this.rData);
            }
            this.rdLength = (short)rdLen;
        } else {
            this.rdLength = builder.rdLength;
        }
    }

    public DnsDomainName getName() {
        return this.name;
    }

    public DnsResourceRecordType getDataType() {
        return this.dataType;
    }

    public DnsClass getDataClass() {
        return this.dataClass;
    }

    public int getTtl() {
        return this.ttl;
    }

    public long getTtlAsLong() {
        return (long)this.ttl & 0xFFFFFFFFL;
    }

    public short getRdLength() {
        return this.rdLength;
    }

    public int getRdLengthAsInt() {
        return this.rdLength & 0xFFFF;
    }

    public DnsRData getRData() {
        return this.rData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        int cursor = 0;
        byte[] rawName = this.name.getRawData();
        System.arraycopy(rawName, 0, data, 0, rawName.length);
        System.arraycopy(ByteArrays.toByteArray((Short)this.dataType.value()), 0, data, cursor += rawName.length, 2);
        System.arraycopy(ByteArrays.toByteArray((Short)this.dataClass.value()), 0, data, cursor += 2, 2);
        System.arraycopy(ByteArrays.toByteArray(this.ttl), 0, data, cursor += 2, 4);
        System.arraycopy(ByteArrays.toByteArray(this.rdLength), 0, data, cursor += 4, 2);
        if (this.rData != null) {
            byte[] rawRData = this.rData.getRawData();
            System.arraycopy(rawRData, 0, data, cursor += 2, rawRData.length);
        }
        return data;
    }

    public int length() {
        int rDataLen = this.rData == null ? 0 : this.rData.length();
        return this.name.length() + 6 + 4 + rDataLen;
    }

    public String toString() {
        return this.convertToString("", null);
    }

    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("NAME: ").append(headerRawData != null ? this.name.toString(headerRawData) : this.name).append(ls).append(indent).append("TYPE: ").append(this.dataType).append(ls).append(indent).append("CLASS: ").append(this.dataClass).append(ls).append(indent).append("TTL: ").append(this.getTtlAsLong()).append(ls).append(indent).append("RDLENGTH: ").append(this.getRdLengthAsInt()).append(ls);
        if (this.rData != null) {
            sb.append(indent).append("RDATA:").append(ls).append(headerRawData != null ? this.rData.toString(indent + "  ", headerRawData) : this.rData.toString(indent + "  "));
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + this.dataClass.hashCode();
        result = 31 * result + this.ttl;
        result = 31 * result + this.rdLength;
        result = 31 * result + (this.rData != null ? this.rData.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsResourceRecord that = (DnsResourceRecord)o;
        if (this.ttl != that.ttl) {
            return false;
        }
        if (this.rdLength != that.rdLength) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.dataType.equals(that.dataType)) {
            return false;
        }
        if (!this.dataClass.equals(that.dataClass)) {
            return false;
        }
        return this.rData != null ? this.rData.equals(that.rData) : that.rData == null;
    }

    public static interface DnsRData
    extends Serializable {
        public int length();

        public byte[] getRawData();

        public String toString(String var1);

        public String toString(String var1, byte[] var2);
    }

    public static final class Builder
    implements LengthBuilder<DnsResourceRecord> {
        private DnsDomainName name;
        private DnsResourceRecordType dataType;
        private DnsClass dataClass;
        private int ttl;
        private short rdLength;
        private DnsRData rData;
        private boolean correctLengthAtBuild = false;

        public Builder() {
        }

        private Builder(DnsResourceRecord obj) {
            this.name = obj.name;
            this.dataType = obj.dataType;
            this.dataClass = obj.dataClass;
            this.ttl = obj.ttl;
            this.rdLength = obj.rdLength;
            this.rData = obj.rData;
        }

        public Builder name(DnsDomainName name) {
            this.name = name;
            return this;
        }

        public Builder dataType(DnsResourceRecordType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataClass(DnsClass dataClass) {
            this.dataClass = dataClass;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder rdLength(short rdLength) {
            this.rdLength = rdLength;
            return this;
        }

        public Builder rData(DnsRData rData) {
            this.rData = rData;
            return this;
        }

        @Override
        public LengthBuilder<DnsResourceRecord> correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public DnsResourceRecord build() {
            return new DnsResourceRecord(this);
        }
    }
}

