/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_status_page_incident_content")
@Schema(description="status page incident content entity")
@EntityListeners(value={AuditingEntityListener.class})
public class StatusPageIncidentContent {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="ID", example="87584674384")
    private Long id;
    @Schema(title="org id", example="1234")
    @Column(name="incident_id")
    private Long incidentId;
    @Schema(title="incident content message", example="we find the gateway connection timeout")
    @NotBlank
    private String message;
    @Schema(title="incident state: 0-Investigating 1-Identified 2-Monitoring 3-Resolved", example="0")
    private byte state;
    @Schema(title="incident content message timestamp", example="4248574985744")
    private Long timestamp;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="The modifier of this record", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="Record create time", example="1612198922000")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static StatusPageIncidentContentBuilder builder() {
        return new StatusPageIncidentContentBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getIncidentId() {
        return this.incidentId;
    }

    public String getMessage() {
        return this.message;
    }

    public byte getState() {
        return this.state;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIncidentId(Long incidentId) {
        this.incidentId = incidentId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusPageIncidentContent)) {
            return false;
        }
        StatusPageIncidentContent other = (StatusPageIncidentContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$incidentId = this.getIncidentId();
        Long other$incidentId = other.getIncidentId();
        if (this$incidentId == null ? other$incidentId != null : !((Object)this$incidentId).equals(other$incidentId)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusPageIncidentContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getState();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $incidentId = this.getIncidentId();
        result = result * 59 + ($incidentId == null ? 43 : ((Object)$incidentId).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "StatusPageIncidentContent(id=" + this.getId() + ", incidentId=" + this.getIncidentId() + ", message=" + this.getMessage() + ", state=" + this.getState() + ", timestamp=" + this.getTimestamp() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public StatusPageIncidentContent(Long id, Long incidentId, String message, byte state, Long timestamp, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.incidentId = incidentId;
        this.message = message;
        this.state = state;
        this.timestamp = timestamp;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public StatusPageIncidentContent() {
    }

    public static class StatusPageIncidentContentBuilder {
        private Long id;
        private Long incidentId;
        private String message;
        private byte state;
        private Long timestamp;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        StatusPageIncidentContentBuilder() {
        }

        public StatusPageIncidentContentBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StatusPageIncidentContentBuilder incidentId(Long incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public StatusPageIncidentContentBuilder message(String message) {
            this.message = message;
            return this;
        }

        public StatusPageIncidentContentBuilder state(byte state) {
            this.state = state;
            return this;
        }

        public StatusPageIncidentContentBuilder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public StatusPageIncidentContentBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public StatusPageIncidentContentBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public StatusPageIncidentContentBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public StatusPageIncidentContentBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public StatusPageIncidentContent build() {
            return new StatusPageIncidentContent(this.id, this.incidentId, this.message, this.state, this.timestamp, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "StatusPageIncidentContent.StatusPageIncidentContentBuilder(id=" + this.id + ", incidentId=" + this.incidentId + ", message=" + this.message + ", state=" + this.state + ", timestamp=" + this.timestamp + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

