/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonByteListAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.ZonedDateTimeAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_silence")
@Schema(description="Alert Silence Policy Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertSilence {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Primary Key Index ID", example="87584674384")
    private Long id;
    @Schema(title="Policy name", example="silence-1")
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Whether to enable this policy", example="true")
    private boolean enable = true;
    @Schema(title="Whether to match all", example="true")
    private boolean matchAll = true;
    @Schema(title="Silence type 0: once, 1:cyc", example="1")
    @NotNull
    private Byte type;
    @Schema(title="Silenced alerts num", example="3")
    private Integer times;
    @Schema(description="Match the alarm information label", example="{name: key1, value: value1}")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> labels;
    @Schema(title="The day of the WEEK is valid in periodic silence, multiple, all or empty is daily 7: Sunday 1: Monday 2: Tuesday 3: Wednesday 4: Thursday 5: Friday 6: Saturday", example="[0,1]")
    @Convert(converter=JsonByteListAttributeConverter.class)
    private List<Byte> days;
    @Schema(title="Limit time period start", example="00:00:00")
    @Convert(converter=ZonedDateTimeAttributeConverter.class)
    private ZonedDateTime periodStart;
    @Schema(title="Restricted time period end", example="23:59:59")
    @Convert(converter=ZonedDateTimeAttributeConverter.class)
    private ZonedDateTime periodEnd;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static AlertSilenceBuilder builder() {
        return new AlertSilenceBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public Byte getType() {
        return this.type;
    }

    public Integer getTimes() {
        return this.times;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public List<Byte> getDays() {
        return this.days;
    }

    public ZonedDateTime getPeriodStart() {
        return this.periodStart;
    }

    public ZonedDateTime getPeriodEnd() {
        return this.periodEnd;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setDays(List<Byte> days) {
        this.days = days;
    }

    public void setPeriodStart(ZonedDateTime periodStart) {
        this.periodStart = periodStart;
    }

    public void setPeriodEnd(ZonedDateTime periodEnd) {
        this.periodEnd = periodEnd;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertSilence)) {
            return false;
        }
        AlertSilence other = (AlertSilence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isMatchAll() != other.isMatchAll()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Byte this$type = this.getType();
        Byte other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$times = this.getTimes();
        Integer other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<Byte> this$days = this.getDays();
        List<Byte> other$days = other.getDays();
        if (this$days == null ? other$days != null : !((Object)this$days).equals(other$days)) {
            return false;
        }
        ZonedDateTime this$periodStart = this.getPeriodStart();
        ZonedDateTime other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        ZonedDateTime this$periodEnd = this.getPeriodEnd();
        ZonedDateTime other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertSilence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isMatchAll() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Byte $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<Byte> $days = this.getDays();
        result = result * 59 + ($days == null ? 43 : ((Object)$days).hashCode());
        ZonedDateTime $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        ZonedDateTime $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "AlertSilence(id=" + this.getId() + ", name=" + this.getName() + ", enable=" + this.isEnable() + ", matchAll=" + this.isMatchAll() + ", type=" + this.getType() + ", times=" + this.getTimes() + ", labels=" + this.getLabels() + ", days=" + this.getDays() + ", periodStart=" + this.getPeriodStart() + ", periodEnd=" + this.getPeriodEnd() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertSilence(Long id, String name, boolean enable, boolean matchAll, Byte type, Integer times, Map<String, String> labels, List<Byte> days, ZonedDateTime periodStart, ZonedDateTime periodEnd, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.enable = enable;
        this.matchAll = matchAll;
        this.type = type;
        this.times = times;
        this.labels = labels;
        this.days = days;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertSilence() {
    }

    public static class AlertSilenceBuilder {
        private Long id;
        private String name;
        private boolean enable;
        private boolean matchAll;
        private Byte type;
        private Integer times;
        private Map<String, String> labels;
        private List<Byte> days;
        private ZonedDateTime periodStart;
        private ZonedDateTime periodEnd;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertSilenceBuilder() {
        }

        public AlertSilenceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertSilenceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AlertSilenceBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertSilenceBuilder matchAll(boolean matchAll) {
            this.matchAll = matchAll;
            return this;
        }

        public AlertSilenceBuilder type(Byte type) {
            this.type = type;
            return this;
        }

        public AlertSilenceBuilder times(Integer times) {
            this.times = times;
            return this;
        }

        public AlertSilenceBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public AlertSilenceBuilder days(List<Byte> days) {
            this.days = days;
            return this;
        }

        public AlertSilenceBuilder periodStart(ZonedDateTime periodStart) {
            this.periodStart = periodStart;
            return this;
        }

        public AlertSilenceBuilder periodEnd(ZonedDateTime periodEnd) {
            this.periodEnd = periodEnd;
            return this;
        }

        public AlertSilenceBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertSilenceBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertSilenceBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertSilenceBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertSilence build() {
            return new AlertSilence(this.id, this.name, this.enable, this.matchAll, this.type, this.times, this.labels, this.days, this.periodStart, this.periodEnd, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertSilence.AlertSilenceBuilder(id=" + this.id + ", name=" + this.name + ", enable=" + this.enable + ", matchAll=" + this.matchAll + ", type=" + this.type + ", times=" + this.times + ", labels=" + this.labels + ", days=" + this.days + ", periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

