/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class DirectUserTarget<A extends Address>
extends UserTarget<A> {
    private static final long serialVersionUID = 2156539556559873408L;
    private AuthenticationProtocol authenticationProtocol;
    private PrivacyProtocol privacyProtocol;
    private OctetString authenticationKey;
    private OctetString privacyKey;

    public DirectUserTarget() {
        this.setSecurityModel(3);
    }

    public DirectUserTarget(UserTarget<A> userTarget) {
        super(userTarget);
    }

    public DirectUserTarget(A address, OctetString securityName, byte[] authoritativeEngineID, AuthenticationProtocol authenticationProtocol, OctetString authenticationKey, PrivacyProtocol privacyProtocol, OctetString privacyKey) {
        super(address, securityName, authoritativeEngineID);
        this.setSecurityLevel(authenticationKey == null || authenticationKey.length() == 0 ? 1 : (privacyKey == null || privacyKey.length() == 0 ? 2 : 3));
        this.setSecurityModel(3);
        this.authenticationProtocol = authenticationProtocol;
        this.privacyProtocol = privacyProtocol;
        this.authenticationKey = authenticationKey;
        this.privacyKey = privacyKey;
    }

    public OctetString getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(OctetString authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public OctetString getPrivacyKey() {
        return this.privacyKey;
    }

    public void setPrivacyKey(OctetString privacyKey) {
        this.privacyKey = privacyKey;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    @Override
    public String toString() {
        return "UserTarget[" + this.toStringAbstractTarget() + ", authoritativeEngineID=" + this.authoritativeEngineID + ", securityLevel=" + this.securityLevel + ", authenticationKey=" + (String)(this.authenticationKey != null ? "(" + this.authenticationKey.length() + " bytes)" : "null") + ", privacyKey=" + (String)(this.privacyKey != null ? "(" + this.privacyKey.length() + " bytes)" : "null") + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectUserTarget that = (DirectUserTarget)o;
        if (this.getAuthenticationProtocol() != null ? !this.getAuthenticationProtocol().equals(that.getAuthenticationProtocol()) : that.getAuthenticationProtocol() != null) {
            return false;
        }
        if (this.getPrivacyProtocol() != null ? !this.getPrivacyProtocol().equals(that.getPrivacyProtocol()) : that.getPrivacyProtocol() != null) {
            return false;
        }
        if (this.getAuthenticationKey() != null ? !this.getAuthenticationKey().equals(that.getAuthenticationKey()) : that.getAuthenticationKey() != null) {
            return false;
        }
        return this.getPrivacyKey() != null ? this.getPrivacyKey().equals(that.getPrivacyKey()) : that.getPrivacyKey() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getAuthenticationProtocol() != null ? this.getAuthenticationProtocol().hashCode() : 0);
        result = 31 * result + (this.getPrivacyProtocol() != null ? this.getPrivacyProtocol().hashCode() : 0);
        result = 31 * result + (this.getAuthenticationKey() != null ? this.getAuthenticationKey().hashCode() : 0);
        result = 31 * result + (this.getPrivacyKey() != null ? this.getPrivacyKey().hashCode() : 0);
        return result;
    }

    @Override
    public Target<A> duplicate() {
        DirectUserTarget copy = new DirectUserTarget(this.getAddress(), this.securityName, this.authoritativeEngineID.getValue(), this.authenticationProtocol, this.authenticationKey, this.privacyProtocol, this.privacyKey);
        copy.setSecurityLevel(this.getSecurityLevel());
        copy.setRetries(this.getRetries());
        copy.setTimeout(this.getTimeout());
        copy.setMaxSizeRequestPDU(this.getMaxSizeRequestPDU());
        copy.setSecurityModel(this.getSecurityModel());
        copy.setVersion(this.getVersion());
        copy.setPreferredTransports(this.getPreferredTransports());
        return copy;
    }
}

