/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.UdpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(UdpCollectImpl.class);
    private static final byte[] HELLO = "hello".getBytes(StandardCharsets.UTF_8);

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics == null || metrics.getUdp() == null) {
            throw new IllegalArgumentException("Udp collect must has udp params");
        }
    }

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        long startTime = System.currentTimeMillis();
        UdpProtocol udpProtocol = metrics.getUdp();
        int timeout = CollectUtil.getTimeout((String)udpProtocol.getTimeout());
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(timeout);
            String content = udpProtocol.getContent();
            byte[] buffer = CollectUtil.fromHexString((String)content);
            buffer = buffer == null ? HELLO : buffer;
            InetSocketAddress socketAddress = new InetSocketAddress(udpProtocol.getHost(), Integer.parseInt(udpProtocol.getPort()));
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, socketAddress);
            socket.send(request);
            byte[] responseBuffer = new byte[1];
            DatagramPacket response = new DatagramPacket(responseBuffer, responseBuffer.length);
            socket.receive(response);
            long responseTime = System.currentTimeMillis() - startTime;
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String alias : metrics.getAliasFields()) {
                if ("responseTime".equalsIgnoreCase(alias)) {
                    valueRowBuilder.addColumn(Long.toString(responseTime));
                    continue;
                }
                valueRowBuilder.addColumn("&nbsp;");
            }
            builder.addValueRow(valueRowBuilder.build());
        }
        catch (SocketTimeoutException timeoutException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)timeoutException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_CONNECTABLE);
            builder.setMsg("Peer connect failed: " + errorMsg);
        }
        catch (PortUnreachableException portUnreachableException) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)portUnreachableException);
            log.info(errorMsg);
            builder.setCode(CollectRep.Code.UN_REACHABLE);
            builder.setMsg("Peer port unreachable");
        }
        catch (Exception exception) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)exception);
            log.warn(errorMsg, (Throwable)exception);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    public String supportProtocol() {
        return "udp";
    }
}

