/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.NameBind;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import java.io.Closeable;
import java.sql.SQLException;

public class Parameter
extends Column
implements Closeable {
    public static final byte TYPE_FLAG_UNKNOWN = 0;
    public static final byte TYPE_FLAG_EXACT = 1;
    public static final byte TYPE_FLAG_RECOMMEND = 2;
    public byte typeFlag = 0;
    public static final byte IO_TYPE_UNKNOWN = -1;
    public static final byte IO_TYPE_IN = 0;
    public static final byte IO_TYPE_OUT = 1;
    public static final byte IO_TYPE_INOUT = 2;
    public byte ioType = (byte)-1;
    public int outJType = Integer.MIN_VALUE;
    public int outScale = -1;
    public String outObjectName;
    public DmdbStatement cursorStmt;
    public boolean hasDefault;

    public void resetType(int n2) {
        this.type = n2;
        this.scale = 0;
        switch (n2) {
            case 3: 
            case 13: {
                this.prec = 1;
                break;
            }
            case 5: {
                this.prec = 1;
                break;
            }
            case 6: {
                this.prec = 2;
                break;
            }
            case 7: {
                this.prec = 4;
                break;
            }
            case 8: {
                this.prec = 8;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.prec = 32768;
                break;
            }
            case 19: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 17: 
            case 18: {
                this.prec = 32768;
                break;
            }
            case 12: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                this.prec = 3;
                break;
            }
            case 15: {
                this.prec = 5;
                this.scale = 6;
                break;
            }
            case 22: {
                this.prec = 7;
                this.scale = 6;
                break;
            }
            case 16: {
                this.prec = 8;
                this.scale = 6;
                break;
            }
            case 23: {
                this.prec = 10;
                this.scale = 6;
                break;
            }
            case 26: {
                this.prec = 9;
                this.scale = 9;
                break;
            }
            case 27: {
                this.prec = 11;
                this.scale = 9;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                this.prec = 0;
                break;
            }
            case 28: 
            case 54: {
                this.type = 2;
                this.prec = 32768;
                break;
            }
        }
    }

    public void clear() {
        this.outJType = Integer.MIN_VALUE;
        this.outScale = -1;
        this.outObjectName = null;
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
        this.ioType = (byte)-1;
        this.name = "";
        this.mask = 0;
    }

    @Override
    public void close() {
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
    }

    public String toString() {
        return "[type: " + this.type + ", prec: " + this.prec + ", scale: " + this.scale + ", typeFlag: " + this.typeFlag + "]";
    }

    public int getIParam(NameBind nameBind) {
        return nameBind.iParam;
    }

    public Parameter clone(DmdbConnection dmdbConnection, DmdbPreparedStatement dmdbPreparedStatement) {
        Parameter parameter = new Parameter();
        parameter.baseName = this.baseName;
        parameter.identity = this.identity;
        parameter.isBdta = this.isBdta;
        parameter.lob = this.lob;
        parameter.lobColId = this.lobColId;
        parameter.lobTabId = this.lobTabId;
        parameter.name = this.name;
        parameter.nullable = this.nullable;
        parameter.prec = this.prec;
        parameter.readonly = this.readonly;
        parameter.scale = this.scale;
        parameter.schemaName = this.schemaName;
        parameter.tableName = this.tableName;
        parameter.type = this.type;
        parameter.typeDescriptor = this.typeDescriptor;
        parameter.typeName = this.typeName;
        parameter.mask = this.mask;
        parameter.hasDefault = this.hasDefault;
        parameter.ioType = this.ioType;
        parameter.outJType = this.outJType;
        parameter.outObjectName = this.outObjectName;
        parameter.outScale = this.outScale;
        parameter.typeFlag = this.typeFlag;
        if (this.cursorStmt != null && !this.cursorStmt.closed && dmdbConnection != null && dmdbPreparedStatement != null) {
            parameter.cursorStmt = dmdbConnection.createCursorStatement(dmdbPreparedStatement.resultSetType, dmdbPreparedStatement.resultSetConcurrency, dmdbPreparedStatement.resultSetHoldability);
        }
        return parameter;
    }

    public static boolean typeEquals(Parameter[] parameterArray, Parameter[] parameterArray2) {
        int n2 = 0;
        while (n2 < parameterArray.length) {
            if (parameterArray[n2] != null || parameterArray2[n2] != null) {
                if (parameterArray[n2] == null || parameterArray2[n2] == null) {
                    return false;
                }
                if (parameterArray[n2].type != parameterArray2[n2].type || parameterArray[n2].prec != parameterArray2[n2].prec || parameterArray[n2].scale != parameterArray2[n2].scale || parameterArray[n2].name != parameterArray2[n2].name || parameterArray[n2].ioType != parameterArray2[n2].ioType || parameterArray[n2].typeDescriptor != parameterArray2[n2].typeDescriptor || parameterArray[n2].mask != parameterArray2[n2].mask) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }
}

