/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcWCHAR
extends PlcIECValue<Integer> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static final Integer minValue = 0;
    static final Integer maxValue = 65535;

    public static PlcWCHAR of(Object value) {
        if (value instanceof Boolean) {
            return new PlcWCHAR((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcWCHAR((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcWCHAR((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcWCHAR((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcWCHAR((Long)value);
        }
        if (value instanceof Float) {
            return new PlcWCHAR((Float)value);
        }
        if (value instanceof Double) {
            return new PlcWCHAR((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcWCHAR((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcWCHAR((BigDecimal)value);
        }
        return new PlcWCHAR((String)value);
    }

    public PlcWCHAR(Boolean value) {
        this.value = value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        this.isNullable = false;
    }

    public PlcWCHAR(Byte value) {
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Character value) {
        char val = value.charValue();
        if (val < minValue || val > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = (int)val;
        this.isNullable = false;
    }

    public PlcWCHAR(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcWCHAR(Long value) {
        if (value < (long)minValue.intValue() || value > (long)maxValue.intValue()) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Float value) {
        if (value.floatValue() < (float)minValue.intValue() || value.floatValue() > (float)maxValue.intValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(Double value) {
        if (value < (double)minValue.intValue() || value > (double)maxValue.intValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = false;
    }

    public PlcWCHAR(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.intValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.intValue())) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcWCHAR(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.intValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.intValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.intValue();
        this.isNullable = true;
    }

    public PlcWCHAR(String value) {
        try {
            char val;
            String s = value.trim();
            if (s.length() == 0) {
                s = " ";
            }
            if ((val = s.charAt(0)) < minValue || val > maxValue) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = (int)val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcWCHAR(int value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.WCHAR;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Integer)this.value).equals(0);
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Integer)this.value <= 127 && (Integer)this.value >= -128;
    }

    @Override
    public byte getByte() {
        return ((Integer)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Integer)this.value <= Short.MAX_VALUE && (Integer)this.value >= Short.MIN_VALUE;
    }

    @Override
    public short getShort() {
        return ((Integer)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return (Integer)this.value;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return ((Integer)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Integer)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Integer)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public Object getObject() {
        return Character.toString((char)((Integer)this.value).intValue());
    }

    public String toString() {
        return Character.toString((char)((Integer)this.value).intValue());
    }

    public byte[] getBytes() {
        return new byte[]{(byte)((Integer)this.value >> 8 & 0xFF), (byte)((Integer)this.value & 0xFF)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Integer)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), 16, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

