/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcBREAL
extends PlcIECValue<BigDecimal> {
    public static PlcBREAL of(Object value) {
        if (value instanceof Boolean) {
            return new PlcBREAL((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcBREAL((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcBREAL((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcBREAL((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcBREAL((Long)value);
        }
        if (value instanceof Float) {
            return new PlcBREAL((Float)value);
        }
        if (value instanceof Double) {
            return new PlcBREAL((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcBREAL((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcBREAL((BigDecimal)value);
        }
        return new PlcBREAL((String)value);
    }

    public PlcBREAL(Boolean value) {
        this.value = value != false ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        this.isNullable = false;
    }

    public PlcBREAL(Byte value) {
        this.value = BigDecimal.valueOf(value.byteValue());
        this.isNullable = false;
    }

    public PlcBREAL(Short value) {
        this.value = BigDecimal.valueOf(value.shortValue());
        this.isNullable = false;
    }

    public PlcBREAL(Integer value) {
        this.value = BigDecimal.valueOf(value.intValue());
        this.isNullable = false;
    }

    public PlcBREAL(Long value) {
        this.value = BigDecimal.valueOf(value);
        this.isNullable = false;
    }

    public PlcBREAL(Float value) {
        this.value = BigDecimal.valueOf(value.floatValue());
        this.isNullable = false;
    }

    public PlcBREAL(Double value) {
        this.value = BigDecimal.valueOf(value);
        this.isNullable = false;
    }

    public PlcBREAL(BigInteger value) {
        this.value = new BigDecimal(value);
        this.isNullable = false;
    }

    public PlcBREAL(BigDecimal value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcBREAL(String value) {
        this.value = new BigDecimal(value.trim());
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.ULINT;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((BigDecimal)this.value).equals(BigDecimal.ZERO);
    }

    @Override
    public boolean isByte() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(127L)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(-128L)) >= 0;
    }

    @Override
    public byte getByte() {
        return ((BigDecimal)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(32767L)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(-32768L)) >= 0;
    }

    @Override
    public short getShort() {
        return ((BigDecimal)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    public int getInteger() {
        return ((BigDecimal)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return this.value != null && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) <= 0 && ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    public long getLong() {
        return ((BigDecimal)this.value).longValue();
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return ((BigDecimal)this.value).toBigInteger();
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((BigDecimal)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((BigDecimal)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return (BigDecimal)this.value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return ((BigDecimal)this.value).toString();
    }

    public byte[] getBytes() {
        byte[] tmp = ((BigDecimal)this.value).unscaledValue().toByteArray();
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = i >= bytes.length - tmp.length ? tmp[i - (bytes.length - tmp.length)] : (byte)0;
            ++i;
        }
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeBigDecimal(this.getClass().getSimpleName(), 64, (BigDecimal)this.value, new WithWriterArgs[0]);
    }
}

