/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.io;

import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.codegen.io.DataIoSerializerFunction;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplex;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class DataWriterDataIoDefault
implements DataWriterComplex<PlcValue> {
    protected final WriteBuffer writeBuffer;
    protected final DataIoSerializerFunction<WriteBuffer> serializer;

    public DataWriterDataIoDefault(WriteBuffer writeBuffer, DataIoSerializerFunction<WriteBuffer> serializer) {
        this.writeBuffer = writeBuffer;
        this.serializer = serializer;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.writeBuffer.getByteOrder();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.writeBuffer.setByteOrder(byteOrder);
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.writeBuffer.pushContext(logicalName, writerArgs);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        this.writeBuffer.popContext(logicalName, writerArgs);
    }

    @Override
    public void write(String logicalName, PlcValue value, WithWriterArgs ... writerArgs) throws SerializationException {
        boolean hasLogicalName = StringUtils.isNotBlank((CharSequence)logicalName);
        if (hasLogicalName) {
            this.writeBuffer.pushContext(logicalName, new WithWriterArgs[0]);
        }
        this.serializer.apply(this.writeBuffer, value);
        if (hasLogicalName) {
            this.writeBuffer.popContext(logicalName, new WithWriterArgs[0]);
        }
    }

    @Override
    public WriteBuffer getWriteBuffer() {
        return this.writeBuffer;
    }
}

