/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.identify;

import com.alibaba.nacos.client.auth.ram.identify.CredentialService;
import com.alibaba.nacos.client.auth.ram.identify.Credentials;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CredentialWatcher {
    private static final Logger SPAS_LOGGER = LogUtils.logger(CredentialWatcher.class);
    private static final long REFRESH_INTERVAL = 10000L;
    private final CredentialService serviceInstance;
    private final String appName;
    private String propertyPath;
    private boolean stopped;
    private final ScheduledExecutorService executor;

    public CredentialWatcher(String appName, CredentialService serviceInstance) {
        this.appName = appName;
        this.serviceInstance = serviceInstance;
        this.loadCredential(true);
        this.executor = ExecutorFactory.newSingleScheduledExecutorService(new NameThreadFactory("com.alibaba.nacos.client.auth.ram.identify.watcher"));
        this.executor.scheduleWithFixedDelay(new Runnable(){
            private long modified = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CredentialWatcher.this.stopped) {
                        return;
                    }
                    boolean reload = false;
                    if (CredentialWatcher.this.propertyPath == null) {
                        reload = true;
                    } else {
                        File file = new File(CredentialWatcher.this.propertyPath);
                        long lastModified = file.lastModified();
                        if (this.modified != lastModified) {
                            reload = true;
                            this.modified = lastModified;
                        }
                    }
                    if (reload) {
                        CredentialWatcher.this.loadCredential(false);
                    }
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        if (this.executor != null) {
            ScheduledExecutorService scheduledExecutorService = this.executor;
            synchronized (scheduledExecutorService) {
                this.stopped = true;
                this.executor.shutdown();
            }
        }
        SPAS_LOGGER.info("[{}] {} is stopped", (Object)this.appName, (Object)this.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredential(boolean init) {
        Credentials credential;
        if (this.propertyPath == null) {
            URL url = ClassLoader.getSystemResource("spas.properties");
            if (url != null) {
                this.propertyPath = url.getPath();
            }
            if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                String value = NacosClientProperties.PROTOTYPE.getProperty("spas.identity");
                if (StringUtils.isNotEmpty(value)) {
                    this.propertyPath = value;
                }
                if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                    this.propertyPath = "/home/admin/.spas_key/" + (this.appName == null ? "default" : this.appName);
                } else if (init) {
                    SPAS_LOGGER.info("[{}] Defined credential file: -Dspas.identity={}", (Object)this.appName, (Object)this.propertyPath);
                }
            } else if (init) {
                SPAS_LOGGER.info("[{}] Load credential file from classpath: {}", (Object)this.appName, (Object)"spas.properties");
            }
        }
        FileInputStream propertiesIS = null;
        while (true) {
            try {
                propertiesIS = new FileInputStream(this.propertyPath);
            }
            catch (FileNotFoundException e) {
                if (this.appName != null && !this.appName.equals("default") && this.propertyPath.equals("/home/admin/.spas_key/" + this.appName)) {
                    this.propertyPath = "/home/admin/.spas_key/default";
                    continue;
                }
                if ("/etc/instanceInfo".equals(this.propertyPath)) break;
                this.propertyPath = "/etc/instanceInfo";
                continue;
            }
            break;
        }
        String accessKey = null;
        String secretKey = null;
        String tenantId = null;
        if (propertiesIS == null) {
            this.propertyPath = null;
            accessKey = NacosClientProperties.PROTOTYPE.getProperty("spas_accessKey");
            secretKey = NacosClientProperties.PROTOTYPE.getProperty("spas_secretKey");
            if (accessKey == null && secretKey == null) {
                if (init) {
                    SPAS_LOGGER.info("{} No credential found", (Object)this.appName);
                }
                return;
            }
        } else {
            Properties properties = new Properties();
            try {
                properties.load(propertiesIS);
            }
            catch (IOException e) {
                SPAS_LOGGER.error("[26] Unable to load credential file, appName:" + this.appName + "Unable to load credential file " + this.propertyPath, (Throwable)e);
                this.propertyPath = null;
                return;
            }
            finally {
                try {
                    ((InputStream)propertiesIS).close();
                }
                catch (IOException e) {
                    SPAS_LOGGER.error("[27] Unable to close credential file, appName:" + this.appName + "Unable to close credential file " + this.propertyPath, (Throwable)e);
                }
            }
            if (init) {
                SPAS_LOGGER.info("[{}] Load credential file {}", (Object)this.appName, (Object)this.propertyPath);
            }
            if (!"/etc/instanceInfo".equals(this.propertyPath)) {
                if (properties.containsKey("accessKey")) {
                    accessKey = properties.getProperty("accessKey");
                }
                if (properties.containsKey("secretKey")) {
                    secretKey = properties.getProperty("secretKey");
                }
                if (properties.containsKey("tenantId")) {
                    tenantId = properties.getProperty("tenantId");
                }
            } else {
                if (properties.containsKey("env_spas_accessKey")) {
                    accessKey = properties.getProperty("env_spas_accessKey");
                }
                if (properties.containsKey("env_spas_secretKey")) {
                    secretKey = properties.getProperty("env_spas_secretKey");
                }
                if (properties.containsKey("ebv_spas_tenantId")) {
                    tenantId = properties.getProperty("ebv_spas_tenantId");
                }
            }
        }
        if (accessKey != null) {
            accessKey = accessKey.trim();
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (tenantId != null) {
            tenantId = tenantId.trim();
        }
        if (!(credential = new Credentials(accessKey, secretKey, tenantId)).valid()) {
            SPAS_LOGGER.warn("[1] Credential file missing required property {} Credential file missing {} or {}", new Object[]{this.appName, "accessKey", "secretKey"});
            this.propertyPath = null;
        }
        this.serviceInstance.setCredential(credential);
    }
}

