/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import org.apache.iotdb.rpc.AutoResizingBuffer;
import org.apache.iotdb.rpc.NonOpenTransport;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class AutoScalingBufferReadTransport
extends NonOpenTransport {
    private final AutoResizingBuffer buf;
    private int pos = 0;
    private int limit = 0;

    public AutoScalingBufferReadTransport(int initialCapacity) {
        this.buf = new AutoResizingBuffer(initialCapacity);
    }

    public void fill(TTransport inTrans, int length) throws TTransportException {
        this.buf.resizeIfNecessary(length);
        inTrans.readAll(this.buf.array(), 0, length);
        this.pos = 0;
        this.limit = length;
    }

    public final int read(byte[] target, int off, int len) {
        int amtToRead = Math.min(len, this.getBytesRemainingInBuffer());
        System.arraycopy(this.buf.array(), this.pos, target, off, amtToRead);
        this.consumeBuffer(amtToRead);
        return amtToRead;
    }

    public void write(byte[] buf, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public final void consumeBuffer(int len) {
        this.pos += len;
    }

    public TConfiguration getConfiguration() {
        return null;
    }

    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }

    public final byte[] getBuffer() {
        return this.buf.array();
    }

    public final int getBufferPosition() {
        return this.pos;
    }

    public final int getBytesRemainingInBuffer() {
        return this.limit - this.pos;
    }

    public void resizeIfNecessary(int size) {
        this.buf.resizeIfNecessary(size);
    }

    public void limit(int newLimit) {
        this.limit = newLimit;
    }

    public void position(int newPosition) {
        this.pos = newPosition;
    }
}

