/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import org.snmp4j.SNMP4JSettings;
import org.snmp4j.User;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUser
implements User,
Comparable<UsmUser>,
Cloneable {
    private static final long serialVersionUID = -2258973598142206767L;
    private final OctetString securityName;
    private final SecretOctetString authenticationPassphrase;
    private final SecretOctetString privacyPassphrase;
    private final OID authenticationProtocol;
    private final OID privacyProtocol;
    private OctetString localizationEngineID;

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase) {
        if (securityName == null) {
            throw new NullPointerException();
        }
        if (SNMP4JSettings.isCheckUsmUserPassphraseLength()) {
            if (authenticationProtocol != null && authenticationPassphrase != null && authenticationPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
            if (privacyProtocol != null && privacyPassphrase != null && privacyPassphrase.length() < 8) {
                throw new IllegalArgumentException("USM passphrases must be at least 8 bytes long (RFC3414 \u00a711.2)");
            }
        }
        this.securityName = securityName;
        this.authenticationProtocol = authenticationProtocol;
        this.authenticationPassphrase = SecretOctetString.fromOctetString(authenticationPassphrase);
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = SecretOctetString.fromOctetString(privacyPassphrase);
    }

    public UsmUser(OctetString securityName, OID authenticationProtocol, OctetString authenticationPassphrase, OID privacyProtocol, OctetString privacyPassphrase, OctetString localizationEngineID) {
        if (securityName == null) {
            throw new NullPointerException();
        }
        this.securityName = securityName;
        this.authenticationProtocol = authenticationProtocol;
        this.authenticationPassphrase = SecretOctetString.fromOctetString(authenticationPassphrase);
        this.privacyProtocol = privacyProtocol;
        this.privacyPassphrase = SecretOctetString.fromOctetString(privacyPassphrase);
        this.localizationEngineID = localizationEngineID;
    }

    public OctetString getSecurityName() {
        return (OctetString)this.securityName.clone();
    }

    public OID getAuthenticationProtocol() {
        if (this.authenticationProtocol == null) {
            return null;
        }
        return (OID)this.authenticationProtocol.clone();
    }

    public OID getPrivacyProtocol() {
        if (this.privacyProtocol == null) {
            return null;
        }
        return (OID)this.privacyProtocol.clone();
    }

    public OctetString getAuthenticationPassphrase() {
        if (this.authenticationPassphrase == null) {
            return null;
        }
        return (OctetString)this.authenticationPassphrase.clone();
    }

    public OctetString getPrivacyPassphrase() {
        if (this.privacyPassphrase == null) {
            return null;
        }
        return (OctetString)this.privacyPassphrase.clone();
    }

    public OctetString getLocalizationEngineID() {
        return this.localizationEngineID;
    }

    public boolean isLocalized() {
        return this.localizationEngineID != null;
    }

    public int getSecurityModel() {
        return 3;
    }

    @Override
    public int compareTo(UsmUser other) {
        return this.securityName.compareTo(other.securityName);
    }

    public Object clone() {
        UsmUser copy = new UsmUser(this.securityName, this.authenticationProtocol, this.authenticationPassphrase, this.privacyProtocol, this.privacyPassphrase, this.localizationEngineID);
        return copy;
    }

    public UsmUser localizeUser(OctetString localizationEngineID, OctetString localizedAuthenticationKey, OctetString localizedPrivacyKey, SecurityProtocols securityProtocols) {
        if (!(this.getLocalizationEngineID() == null || localizationEngineID.equals(this.getLocalizationEngineID()) || localizedAuthenticationKey != null && localizedPrivacyKey != null)) {
            throw new IllegalArgumentException("Localization engine ID cannot be changed");
        }
        if (localizationEngineID == null || localizationEngineID.length() == 0) {
            throw new NullPointerException();
        }
        OctetString newAuthKey = localizedAuthenticationKey == null ? (this.getAuthenticationProtocol() != null && this.getAuthenticationPassphrase() != null ? new SecretOctetString(securityProtocols.passwordToKey(this.getAuthenticationProtocol(), this.getAuthenticationPassphrase(), localizationEngineID.getValue())) : null) : localizedAuthenticationKey;
        OctetString newPrivKey = localizedPrivacyKey == null ? (this.getAuthenticationProtocol() != null && this.getPrivacyProtocol() != null && this.getPrivacyPassphrase() != null ? new SecretOctetString(securityProtocols.passwordToKey(this.getPrivacyProtocol(), this.getAuthenticationProtocol(), this.getPrivacyPassphrase(), localizationEngineID.getValue())) : null) : localizedPrivacyKey;
        return new UsmUser(this.getSecurityName(), this.getAuthenticationProtocol(), newAuthKey, this.getPrivacyProtocol(), newPrivKey, localizationEngineID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsmUser usmUser = (UsmUser)o;
        if (!this.securityName.equals(usmUser.securityName)) {
            return false;
        }
        if (this.authenticationPassphrase != null ? !this.authenticationPassphrase.equals(usmUser.authenticationPassphrase) : usmUser.authenticationPassphrase != null) {
            return false;
        }
        if (this.privacyPassphrase != null ? !this.privacyPassphrase.equals(usmUser.privacyPassphrase) : usmUser.privacyPassphrase != null) {
            return false;
        }
        if (this.authenticationProtocol != null ? !this.authenticationProtocol.equals(usmUser.authenticationProtocol) : usmUser.authenticationProtocol != null) {
            return false;
        }
        if (this.privacyProtocol != null ? !this.privacyProtocol.equals(usmUser.privacyProtocol) : usmUser.privacyProtocol != null) {
            return false;
        }
        return !(this.localizationEngineID != null ? !this.localizationEngineID.equals(usmUser.localizationEngineID) : usmUser.localizationEngineID != null);
    }

    public int hashCode() {
        return this.securityName.hashCode();
    }

    public String toString() {
        return "UsmUser[secName=" + this.securityName + ",authProtocol=" + this.authenticationProtocol + ",authPassphrase=" + this.authenticationPassphrase + ",privProtocol=" + this.privacyProtocol + ",privPassphrase=" + this.privacyPassphrase + ",localizationEngineID=" + this.getLocalizationEngineID() + "]";
    }
}

