/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcTIME_OF_DAY
extends PlcSimpleValue<LocalTime> {
    public static PlcTIME_OF_DAY of(Object value) {
        if (value instanceof LocalTime) {
            return new PlcTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof Long) {
            return new PlcTIME_OF_DAY((Long)value);
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcTIME_OF_DAY ofMillisecondsSinceMidnight(long millisecondsSinceMidnight) {
        return new PlcTIME_OF_DAY(LocalTime.ofNanoOfDay(millisecondsSinceMidnight * 1000000L));
    }

    public PlcTIME_OF_DAY(LocalTime value) {
        super(value, true);
    }

    public PlcTIME_OF_DAY(long millisecondsSinceMidnight) {
        super(LocalTime.ofNanoOfDay(millisecondsSinceMidnight * 1000000L), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.TIME_OF_DAY;
    }

    public long getMillisecondsSinceMidnight() {
        return ((LocalTime)this.value).toNanoOfDay() / 1000000L;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return this.getMillisecondsSinceMidnight();
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return ((LocalTime)this.value).toString();
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public LocalTime getTime() {
        return (LocalTime)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, valueString, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
    }
}

