/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.config.internal;

import io.opentelemetry.instrumentation.api.incubator.config.internal.EnduserConfig;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.internal.HttpConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CommonConfig {
    private final PeerServiceResolver peerServiceResolver;
    private final List<String> clientRequestHeaders;
    private final List<String> clientResponseHeaders;
    private final List<String> serverRequestHeaders;
    private final List<String> serverResponseHeaders;
    private final Set<String> knownHttpRequestMethods;
    private final EnduserConfig enduserConfig;
    private final boolean statementSanitizationEnabled;
    private final boolean emitExperimentalHttpClientTelemetry;
    private final boolean emitExperimentalHttpServerTelemetry;
    private final boolean redactQueryParameters;
    private final String loggingTraceIdKey;
    private final String loggingSpanIdKey;
    private final String loggingTraceFlagsKey;

    public CommonConfig(InstrumentationConfig config) {
        this.peerServiceResolver = PeerServiceResolver.create(config.getMap("otel.instrumentation.common.peer-service-mapping", Collections.emptyMap()));
        this.clientRequestHeaders = config.getList("otel.instrumentation.http.client.capture-request-headers");
        this.clientResponseHeaders = config.getList("otel.instrumentation.http.client.capture-response-headers");
        this.serverRequestHeaders = config.getList("otel.instrumentation.http.server.capture-request-headers");
        this.serverResponseHeaders = config.getList("otel.instrumentation.http.server.capture-response-headers");
        this.knownHttpRequestMethods = new HashSet<String>(config.getList("otel.instrumentation.http.known-methods", new ArrayList<String>(HttpConstants.KNOWN_METHODS)));
        this.statementSanitizationEnabled = config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true);
        this.emitExperimentalHttpClientTelemetry = config.getBoolean("otel.instrumentation.http.client.emit-experimental-telemetry", false);
        this.redactQueryParameters = config.getBoolean("otel.instrumentation.http.client.experimental.redact-query-parameters", true);
        this.emitExperimentalHttpServerTelemetry = config.getBoolean("otel.instrumentation.http.server.emit-experimental-telemetry", false);
        this.enduserConfig = new EnduserConfig(config);
        this.loggingTraceIdKey = config.getString("otel.instrumentation.common.logging.trace-id", "trace_id");
        this.loggingSpanIdKey = config.getString("otel.instrumentation.common.logging.span-id", "span_id");
        this.loggingTraceFlagsKey = config.getString("otel.instrumentation.common.logging.trace-flags", "trace_flags");
    }

    public PeerServiceResolver getPeerServiceResolver() {
        return this.peerServiceResolver;
    }

    public List<String> getClientRequestHeaders() {
        return this.clientRequestHeaders;
    }

    public List<String> getClientResponseHeaders() {
        return this.clientResponseHeaders;
    }

    public List<String> getServerRequestHeaders() {
        return this.serverRequestHeaders;
    }

    public List<String> getServerResponseHeaders() {
        return this.serverResponseHeaders;
    }

    public Set<String> getKnownHttpRequestMethods() {
        return this.knownHttpRequestMethods;
    }

    public EnduserConfig getEnduserConfig() {
        return this.enduserConfig;
    }

    public boolean isStatementSanitizationEnabled() {
        return this.statementSanitizationEnabled;
    }

    public boolean shouldEmitExperimentalHttpClientTelemetry() {
        return this.emitExperimentalHttpClientTelemetry;
    }

    public boolean shouldEmitExperimentalHttpServerTelemetry() {
        return this.emitExperimentalHttpServerTelemetry;
    }

    public boolean redactQueryParameters() {
        return this.redactQueryParameters;
    }

    public String getTraceIdKey() {
        return this.loggingTraceIdKey;
    }

    public String getSpanIdKey() {
        return this.loggingSpanIdKey;
    }

    public String getTraceFlagsKey() {
        return this.loggingTraceFlagsKey;
    }
}

