/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.image.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultImageModelObservationConvention
implements ImageModelObservationConvention {
    public static final String DEFAULT_NAME = "gen_ai.client.operation";
    private static final KeyValue REQUEST_MODEL_NONE = KeyValue.of((KeyName)ImageModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)"none");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(ImageModelObservationContext context) {
        if (StringUtils.hasText((String)((ImagePrompt)context.getRequest()).getOptions().getModel())) {
            return "%s %s".formatted(context.getOperationMetadata().operationType(), ((ImagePrompt)context.getRequest()).getOptions().getModel());
        }
        return context.getOperationMetadata().operationType();
    }

    public KeyValues getLowCardinalityKeyValues(ImageModelObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.requestModel(context)});
    }

    protected KeyValue aiOperationType(ImageModelObservationContext context) {
        return KeyValue.of((KeyName)ImageModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(ImageModelObservationContext context) {
        return KeyValue.of((KeyName)ImageModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue requestModel(ImageModelObservationContext context) {
        if (StringUtils.hasText((String)((ImagePrompt)context.getRequest()).getOptions().getModel())) {
            return KeyValue.of((KeyName)ImageModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)((ImagePrompt)context.getRequest()).getOptions().getModel());
        }
        return REQUEST_MODEL_NONE;
    }

    public KeyValues getHighCardinalityKeyValues(ImageModelObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.requestImageFormat(keyValues, context);
        keyValues = this.requestImageSize(keyValues, context);
        keyValues = this.requestImageStyle(keyValues, context);
        return keyValues;
    }

    protected KeyValues requestImageFormat(KeyValues keyValues, ImageModelObservationContext context) {
        if (StringUtils.hasText((String)((ImagePrompt)context.getRequest()).getOptions().getResponseFormat())) {
            return keyValues.and(ImageModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_IMAGE_RESPONSE_FORMAT.asString(), ((ImagePrompt)context.getRequest()).getOptions().getResponseFormat());
        }
        return keyValues;
    }

    protected KeyValues requestImageSize(KeyValues keyValues, ImageModelObservationContext context) {
        if (((ImagePrompt)context.getRequest()).getOptions().getWidth() != null && ((ImagePrompt)context.getRequest()).getOptions().getHeight() != null) {
            return keyValues.and(ImageModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_IMAGE_SIZE.asString(), "%sx%s".formatted(((ImagePrompt)context.getRequest()).getOptions().getWidth(), ((ImagePrompt)context.getRequest()).getOptions().getHeight()));
        }
        return keyValues;
    }

    protected KeyValues requestImageStyle(KeyValues keyValues, ImageModelObservationContext context) {
        if (StringUtils.hasText((String)((ImagePrompt)context.getRequest()).getOptions().getStyle())) {
            return keyValues.and(ImageModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_IMAGE_STYLE.asString(), ((ImagePrompt)context.getRequest()).getOptions().getStyle());
        }
        return keyValues;
    }
}

