/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.jpa.repository.query.EmptyQueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

interface QueryTokenStream
extends Streamable<QueryToken> {
    public static QueryTokenStream empty() {
        return EmptyQueryTokenStream.INSTANCE;
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::inline, separator);
    }

    public static <T> QueryTokenStream justAs(Collection<T> elements, Function<T, QueryToken> converter) {
        return QueryTokenStream.concat(elements, it -> QueryRenderer.QueryRendererBuilder.from((QueryToken)converter.apply(it)), QueryRenderer::inline, QueryTokens.TOKEN_SPACE);
    }

    public static <T> QueryTokenStream concatExpressions(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::expression, separator);
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, Function<QueryTokenStream, QueryTokenStream> postProcess, QueryToken separator) {
        QueryRenderer.QueryRendererBuilder builder = null;
        QueryTokenStream firstElement = null;
        for (T element : elements) {
            QueryTokenStream tokenStream = postProcess.apply(visitor.apply(element));
            if (firstElement == null) {
                firstElement = tokenStream;
                continue;
            }
            if (builder == null) {
                builder = QueryRenderer.builder();
                builder.append(firstElement);
            }
            if (!builder.isEmpty()) {
                builder.append(separator);
            }
            builder.append(tokenStream);
        }
        if (builder != null) {
            return builder;
        }
        if (firstElement != null) {
            return firstElement;
        }
        return QueryTokenStream.empty();
    }

    @Nullable
    default public QueryToken getFirst() {
        Iterator it = this.iterator();
        return it.hasNext() ? (QueryToken)it.next() : null;
    }

    @Nullable
    default public QueryToken getLast() {
        return (QueryToken)CollectionUtils.lastElement((List)this.toList());
    }

    public boolean isExpression();

    public int size();

    public boolean isEmpty();
}

