/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class DnsOpCode
extends NamedNumber<Byte, DnsOpCode> {
    private static final long serialVersionUID = -7397483318208343692L;
    public static final DnsOpCode QUERY = new DnsOpCode((byte)0, "Query");
    public static final DnsOpCode IQUERY = new DnsOpCode((byte)1, "IQuery");
    public static final DnsOpCode STATUS = new DnsOpCode((byte)2, "Status");
    public static final DnsOpCode NOTIFY = new DnsOpCode((byte)4, "Notify");
    public static final DnsOpCode UPDATE = new DnsOpCode((byte)5, "Update");
    private static final Map<Byte, DnsOpCode> registry = new HashMap<Byte, DnsOpCode>();

    public DnsOpCode(Byte value, String name) {
        super(value, name);
        if ((value & 0xF0) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. DNS OpCode must be between 0 and 15");
        }
    }

    public static DnsOpCode getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new DnsOpCode(value, "unknown");
    }

    public static DnsOpCode register(DnsOpCode code) {
        return registry.put((Byte)code.value(), code);
    }

    @Override
    public int compareTo(DnsOpCode o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)QUERY.value(), QUERY);
        registry.put((Byte)IQUERY.value(), IQUERY);
        registry.put((Byte)STATUS.value(), STATUS);
        registry.put((Byte)NOTIFY.value(), NOTIFY);
        registry.put((Byte)UPDATE.value(), UPDATE);
    }
}

