/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hertzbeat.alert.dto.VolcEngineExternEventAlert;
import org.apache.hertzbeat.alert.dto.VolcEngineExternMetricAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VolcEngineExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(VolcEngineExternAlertService.class);
    private final AlarmCommonReduce alarmCommonReduce;
    private static final Map<String, Integer> severityOrder = Map.of("critical", 1, "warning", 2, "info", 3);

    @Override
    public void addExternAlert(String content) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(content);
        String type = root.get("Type").asText();
        if ("Event".equals(type)) {
            VolcEngineExternEventAlert eventAlert = (VolcEngineExternEventAlert)JsonUtil.fromJson((String)content, VolcEngineExternEventAlert.class);
            if (eventAlert == null) {
                log.warn("parse extern event alert content failed! content: {}", (Object)content);
                return;
            }
            SingleAlert singleAlert = new VolcEngineAlertConverter().convertEventToSingleAlert(eventAlert);
            this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
        } else {
            VolcEngineExternMetricAlert report = (VolcEngineExternMetricAlert)JsonUtil.fromJson((String)content, VolcEngineExternMetricAlert.class);
            if (report == null) {
                log.warn("parse extern metrics alert content failed! content: {}", (Object)content);
                return;
            }
            for (SingleAlert singleAlert : new VolcEngineAlertConverter().convertMetricAlertToSingeAlert(report)) {
                this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
            }
        }
    }

    @Override
    public String supportSource() {
        return "volcengine";
    }

    public VolcEngineExternAlertService(AlarmCommonReduce alarmCommonReduce) {
        this.alarmCommonReduce = alarmCommonReduce;
    }

    public static class VolcEngineAlertConverter {
        public List<SingleAlert> convertMetricAlertToSingeAlert(VolcEngineExternMetricAlert alert) {
            String status = this.convertStatus(alert);
            if (Objects.equals(alert.getType(), "Metric")) {
                return this.convertMetricAlert(alert, status, alert.getResources());
            }
            if (Objects.equals(alert.getType(), "MetricsNoData")) {
                return this.convertMetricAlert(alert, status, alert.getNoDataResources());
            }
            if (Objects.equals(alert.getType(), "NoDataRecovered")) {
                return this.convertMetricAlert(alert, status, alert.getNoDataRecoveredResources());
            }
            if (Objects.equals(alert.getType(), "MetricRecovered")) {
                return this.convertMetricAlert(alert, status, alert.getRecoveredResources());
            }
            return List.of();
        }

        public SingleAlert convertEventToSingleAlert(VolcEngineExternEventAlert alert) {
            SingleAlert.SingleAlertBuilder builder = SingleAlert.builder().status("firing").startAt(Long.valueOf(alert.getHappenedAt() * 1000L)).activeAt(Long.valueOf(alert.getHappenedAt() * 1000L)).labels(this.buildEventLabels(alert)).content(alert.getDescriptionCn()).annotations(new HashMap());
            return builder.build();
        }

        private Map<String, String> buildEventLabels(VolcEngineExternEventAlert event) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("severity", this.convertEventSeverity(event));
            labels.put("__source__", "volcengine");
            labels.put("resource_name", event.getDetails().getVolcResourceName());
            labels.put("account_id", event.getAccountId());
            labels.put("region", event.getRegion());
            labels.put("event_type", event.getEventType());
            labels.put("source", event.getSource());
            return labels;
        }

        private String convertEventSeverity(VolcEngineExternEventAlert alert) {
            return alert.getRules().stream().map(VolcEngineExternEventAlert.EventRule::getLevel).min((o1, o2) -> severityOrder.get(this.convertCommonSeverity((String)o1)).compareTo(severityOrder.get(this.convertCommonSeverity((String)o2)))).orElse("info");
        }

        private String convertCommonSeverity(String level) {
            return switch (level) {
                case "critical" -> "critical";
                case "warning" -> "warning";
                default -> "info";
            };
        }

        private List<SingleAlert> convertMetricAlert(VolcEngineExternMetricAlert alert, String status, List<? extends VolcEngineExternMetricAlert.Resource> resources) {
            if (CollectionUtils.isEmpty(resources)) {
                return List.of();
            }
            ArrayList<SingleAlert> result = new ArrayList<SingleAlert>();
            for (VolcEngineExternMetricAlert.Resource resource : resources) {
                SingleAlert.SingleAlertBuilder builder = SingleAlert.builder().status(status).startAt(Long.valueOf(resource.getFirstAlertTime() * 1000L)).endAt(Long.valueOf(resource.getLastAlertTime() * 1000L)).labels(this.buildLabels(alert, resource)).activeAt(this.convertHappenAt(alert.getHappenedAt())).content(resource.getName() + alert.getRuleCondition()).annotations(this.buildAnnotations(resource));
                result.add(builder.build());
            }
            return result;
        }

        private Long convertHappenAt(String happenAt) {
            String cleanedStr = happenAt.replace("UTC", "").replace("(", "").replace(")", "");
            DateTimeFormatter altFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
            OffsetDateTime odt = OffsetDateTime.parse(cleanedStr, altFormatter);
            return odt.toEpochSecond() * 1000L;
        }

        private Map<String, String> buildLabels(VolcEngineExternMetricAlert alert, VolcEngineExternMetricAlert.Resource resource) {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("__source__", "volcengine");
            labels.put("resource_name", resource.getName());
            labels.put("resource_id", resource.getId());
            labels.put("rule_id", alert.getRuleId());
            return labels;
        }

        private Map<String, String> buildAnnotations(VolcEngineExternMetricAlert.Resource resource) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            if (resource instanceof VolcEngineExternMetricAlert.NoDataResource) {
                VolcEngineExternMetricAlert.NoDataResource noDataResource = (VolcEngineExternMetricAlert.NoDataResource)resource;
                for (VolcEngineExternMetricAlert.Metric noDataMetric : noDataResource.getNoDataMetrics()) {
                    annotations.put(noDataMetric.getName(), "N/A");
                }
            }
            for (VolcEngineExternMetricAlert.Metric metric : resource.getMetrics()) {
                annotations.put(metric.getName(), metric.getCurrentValue() + metric.getUnit());
            }
            annotations.put("region", resource.getRegion());
            List<VolcEngineExternMetricAlert.Dimension> dimensions = resource.getDimensions();
            if (CollectionUtils.isNotEmpty(dimensions)) {
                for (VolcEngineExternMetricAlert.Dimension dimension : dimensions) {
                    annotations.put(dimension.getNameCn(), dimension.getValue());
                }
            }
            return annotations;
        }

        private String convertStatus(VolcEngineExternMetricAlert alert) {
            String type = alert.getType();
            if (Objects.equals(type, "Metric") || Objects.equals(type, "Event") || Objects.equals(type, "MetricsNoData")) {
                return "firing";
            }
            return "resolved";
        }
    }
}

