/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.http.promethus;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.List;
import org.apache.hertzbeat.collector.collect.http.promethus.AbstractPrometheusParse;
import org.apache.hertzbeat.collector.util.CollectUtil;
import org.apache.hertzbeat.common.entity.dto.PromVectorOrMatrix;
import org.apache.hertzbeat.common.entity.job.protocol.HttpProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;

public class PrometheusVectorParser
extends AbstractPrometheusParse {
    @Override
    public Boolean checkType(String responseStr) {
        try {
            PromVectorOrMatrix promVectorOrMatrix = (PromVectorOrMatrix)JsonUtil.fromJson((String)responseStr, PromVectorOrMatrix.class);
            if (promVectorOrMatrix != null && promVectorOrMatrix.getData() != null) {
                return "vector".equals(promVectorOrMatrix.getData().getResultType());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void parse(String resp, List<String> aliasFields, HttpProtocol http, CollectRep.MetricsData.Builder builder) {
        boolean setTimeFlag = false;
        boolean setValueFlag = false;
        PromVectorOrMatrix promVectorOrMatrix = (PromVectorOrMatrix)JsonUtil.fromJson((String)resp, PromVectorOrMatrix.class);
        if (promVectorOrMatrix == null) {
            return;
        }
        List result = promVectorOrMatrix.getData().getResult();
        for (PromVectorOrMatrix.Result r : result) {
            CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
            for (String aliasField : aliasFields) {
                if (!CollectUtil.assertPromRequireField((String)aliasField).booleanValue() || CollectUtil.isValueAsLabel((String)aliasField, (JsonObject)r.getMetric()).booleanValue()) {
                    JsonElement jsonElement = r.getMetric().get(aliasField);
                    if (jsonElement != null) {
                        valueRowBuilder.addColumn(jsonElement.getAsString());
                        continue;
                    }
                    valueRowBuilder.addColumn("&nbsp;");
                    continue;
                }
                if ("timestamp".equals(aliasField)) {
                    for (Object o : r.getValue()) {
                        if (!(o instanceof Double)) continue;
                        Double time = (Double)o;
                        valueRowBuilder.addColumn(String.valueOf(BigDecimal.valueOf(time * 1000.0)));
                        setTimeFlag = true;
                    }
                    if (setTimeFlag) continue;
                    valueRowBuilder.addColumn("&nbsp;");
                    continue;
                }
                for (Object o : r.getValue()) {
                    if (!(o instanceof String)) continue;
                    String str = (String)o;
                    valueRowBuilder.addColumn(str);
                    setValueFlag = true;
                }
                if (setValueFlag) continue;
                valueRowBuilder.addColumn("&nbsp;");
            }
            builder.addValueRow(valueRowBuilder.build());
        }
    }
}

