/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.util;

import com.beetstra.jutf7.CharsetProvider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectUtil.class);
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int HEX_STR_WIDTH = 2;
    private static final String SMILING_PLACEHOLDER = "^_^";
    private static final String SMILING_PLACEHOLDER_REX = "\\^_\\^";
    private static final String SMILING_PLACEHOLDER_REGEX = "(\\^_\\^)(\\w|-|$|\\.)+(\\^_\\^)";
    private static final Pattern SMILING_PLACEHOLDER_REGEX_PATTERN = Pattern.compile("(\\^_\\^)(\\w|-|$|\\.)+(\\^_\\^)");
    private static final String CRYING_PLACEHOLDER_REX = "\\^o\\^";
    private static final String CRYING_PLACEHOLDER_REGEX = "(\\^o\\^)(\\w|-|$|\\.)+(\\^o\\^)";
    private static final Pattern CRYING_PLACEHOLDER_REGEX_PATTERN = Pattern.compile("(\\^o\\^)(\\w|-|$|\\.)+(\\^o\\^)");
    private static final List<String> UNIT_SYMBOLS = Arrays.asList("%", "G", "g", "M", "m", "K", "k", "B", "b", "Ki", "Mi", "Gi");
    private static final Gson GSON = new Gson();
    private static final String DOUBLE_AND_UNIT_CHECK_REGEX = "^[.\\d+" + String.join((CharSequence)"", UNIT_SYMBOLS) + "]+$";

    private CollectUtil() {
    }

    public static int countMatchKeyword(String content, String keyword) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{content, keyword})) {
            return 0;
        }
        try {
            Pattern pattern = Pattern.compile(keyword);
            Matcher matcher = pattern.matcher(content);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static DoubleAndUnit extractDoubleAndUnitFromStr(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        DoubleAndUnit doubleAndUnit = new DoubleAndUnit();
        try {
            Double doubleValue = Double.parseDouble(str);
            doubleAndUnit.setValue(doubleValue);
            return doubleAndUnit;
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            if (!str.matches(DOUBLE_AND_UNIT_CHECK_REGEX)) {
                return doubleAndUnit;
            }
            try {
                for (String unitSymbol : UNIT_SYMBOLS) {
                    int index = str.indexOf(unitSymbol);
                    if (index == 0) {
                        Double doubleValue = 0.0;
                        String unit = str.trim();
                        doubleAndUnit.setValue(doubleValue);
                        doubleAndUnit.setUnit(unit);
                        return doubleAndUnit;
                    }
                    if (index <= 0) continue;
                    Double doubleValue = Double.parseDouble(str.substring(0, index));
                    String unit = str.substring(index).trim();
                    doubleAndUnit.setValue(doubleValue);
                    doubleAndUnit.setUnit(unit);
                    return doubleAndUnit;
                }
            }
            catch (Exception e2) {
                log.debug(e2.getMessage());
            }
            return null;
        }
    }

    public static int getTimeout(String timeout) {
        return CollectUtil.getTimeout(timeout, 60000);
    }

    public static int getTimeout(String timeout, int defaultTimeout) {
        if (StringUtils.isEmpty((CharSequence)timeout)) {
            return defaultTimeout;
        }
        try {
            return Double.valueOf(timeout).intValue();
        }
        catch (Exception e) {
            return defaultTimeout;
        }
    }

    public static Boolean assertPromRequireField(String aliasField) {
        return "timestamp".equals(aliasField) || "value".equals(aliasField) || "metric_value".equals(aliasField);
    }

    public static Boolean isValueAsLabel(String aliasField, JsonObject metric) {
        return "value".equals(aliasField) && null != metric && metric.has(aliasField);
    }

    public static boolean containCryPlaceholder(JsonElement jsonElement) {
        String jsonStr = jsonElement.toString();
        return CRYING_PLACEHOLDER_REGEX_PATTERN.matcher(jsonStr).find();
    }

    public static boolean notContainCryPlaceholder(JsonElement jsonElement) {
        return !CollectUtil.containCryPlaceholder(jsonElement);
    }

    public static Set<String> matchCryPlaceholderField(JsonElement jsonElement) {
        String jsonStr = jsonElement.toString();
        return CRYING_PLACEHOLDER_REGEX_PATTERN.matcher(jsonStr).results().map(item -> item.group().replaceAll(CRYING_PLACEHOLDER_REX, "")).collect(Collectors.toSet());
    }

    private static String replaceSpecialCharacterIfNeeded(String value, String replacePattern, Matcher matcher, Map<String, Configmap> configmap) {
        matcher.reset();
        while (matcher.find()) {
            String group = matcher.group();
            String replaceField = group.replaceAll(replacePattern, "");
            Configmap param = configmap.get(replaceField);
            if (param == null) continue;
            if (param.getValue() != null) {
                value = value.replace(group, (String)param.getValue());
                continue;
            }
            if (group.length() == value.length()) {
                value = null;
                break;
            }
            value = value.replace(group, "");
        }
        return value;
    }

    public static Metrics replaceCryPlaceholderToMetrics(Metrics metricItem, Map<String, Configmap> configmap) {
        JsonElement metricJson = GSON.toJsonTree((Object)metricItem);
        CollectUtil.replaceCryPlaceholder(metricJson, configmap);
        return (Metrics)GSON.fromJson(metricJson, Metrics.class);
    }

    public static JsonElement replaceCryPlaceholder(JsonElement jsonElement, Map<String, Configmap> configmap) {
        block6: {
            block5: {
                if (!jsonElement.isJsonObject()) break block5;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!element.isJsonPrimitive()) {
                        jsonObject.add((String)entry.getKey(), CollectUtil.replaceCryPlaceholder((JsonElement)entry.getValue(), configmap));
                        continue;
                    }
                    String value = element.getAsString();
                    Matcher cryingMatcher = CRYING_PLACEHOLDER_REGEX_PATTERN.matcher(value);
                    if (!cryingMatcher.find()) continue;
                    value = CollectUtil.replaceSpecialCharacterIfNeeded(value, CRYING_PLACEHOLDER_REX, cryingMatcher, configmap);
                    jsonObject.addProperty((String)entry.getKey(), value);
                }
                break block6;
            }
            if (!jsonElement.isJsonArray()) break block6;
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            Iterator iterator = jsonArray.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                JsonElement element = (JsonElement)iterator.next();
                if (!element.isJsonPrimitive()) {
                    jsonArray.set(index, CollectUtil.replaceCryPlaceholder(element, configmap));
                    ++index;
                    continue;
                }
                String value = element.getAsString();
                Matcher cryingMatcher = CRYING_PLACEHOLDER_REGEX_PATTERN.matcher(value);
                if (!cryingMatcher.find()) {
                    ++index;
                    continue;
                }
                jsonArray.set(index, (JsonElement)((value = CollectUtil.replaceSpecialCharacterIfNeeded(value, CRYING_PLACEHOLDER_REX, cryingMatcher, configmap)) == null ? JsonNull.INSTANCE : new JsonPrimitive(value)));
                ++index;
            }
        }
        return jsonElement;
    }

    public static JsonElement replaceSmilingPlaceholder(JsonElement jsonElement, Map<String, Configmap> configmap) {
        block14: {
            block13: {
                if (!jsonElement.isJsonObject()) break block13;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Iterator iterator = jsonObject.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    JsonElement element = (JsonElement)entry.getValue();
                    String key = (String)entry.getKey();
                    if (key != null && key.startsWith(SMILING_PLACEHOLDER) && key.endsWith(SMILING_PLACEHOLDER)) {
                        TypeReference<Map<String, String>> typeReference;
                        String jsonValue;
                        Map map;
                        Configmap param = configmap.get(key = key.replaceAll(SMILING_PLACEHOLDER_REX, ""));
                        if (param != null && param.getType() == 3 && (map = (Map)JsonUtil.fromJson((String)(jsonValue = (String)param.getValue()), (TypeReference)(typeReference = new TypeReference<Map<String, String>>(){}))) != null) {
                            map.forEach((name, value) -> {
                                if (!StringUtils.isEmpty((CharSequence)name)) {
                                    jsonObject.addProperty(name, value);
                                }
                            });
                        }
                        iterator.remove();
                        continue;
                    }
                    if (!element.isJsonPrimitive()) {
                        jsonObject.add((String)entry.getKey(), CollectUtil.replaceSmilingPlaceholder((JsonElement)entry.getValue(), configmap));
                        continue;
                    }
                    String value2 = element.getAsString();
                    Matcher smilingMatcher = SMILING_PLACEHOLDER_REGEX_PATTERN.matcher(value2);
                    if (!smilingMatcher.find()) continue;
                    value2 = CollectUtil.replaceSpecialCharacterIfNeeded(value2, SMILING_PLACEHOLDER_REX, smilingMatcher, configmap);
                    jsonObject.addProperty((String)entry.getKey(), value2);
                }
                break block14;
            }
            if (!jsonElement.isJsonArray()) break block14;
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int index = 0; index < jsonArray.size(); ++index) {
                JsonElement element = jsonArray.get(index);
                if (element.isJsonPrimitive()) {
                    String value3 = element.getAsString();
                    Matcher smilingMatcher = SMILING_PLACEHOLDER_REGEX_PATTERN.matcher(value3);
                    if (!smilingMatcher.find()) continue;
                    smilingMatcher.reset();
                    String[] arrayValues = null;
                    while (smilingMatcher.find()) {
                        String group = smilingMatcher.group();
                        String replaceField = group.replaceAll(SMILING_PLACEHOLDER_REX, "");
                        Configmap param = configmap.get(replaceField);
                        if (param != null) {
                            if (param.getValue() == null) {
                                if (group.length() == value3.length()) {
                                    value3 = null;
                                    break;
                                }
                                value3 = value3.replace(group, "");
                                continue;
                            }
                            if (param.getType() == 4) {
                                arrayValues = String.valueOf(param.getValue()).split(",");
                                continue;
                            }
                            value3 = value3.replace(group, (String)param.getValue());
                            continue;
                        }
                        value3 = null;
                        break;
                    }
                    if (arrayValues != null) {
                        jsonArray.remove(index);
                        --index;
                        for (void var11_22 : arrayValues) {
                            jsonArray.add((String)var11_22);
                            ++index;
                        }
                        continue;
                    }
                    jsonArray.set(index, (JsonElement)(value3 == null ? JsonNull.INSTANCE : new JsonPrimitive(value3)));
                    continue;
                }
                jsonArray.set(index, CollectUtil.replaceSmilingPlaceholder(element, configmap));
            }
        }
        return jsonElement;
    }

    public static String replaceUriSpecialChar(String uri) {
        uri = uri.replaceAll(" ", "%20");
        return uri;
    }

    public static List<Map<String, Configmap>> getConfigmapFromPreCollectData(CollectRep.MetricsData metricsData) {
        if (metricsData.getValuesCount() <= 0 || metricsData.getFieldsCount() <= 0) {
            return new LinkedList<Map<String, Configmap>>();
        }
        LinkedList<Map<String, Configmap>> mapList = new LinkedList<Map<String, Configmap>>();
        for (CollectRep.ValueRow valueRow : metricsData.getValues()) {
            if (valueRow.getColumnsCount() != metricsData.getFieldsCount()) continue;
            HashMap<String, Configmap> configmapMap = new HashMap<String, Configmap>(valueRow.getColumnsCount());
            int index = 0;
            for (CollectRep.Field field : metricsData.getFields()) {
                String value = valueRow.getColumns(index);
                ++index;
                Configmap configmap = new Configmap(field.getName(), (Object)value, Integer.valueOf(field.getType()).byteValue());
                configmapMap.put(field.getName(), configmap);
            }
            mapList.add(configmapMap);
        }
        return mapList;
    }

    public static void replaceFieldsForPushStyleMonitor(Metrics metrics, Map<String, Configmap> configmap) {
        List pushFieldList = (List)JsonUtil.fromJson((String)((String)configmap.get("fields").getValue()), (TypeReference)new TypeReference<List<Metrics.Field>>(){});
        metrics.setFields(pushFieldList);
    }

    public static byte[] fromHexString(String hexString) {
        if (StringUtils.isEmpty((CharSequence)hexString)) {
            return null;
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            String hex = hexString.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(hex, 16);
        }
        return bytes;
    }

    public static String stringEncodeUtf7String(String original, String charset) {
        return new String(original.getBytes(new CharsetProvider().charsetForName(charset)), StandardCharsets.US_ASCII);
    }

    public static String utf7StringDecodeString(String encoded, String charset) {
        return new String(encoded.getBytes(StandardCharsets.US_ASCII), new CharsetProvider().charsetForName(charset));
    }

    public static final class DoubleAndUnit {
        private Double value;
        private String unit;

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}

