/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ParameterValidationResult {
    private final MethodParameter methodParameter;
    @Nullable
    private final Object argument;
    private final List<MessageSourceResolvable> resolvableErrors;
    @Nullable
    private final Object container;
    @Nullable
    private final Integer containerIndex;
    @Nullable
    private final Object containerKey;
    private final BiFunction<MessageSourceResolvable, Class<?>, Object> sourceLookup;

    public ParameterValidationResult(MethodParameter param, @Nullable Object arg, Collection<? extends MessageSourceResolvable> errors, @Nullable Object container, @Nullable Integer index, @Nullable Object key, BiFunction<MessageSourceResolvable, Class<?>, Object> sourceLookup) {
        Assert.notNull((Object)param, (String)"MethodParameter is required");
        Assert.notEmpty(errors, (String)"`resolvableErrors` must not be empty");
        this.methodParameter = param;
        this.argument = arg;
        this.resolvableErrors = List.copyOf(errors);
        this.container = container;
        this.containerIndex = index;
        this.containerKey = key;
        this.sourceLookup = sourceLookup;
    }

    @Deprecated(since="6.2", forRemoval=true)
    public ParameterValidationResult(MethodParameter param, @Nullable Object arg, Collection<? extends MessageSourceResolvable> errors, @Nullable Object container, @Nullable Integer index, @Nullable Object key) {
        this(param, arg, errors, container, index, key, (error, sourceType) -> {
            throw new IllegalArgumentException("No source object of the given type");
        });
    }

    @Deprecated(since="6.1.3", forRemoval=true)
    public ParameterValidationResult(MethodParameter param, @Nullable Object arg, Collection<? extends MessageSourceResolvable> errors) {
        this(param, arg, errors, null, null, null, (error, sourceType) -> {
            throw new IllegalArgumentException("No source object of the given type");
        });
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    @Nullable
    public Object getArgument() {
        return this.argument;
    }

    public List<MessageSourceResolvable> getResolvableErrors() {
        return this.resolvableErrors;
    }

    @Nullable
    public Object getContainer() {
        return this.container;
    }

    @Nullable
    public Integer getContainerIndex() {
        return this.containerIndex;
    }

    @Nullable
    public Object getContainerKey() {
        return this.containerKey;
    }

    public <T> T unwrap(MessageSourceResolvable error, Class<T> sourceType) {
        return (T)this.sourceLookup.apply(error, sourceType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof ParameterValidationResult)) return false;
        ParameterValidationResult otherResult = (ParameterValidationResult)other;
        if (!this.getMethodParameter().equals((Object)otherResult.getMethodParameter())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getArgument(), (Object)otherResult.getArgument())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getContainerIndex(), (Object)otherResult.getContainerIndex())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getContainerKey(), (Object)otherResult.getContainerKey())) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + this.getMethodParameter().hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getArgument());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getContainerIndex());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getContainerKey());
        return hashCode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.methodParameter + ", argument value '" + ObjectUtils.nullSafeConciseToString((Object)this.argument) + "'," + (String)(this.containerIndex != null ? "containerIndex[" + this.containerIndex + "]," : "") + (String)(this.containerKey != null ? "containerKey['" + this.containerKey + "']," : "") + " errors: " + this.getResolvableErrors();
    }
}

