/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.TimerTask;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTimeoutTask
extends TimerTask {
    private static Logger LOG = LoggerFactory.getLogger(MessageTimeoutTask.class);
    final HelixTaskExecutor _executor;
    final MessageTask _task;

    public MessageTimeoutTask(HelixTaskExecutor executor, MessageTask task) {
        this._executor = executor;
        this._task = task;
    }

    @Override
    public void run() {
        Message message = this._task.getMessage();
        LOG.warn("Message time out, canceling. id:" + message.getMsgId() + " timeout : " + message.getExecutionTimeout());
        this._task.onTimeout();
        this._executor.cancelTask(this._task);
    }
}

