/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.client;

import javax.net.ssl.HostnameVerifier;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.helix.rest.client.CustomRestClientImpl;
import org.apache.helix.rest.server.HelixRestServer;
import org.apache.helix.util.HelixUtil;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRestClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRestClientFactory.class);
    private static CustomRestClient INSTANCE = null;
    private static final int HTTP_REQUEST_TIMEOUT = HelixUtil.getSystemPropertyAsInt((String)"rest.http.timeout.ms", (int)60000);

    private CustomRestClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomRestClient get() {
        if (INSTANCE != null) return INSTANCE;
        Class<CustomRestClientFactory> clazz = CustomRestClientFactory.class;
        synchronized (CustomRestClientFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            try {
                RequestConfig config = RequestConfig.custom().setConnectTimeout(HTTP_REQUEST_TIMEOUT).setConnectionRequestTimeout(HTTP_REQUEST_TIMEOUT).setSocketTimeout(HTTP_REQUEST_TIMEOUT).build();
                CloseableHttpClient httpClient = HelixRestServer.REST_SERVER_SSL_CONTEXT != null ? HttpClients.custom().setSSLContext(HelixRestServer.REST_SERVER_SSL_CONTEXT).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(HelixRestServer.REST_SERVER_SSL_CONTEXT, (HostnameVerifier)new NoopHostnameVerifier())).setDefaultRequestConfig(config).build() : HttpClientBuilder.create().setDefaultRequestConfig(config).build();
                INSTANCE = new CustomRestClientImpl((HttpClient)httpClient);
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            catch (Exception e) {
                LOG.error("Exception when initializing CustomRestClient", (Throwable)e);
            }
            return INSTANCE;
        }
    }
}

