/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableDescriptorWithRSGroup
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorWithRSGroup.class);
    private final byte[] familyNameBytes = Bytes.toBytes((String)"f1");

    @BeforeClass
    public static void setUp() throws Exception {
        TestTableDescriptorWithRSGroup.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestTableDescriptorWithRSGroup.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testCreateTableInTableDescriptorSpecificRSGroup() throws Exception {
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        Assert.assertEquals((long)0L, (long)newGroup.getTables().size());
        this.createTableWithRSGroupDetail(newGroup.getName());
        try {
            TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"))).setRegionServerGroup("nonExistingRSGroup").setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
            admin.createTable(desc, this.getSpitKeys(6));
            Assert.fail((String)"Should have thrown ConstraintException but no exception thrown.");
        }
        catch (ConstraintException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Region server group nonExistingRSGroup does not exist.");
        }
    }

    private void createTableWithRSGroupDetail(String newGroup) throws Exception {
        ColumnFamilyDescriptor f1 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.familyNameBytes).build();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setRegionServerGroup(newGroup).setColumnFamily(f1).build();
        admin.createTable(desc, this.getSpitKeys(5));
        TEST_UTIL.waitFor(60000L, () -> {
            List<String> regions = this.getTableRegionMap().get(this.tableName);
            if (regions == null) {
                return false;
            }
            return this.getTableRegionMap().get(this.tableName).size() >= 5;
        });
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table is created.", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)newGroup, regionServerGroup.get());
    }

    @Test
    public void testMoveTablesShouldUpdateTableDescriptor() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTableWithRSGroupDetail(rsGroup1.getName());
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table created", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)rsGroup1.getName(), regionServerGroup.get());
        RSGroupInfo rsGroup2 = this.addGroup("rsGroup2", 1);
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), rsGroup2.getName());
        descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table moved", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)rsGroup2.getName(), regionServerGroup.get());
    }

    @Test
    public void testMoveServersAndTablesShouldUpdateTableDescriptor() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 2);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTableWithRSGroupDetail(rsGroup1.getName());
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table created", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)rsGroup1.getName(), regionServerGroup.get());
        rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{(Address)rsGroup1.getServers().iterator().next()}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "default");
        descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table moved", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)"default", regionServerGroup.get());
    }

    @Test
    public void testRenameRSGroupUpdatesTableDescriptor() throws Exception {
        RSGroupInfo oldGroup = this.addGroup("oldGroup", 1);
        Assert.assertEquals((long)0L, (long)oldGroup.getTables().size());
        this.createTableWithRSGroupDetail(oldGroup.getName());
        String newGroupName = "newGroup";
        rsGroupAdmin.renameRSGroup(oldGroup.getName(), "newGroup");
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when rs group renamed", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)"newGroup", regionServerGroup.get());
    }

    @Test
    public void testCloneSnapshotWithRSGroup() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTableWithRSGroupDetail(rsGroup1.getName());
        String snapshotName = "snapShot2";
        admin.snapshot("snapShot2", this.tableName);
        List snapshotDescriptions = admin.listSnapshots(Pattern.compile("snapShot2"));
        Assert.assertEquals((long)1L, (long)snapshotDescriptions.size());
        Assert.assertEquals((Object)"snapShot2", (Object)((SnapshotDescription)snapshotDescriptions.get(0)).getName());
        RSGroupInfo rsGroup2 = this.addGroup("rsGroup2", 1);
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), rsGroup2.getName());
        rsGroup2 = rsGroupAdmin.getRSGroupInfo(rsGroup2.getName());
        Assert.assertEquals((long)1L, (long)rsGroup2.getTables().size());
        Assert.assertEquals(rsGroup2.getTables().first(), (Object)this.tableName);
        TableName clonedTable1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_1"));
        admin.cloneSnapshot(Bytes.toBytes((String)"snapShot2"), clonedTable1);
        RSGroupInfo rsGroupInfoOfTable = rsGroupAdmin.getRSGroupInfoOfTable(clonedTable1);
        Assert.assertEquals((Object)rsGroup1.getName(), (Object)rsGroupInfoOfTable.getName());
        TableDescriptor descriptor = admin.getConnection().getTable(clonedTable1).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table is cloned.", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)rsGroup1.getName(), regionServerGroup.get());
        rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Iterable)rsGroup1.getServers()), (Set)Sets.newHashSet((Object[])new TableName[]{clonedTable1}), rsGroup2.getName());
        rsGroupAdmin.removeRSGroup(rsGroup1.getName());
        TableName clonedTable2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        try {
            admin.cloneSnapshot(Bytes.toBytes((String)"snapShot2"), clonedTable2);
            Assert.fail((String)"Should have thrown ConstraintException but no exception thrown.");
        }
        catch (ConstraintException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Region server group rsGroup1 does not exist."));
        }
    }

    @Test
    public void testMoveTablesWhenModifyTableWithNewRSGroup() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTableWithRSGroupDetail(rsGroup1.getName());
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        Optional regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table created", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)rsGroup1.getName(), regionServerGroup.get());
        TableDescriptor newTableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor).setRegionServerGroup("rsGroup2").build();
        try {
            admin.modifyTable(newTableDescriptor);
            Assert.fail((String)"Should have thrown ConstraintException but no exception thrown.");
        }
        catch (ConstraintException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Region server group rsGroup2 does not exist."));
        }
        this.addGroup("rsGroup2", 1);
        admin.modifyTable(newTableDescriptor);
        rsGroup1 = rsGroupAdmin.getRSGroupInfo("rsGroup1");
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        RSGroupInfo rsGroup2 = rsGroupAdmin.getRSGroupInfo("rsGroup2");
        Assert.assertEquals((long)1L, (long)rsGroup2.getTables().size());
        descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        regionServerGroup = descriptor.getRegionServerGroup();
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table is modified.", (boolean)regionServerGroup.isPresent());
        Assert.assertEquals((Object)"rsGroup2", regionServerGroup.get());
    }

    @Test
    public void testTableShouldNotAddedIntoRSGroup_WhenModifyTableFails() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTableWithRSGroupDetail(rsGroup1.getName());
        TableDescriptor descriptor = admin.getConnection().getTable(this.tableName).getDescriptor();
        RSGroupInfo rsGroup2 = this.addGroup("rsGroup2", 1);
        TableDescriptor newTableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor).setRegionServerGroup(rsGroup2.getName()).removeColumnFamily(this.familyNameBytes).build();
        try {
            admin.modifyTable(newTableDescriptor);
            Assert.fail((String)"Should have thrown DoNotRetryIOException but no exception thrown.");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Table should have at least one column family"));
        }
        rsGroup2 = rsGroupAdmin.getRSGroupInfo(rsGroup2.getName());
        Assert.assertEquals((String)"Table must not have moved to RSGroup as table modify failed", (long)0L, (long)rsGroup2.getTables().size());
    }

    @Test
    public void testTableShouldNotAddedIntoRSGroup_WhenTableCreationFails() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setRegionServerGroup(rsGroup1.getName()).build();
        try {
            admin.createTable(desc, this.getSpitKeys(5));
            Assert.fail((String)"Should have thrown DoNotRetryIOException but no exception thrown.");
        }
        catch (DoNotRetryIOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Table should have at least one column family"));
        }
        rsGroup1 = rsGroupAdmin.getRSGroupInfo(rsGroup1.getName());
        Assert.assertEquals((String)"Table must not have moved to RSGroup as table create operation failed", (long)0L, (long)rsGroup1.getTables().size());
    }

    @Test
    public void testSystemTablesCanBeMovedToNewRSGroupByModifyingTable() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        TableName tableName = TableName.valueOf((String)"hbase:meta");
        TableDescriptor descriptor = admin.getConnection().getTable(tableName).getDescriptor();
        TableDescriptor newTableDescriptor = TableDescriptorBuilder.newBuilder((TableDescriptor)descriptor).setRegionServerGroup(rsGroup1.getName()).build();
        admin.modifyTable(newTableDescriptor);
        RSGroupInfo rsGroupInfoOfTable = rsGroupAdmin.getRSGroupInfoOfTable(tableName);
        Assert.assertEquals((Object)rsGroup1.getName(), (Object)rsGroupInfoOfTable.getName());
    }

    @Test
    public void testUpdateTableDescriptorOnlyIfRSGroupInfoWasStoredInTableDescriptor() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTable(this.tableName, rsGroup1.getName());
        TableName table2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        this.createTable(table2, null);
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), rsGroup1.getName());
        Assert.assertTrue((String)"RSGroup info is not updated into TableDescriptor when table created", (boolean)admin.getConnection().getTable(this.tableName).getDescriptor().getRegionServerGroup().isPresent());
        Assert.assertFalse((String)"Table descriptor should not have been updated as rs group info was not stored in table descriptor.", (boolean)admin.getConnection().getTable(table2).getDescriptor().getRegionServerGroup().isPresent());
        String rsGroup2 = "rsGroup2";
        rsGroupAdmin.renameRSGroup(rsGroup1.getName(), "rsGroup2");
        Assert.assertEquals((Object)"rsGroup2", admin.getConnection().getTable(this.tableName).getDescriptor().getRegionServerGroup().get());
        Assert.assertFalse((String)"Table descriptor should not have been updated as rs group info was not stored in table descriptor.", (boolean)admin.getConnection().getTable(table2).getDescriptor().getRegionServerGroup().isPresent());
    }

    @Test
    public void testModifyAndMoveTableScenario() throws Exception {
        RSGroupInfo rsGroup1 = this.addGroup("rsGroup1", 1);
        Assert.assertEquals((long)0L, (long)rsGroup1.getTables().size());
        this.createTable(this.tableName, rsGroup1.getName());
        TableName table2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "_2"));
        this.createTable(table2, null);
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{table2}), rsGroup1.getName());
        RSGroupInfo rsGroup2 = this.addGroup("rsGroup2", 1);
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName, table2}), rsGroup2.getName());
        rsGroup2 = rsGroupAdmin.getRSGroupInfo(rsGroup2.getName());
        Assert.assertEquals((String)"Table movement failed.", (long)2L, (long)rsGroup2.getTables().size());
    }

    private void createTable(TableName tName, String rsGroupName) throws Exception {
        ColumnFamilyDescriptor f1 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.familyNameBytes).build();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tName).setColumnFamily(f1);
        if (rsGroupName != null) {
            builder.setRegionServerGroup(rsGroupName);
        }
        TableDescriptor desc = builder.build();
        admin.createTable(desc, this.getSpitKeys(10));
        TEST_UTIL.waitFor(60000L, () -> {
            List<String> regions = this.getTableRegionMap().get(tName);
            if (regions == null) {
                return false;
            }
            return this.getTableRegionMap().get(tName).size() >= 5;
        });
    }

    private byte[][] getSpitKeys(int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        return Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
    }
}

