/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.conf.ConfigKey;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReopenTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ReopenTableRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(ReopenTableRegionsProcedure.class);
    public static final String PROGRESSIVE_BATCH_BACKOFF_MILLIS_KEY = ConfigKey.LONG("hbase.reopen.table.regions.progressive.batch.backoff.ms", new Predicate[0]);
    public static final long PROGRESSIVE_BATCH_BACKOFF_MILLIS_DEFAULT = 0L;
    public static final String PROGRESSIVE_BATCH_SIZE_MAX_KEY = ConfigKey.INT("hbase.reopen.table.regions.progressive.batch.size.max", new Predicate[0]);
    public static final int PROGRESSIVE_BATCH_SIZE_MAX_DISABLED = -1;
    private static final int MINIMUM_BATCH_SIZE_MAX = 1;
    private TableName tableName;
    private List<byte[]> regionNames;
    private List<HRegionLocation> regions = Collections.emptyList();
    private List<HRegionLocation> currentRegionBatch = Collections.emptyList();
    private RetryCounter retryCounter;
    private long reopenBatchBackoffMillis;
    private int reopenBatchSize;
    private int reopenBatchSizeMax;
    private long regionsReopened = 0L;
    private long batchesProcessed = 0L;

    public static ReopenTableRegionsProcedure throttled(Configuration conf, TableDescriptor desc) {
        long backoffMillis = Optional.ofNullable(desc.getValue(PROGRESSIVE_BATCH_BACKOFF_MILLIS_KEY)).map(Long::parseLong).orElseGet(() -> conf.getLong(PROGRESSIVE_BATCH_BACKOFF_MILLIS_KEY, 0L));
        int batchSizeMax = Optional.ofNullable(desc.getValue(PROGRESSIVE_BATCH_SIZE_MAX_KEY)).map(Integer::parseInt).orElseGet(() -> conf.getInt(PROGRESSIVE_BATCH_SIZE_MAX_KEY, -1));
        return new ReopenTableRegionsProcedure(desc.getTableName(), backoffMillis, batchSizeMax);
    }

    public ReopenTableRegionsProcedure() {
        this((TableName)null);
    }

    public ReopenTableRegionsProcedure(TableName tableName) {
        this(tableName, Collections.emptyList());
    }

    public ReopenTableRegionsProcedure(TableName tableName, List<byte[]> regionNames) {
        this(tableName, regionNames, 0L, -1);
    }

    ReopenTableRegionsProcedure(TableName tableName, long reopenBatchBackoffMillis, int reopenBatchSizeMax) {
        this(tableName, Collections.emptyList(), reopenBatchBackoffMillis, reopenBatchSizeMax);
    }

    private ReopenTableRegionsProcedure(TableName tableName, List<byte[]> regionNames, long reopenBatchBackoffMillis, int reopenBatchSizeMax) {
        this.tableName = tableName;
        this.regionNames = regionNames;
        this.reopenBatchBackoffMillis = reopenBatchBackoffMillis;
        if (reopenBatchSizeMax == -1) {
            this.reopenBatchSize = Integer.MAX_VALUE;
            this.reopenBatchSizeMax = Integer.MAX_VALUE;
        } else {
            this.reopenBatchSize = 1;
            this.reopenBatchSizeMax = Math.max(reopenBatchSizeMax, 1);
        }
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public long getRegionsReopened() {
        return this.regionsReopened;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public long getBatchesProcessed() {
        return this.batchesProcessed;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    long getReopenBatchBackoffMillis() {
        return this.reopenBatchBackoffMillis;
    }

    @RestrictedApi(explanation="Should only be called internally or in tests", link="", allowedOnPath=".*(/src/test/.*|ReopenTableRegionsProcedure).java")
    protected int progressBatchSize() {
        int previousBatchSize = this.reopenBatchSize;
        this.reopenBatchSize = Math.min(this.reopenBatchSizeMax, 2 * this.reopenBatchSize);
        if (this.reopenBatchSize < previousBatchSize) {
            this.reopenBatchSize = this.reopenBatchSizeMax;
        }
        return this.reopenBatchSize;
    }

    private boolean canSchedule(MasterProcedureEnv env, HRegionLocation loc) {
        if (loc.getSeqNum() < 0L) {
            return false;
        }
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(loc.getRegion());
        return regionNode == null || !regionNode.isInTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case REOPEN_TABLE_REGIONS_GET_REGIONS: {
                if (!this.isTableEnabled(env)) {
                    LOG.info("Table {} is disabled, give up reopening its regions", (Object)this.tableName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                List<HRegionLocation> tableRegions = env.getAssignmentManager().getRegionStates().getRegionsOfTableForReopen(this.tableName);
                this.regions = this.getRegionLocationsForReopen(tableRegions);
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_REOPEN_REGIONS: {
                if (!this.regions.isEmpty() && this.currentRegionBatch.isEmpty()) {
                    this.currentRegionBatch = this.regions.stream().limit(this.reopenBatchSize).collect(Collectors.toList());
                    ++this.batchesProcessed;
                }
                for (HRegionLocation loc : this.currentRegionBatch) {
                    TransitRegionStateProcedure proc;
                    RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(loc.getRegion());
                    if (regionNode == null) continue;
                    regionNode.lock();
                    try {
                        if (regionNode.getProcedure() != null) continue;
                        proc = TransitRegionStateProcedure.reopen(env, regionNode.getRegionInfo());
                        regionNode.setProcedure(proc);
                    }
                    finally {
                        regionNode.unlock();
                        continue;
                    }
                    this.addChildProcedure(new TransitRegionStateProcedure[]{proc});
                    ++this.regionsReopened;
                }
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_CONFIRM_REOPENED);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_CONFIRM_REOPENED: {
                this.regions = this.filterReopened(env, this.regions);
                this.currentRegionBatch = this.filterReopened(env, this.currentRegionBatch);
                if (!this.currentRegionBatch.isEmpty()) {
                    return this.reopenIfSchedulable(env, this.currentRegionBatch, false);
                }
                if (this.regions.isEmpty()) {
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                return this.reopenIfSchedulable(env, this.regions, true);
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    private List<HRegionLocation> filterReopened(MasterProcedureEnv env, List<HRegionLocation> regionsToCheck) {
        return regionsToCheck.stream().map(env.getAssignmentManager().getRegionStates()::checkReopened).filter(l -> l != null).collect(Collectors.toList());
    }

    private StateMachineProcedure.Flow reopenIfSchedulable(MasterProcedureEnv env, List<HRegionLocation> regionsToReopen, boolean shouldBatchBackoff) throws ProcedureSuspendedException {
        if (regionsToReopen.stream().anyMatch(loc -> this.canSchedule(env, (HRegionLocation)loc))) {
            this.retryCounter = null;
            this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
            if (shouldBatchBackoff) {
                this.progressBatchSize();
            }
            if (shouldBatchBackoff && this.reopenBatchBackoffMillis > 0L) {
                this.setBackoffState(this.reopenBatchBackoffMillis);
                throw new ProcedureSuspendedException();
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
        }
        long backoffMillis = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        LOG.info("There are still {} region(s) which need to be reopened for table {}. {} are in OPENING state, suspend {}secs and try again later", new Object[]{this.regions.size(), this.tableName, this.currentRegionBatch.size(), backoffMillis / 1000L});
        this.setBackoffState(backoffMillis);
        throw new ProcedureSuspendedException();
    }

    private void setBackoffState(long millis) {
        this.setTimeout(Math.toIntExact(millis));
        this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.skipPersistence();
    }

    private List<HRegionLocation> getRegionLocationsForReopen(List<HRegionLocation> tableRegionsForReopen) {
        ArrayList<HRegionLocation> regionsToReopen = new ArrayList();
        if (CollectionUtils.isNotEmpty(this.regionNames) && CollectionUtils.isNotEmpty(tableRegionsForReopen)) {
            block0: for (byte[] regionName : this.regionNames) {
                for (HRegionLocation hRegionLocation : tableRegionsForReopen) {
                    if (!Bytes.equals(regionName, hRegionLocation.getRegion().getRegionName())) continue;
                    regionsToReopen.add(hRegionLocation);
                    continue block0;
                }
            }
        } else {
            regionsToReopen = tableRegionsForReopen;
        }
        return regionsToReopen;
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected MasterProcedureProtos.ReopenTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.ReopenTableRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ReopenTableRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ReopenTableRegionsState getInitialState() {
        return MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_GET_REGIONS;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData.Builder builder = MasterProcedureProtos.ReopenTableRegionsStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName(this.tableName));
        this.regions.stream().map(ProtobufUtil::toRegionLocation).forEachOrdered(builder::addRegion);
        if (CollectionUtils.isNotEmpty(this.regionNames)) {
            this.regionNames.stream().map(ByteString::copyFrom).forEachOrdered(builder::addRegionNames);
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData data = serializer.deserialize(MasterProcedureProtos.ReopenTableRegionsStateData.class);
        this.tableName = ProtobufUtil.toTableName(data.getTableName());
        this.regions = data.getRegionList().stream().map(ProtobufUtil::toRegionLocation).collect(Collectors.toList());
        this.regionNames = CollectionUtils.isNotEmpty(data.getRegionNamesList()) ? data.getRegionNamesList().stream().map(ByteString::toByteArray).collect(Collectors.toList()) : Collections.emptyList();
    }
}

