/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterIdFetcher;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.IOExceptionSupplier;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class ConnectionRegistryRpcStubHolder
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionRegistryRpcStubHolder.class);
    private final Configuration conf;
    private final Configuration noAuthConf;
    private final User user;
    private final RpcControllerFactory rpcControllerFactory;
    private final Set<ServerName> bootstrapNodes;
    private final int rpcTimeoutMs;
    private volatile ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> addr2Stub;
    private volatile RpcClient rpcClient;
    private CompletableFuture<ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface>> addr2StubFuture;

    ConnectionRegistryRpcStubHolder(Configuration conf, User user, RpcControllerFactory rpcControllerFactory, Set<ServerName> bootstrapNodes) {
        this.conf = conf;
        if (User.isHBaseSecurityEnabled(conf)) {
            this.noAuthConf = new Configuration(conf);
            this.noAuthConf.set("hbase.security.authentication", "simple");
        } else {
            this.noAuthConf = conf;
        }
        this.user = user;
        this.rpcControllerFactory = rpcControllerFactory;
        this.bootstrapNodes = Collections.unmodifiableSet(bootstrapNodes);
        this.rpcTimeoutMs = (int)Math.min(Integer.MAX_VALUE, conf.getLong("hbase.rpc.timeout", 60000L));
    }

    private ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> createStubs(RpcClient rpcClient, Collection<ServerName> addrs) {
        LOG.debug("Going to use new servers to create stubs: {}", addrs);
        Preconditions.checkNotNull(addrs);
        ImmutableMap.Builder<ServerName, RegistryProtos.ClientMetaService.Stub> builder = ImmutableMap.builderWithExpectedSize(addrs.size());
        for (ServerName masterAddr : addrs) {
            builder.put(masterAddr, RegistryProtos.ClientMetaService.newStub(rpcClient.createRpcChannel(masterAddr, this.user, this.rpcTimeoutMs)));
        }
        return builder.build();
    }

    private CompletableFuture<ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface>> fetchClusterIdAndCreateStubs() {
        CompletableFuture<ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface>> future = new CompletableFuture<ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface>>();
        this.addr2StubFuture = future;
        FutureUtils.addListener(new ClusterIdFetcher(this.noAuthConf, this.user, this.rpcControllerFactory, this.bootstrapNodes).fetchClusterId(), (clusterId, error) -> {
            ConnectionRegistryRpcStubHolder connectionRegistryRpcStubHolder = this;
            synchronized (connectionRegistryRpcStubHolder) {
                if (error != null) {
                    this.addr2StubFuture.completeExceptionally((Throwable)error);
                } else {
                    RpcClient c = RpcClientFactory.createClient(this.conf, clusterId);
                    ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> m3 = this.createStubs(c, this.bootstrapNodes);
                    this.rpcClient = c;
                    this.addr2Stub = m3;
                    this.addr2StubFuture.complete(m3);
                }
                this.addr2StubFuture = null;
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface>> getStubs() {
        ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> s2 = this.addr2Stub;
        if (s2 != null) {
            return CompletableFuture.completedFuture(s2);
        }
        ConnectionRegistryRpcStubHolder connectionRegistryRpcStubHolder = this;
        synchronized (connectionRegistryRpcStubHolder) {
            s2 = this.addr2Stub;
            if (s2 != null) {
                return CompletableFuture.completedFuture(s2);
            }
            if (this.addr2StubFuture != null) {
                return this.addr2StubFuture;
            }
            return this.fetchClusterIdAndCreateStubs();
        }
    }

    void refreshStubs(IOExceptionSupplier<Collection<ServerName>> fetchEndpoints) throws IOException {
        if (this.addr2Stub == null) {
            LOG.debug("Skip refreshing stubs as we have not initialized rpc client yet");
            return;
        }
        LOG.debug("Going to refresh stubs");
        assert (this.rpcClient != null);
        this.addr2Stub = this.createStubs(this.rpcClient, fetchEndpoints.get());
    }

    @Override
    public void close() {
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
    }
}

