/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerBase;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultStoreFileTracker
extends StoreFileTrackerBase {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreFileTracker.class);

    public DefaultStoreFileTracker(Configuration conf, boolean isPrimaryReplica, StoreContext ctx) {
        super(conf, isPrimaryReplica, ctx);
    }

    @Override
    public boolean requireWritingToTmpDirFirst() {
        return true;
    }

    @Override
    protected void doAddNewStoreFiles(Collection<StoreFileInfo> newFiles) throws IOException {
    }

    @Override
    protected void doAddCompactionResults(Collection<StoreFileInfo> compactedFiles, Collection<StoreFileInfo> newFiles) throws IOException {
    }

    @Override
    protected List<StoreFileInfo> doLoadStoreFiles(boolean readOnly) throws IOException {
        List<StoreFileInfo> files = this.getStoreFiles(this.ctx.getFamily().getNameAsString());
        return files != null ? files : Collections.emptyList();
    }

    @Override
    protected void doSetStoreFiles(Collection<StoreFileInfo> files) throws IOException {
    }

    public List<StoreFileInfo> getStoreFiles(String familyName) throws IOException {
        Path familyDir = this.ctx.getRegionFileSystem().getStoreDir(familyName);
        FileStatus[] files = CommonFSUtils.listStatus((FileSystem)this.ctx.getRegionFileSystem().getFileSystem(), (Path)familyDir);
        if (files == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No StoreFiles for: " + familyDir);
            }
            return null;
        }
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(files.length);
        for (FileStatus status : files) {
            if (!StoreFileInfo.isValid(status)) {
                if ("recovered.hfiles".equals(status.getPath().getName())) continue;
                LOG.warn("Invalid StoreFile: {}", (Object)status.getPath());
                continue;
            }
            StoreFileInfo info = ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.ctx.getRegionFileSystem().getFileSystem(), this.ctx.getRegionInfo(), this.ctx.getRegionFileSystem().getRegionInfoForFS(), familyName, status.getPath(), this);
            storeFiles.add(info);
        }
        return storeFiles;
    }
}

