/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class Chunk {
    protected ByteBuffer data;
    protected static final int UNINITIALIZED = -1;
    protected static final int OOM = -2;
    protected AtomicInteger nextFreeOffset = new AtomicInteger(-1);
    protected AtomicInteger allocCount = new AtomicInteger();
    protected final int size;
    private final int id;
    private final ChunkCreator.ChunkType chunkType;
    private final boolean fromPool;

    public Chunk(int size, int id, ChunkCreator.ChunkType chunkType) {
        this(size, id, chunkType, false);
    }

    public Chunk(int size, int id, ChunkCreator.ChunkType chunkType, boolean fromPool) {
        this.size = size;
        this.id = id;
        this.chunkType = chunkType;
        this.fromPool = fromPool;
    }

    int getId() {
        return this.id;
    }

    ChunkCreator.ChunkType getChunkType() {
        return this.chunkType;
    }

    boolean isFromPool() {
        return this.fromPool;
    }

    boolean isJumbo() {
        return this.chunkType == ChunkCreator.ChunkType.JUMBO_CHUNK;
    }

    boolean isIndexChunk() {
        return this.chunkType == ChunkCreator.ChunkType.INDEX_CHUNK;
    }

    boolean isDataChunk() {
        return this.chunkType == ChunkCreator.ChunkType.DATA_CHUNK;
    }

    public void init() {
        assert (this.nextFreeOffset.get() == -1);
        try {
            this.allocateDataBuffer();
        }
        catch (OutOfMemoryError e) {
            boolean failInit = this.nextFreeOffset.compareAndSet(-1, -2);
            assert (failInit);
            throw e;
        }
        boolean initted = this.nextFreeOffset.compareAndSet(-1, 4);
        Preconditions.checkState((boolean)initted, (Object)"Multiple threads tried to init same chunk");
    }

    abstract void allocateDataBuffer();

    void reset() {
        if (this.nextFreeOffset.get() != -1) {
            this.nextFreeOffset.set(-1);
            this.allocCount.set(0);
        }
    }

    public int alloc(int size) {
        int oldOffset;
        while (true) {
            if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                Thread.yield();
                continue;
            }
            if (oldOffset == -2) {
                return -1;
            }
            if (oldOffset + size > this.data.capacity()) {
                return -1;
            }
            if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
        }
        this.allocCount.incrementAndGet();
        return oldOffset;
    }

    ByteBuffer getData() {
        return this.data;
    }

    public String toString() {
        return "Chunk@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.capacity() - this.nextFreeOffset.get());
    }

    int getNextFreeOffset() {
        return this.nextFreeOffset.get();
    }
}

