/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hadoop.hbase.quotas.QuotaLimiterFactory;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="FindBugs seems confused; says globalLimiter and lastUpdate are mostly synchronized...but to me it looks like they are totally synchronized")
public class QuotaState {
    protected QuotaLimiter globalLimiter = NoopQuotaLimiter.get();

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QuotaState(");
        if (this.isBypass()) {
            builder.append("bypass");
        } else if (this.globalLimiter != NoopQuotaLimiter.get()) {
            builder.append(" " + this.globalLimiter);
        }
        builder.append(')');
        return builder.toString();
    }

    public synchronized boolean isBypass() {
        return this.globalLimiter == NoopQuotaLimiter.get();
    }

    public synchronized void setQuotas(Configuration conf, QuotaProtos.Quotas quotas) {
        this.globalLimiter = quotas.hasThrottle() ? QuotaLimiterFactory.fromThrottle(conf, quotas.getThrottle()) : NoopQuotaLimiter.get();
    }

    void setGlobalLimiter(QuotaLimiter globalLimiter) {
        this.globalLimiter = globalLimiter;
    }

    public synchronized void update(QuotaState other) {
        this.globalLimiter = this.globalLimiter == NoopQuotaLimiter.get() ? other.globalLimiter : (other.globalLimiter == NoopQuotaLimiter.get() ? NoopQuotaLimiter.get() : QuotaLimiterFactory.update(this.globalLimiter, other.globalLimiter));
    }

    public synchronized QuotaLimiter getGlobalLimiter() {
        return this.globalLimiter;
    }
}

