/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, LargeTests.class})
public class TestLoadIncrementalHFiles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadIncrementalHFiles.class);
    @Rule
    public TestName tn = new TestName();
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"myqual");
    private static final byte[] FAMILY = Bytes.toBytes((String)"myfam");
    private static final String NAMESPACE = "bulkNS";
    static final String EXPECTED_MSG_FOR_NON_EXISTING_FAMILY = "Unmatched family names found";
    static final int MAX_FILES_PER_REGION_PER_FAMILY = 4;
    private static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ppp")};
    static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        TestLoadIncrementalHFiles.setupNamespace();
    }

    protected static void setupNamespace() throws Exception {
        util.getAdmin().createNamespace(NamespaceDescriptor.create((String)NAMESPACE).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSimpleLoadWithMap() throws Exception {
        this.runTest("testSimpleLoadWithMap", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}}, true);
    }

    @Test
    public void testSimpleLoad() throws Exception {
        this.runTest("testSimpleLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}});
    }

    @Test
    public void testSimpleLoadWithFileCopy() throws Exception {
        String testName = this.tn.getMethodName();
        byte[] TABLE_NAME = Bytes.toBytes((String)("mytable_" + testName));
        this.runTest(testName, this.buildHTD(TableName.valueOf((byte[])TABLE_NAME), BloomType.NONE), false, null, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}}, false, true, 2);
    }

    @Test
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowBloom", BloomType.ROW, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowColBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowColBloom", BloomType.ROWCOL, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testSimpleHFileSplit() throws Exception {
        this.runTest("testHFileSplit", BloomType.NONE, new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"lll")}, new byte[][]{Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingHFileSplit() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.NONE);
    }

    @Test
    public void testRegionCrossingHFileSplitRowBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROW);
    }

    @Test
    public void testRegionCrossingHFileSplitRowColBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROWCOL);
    }

    @Test
    public void testSplitALot() throws Exception {
        this.runTest("testSplitALot", BloomType.NONE, new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"zzz")}});
    }

    private void testRegionCrossingHFileSplit(BloomType bloomType) throws Exception {
        this.runTest("testHFileSplit" + bloomType + "Bloom", bloomType, new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    private TableDescriptor buildHTD(TableName tableName, BloomType bloomType) {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setBloomFilterType(bloomType).build()).build();
    }

    private void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges) throws Exception {
        this.runTest(testName, bloomType, (byte[][])null, hfileRanges);
    }

    private void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges, boolean useMap) throws Exception {
        this.runTest(testName, bloomType, null, hfileRanges, useMap);
    }

    private void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges) throws Exception {
        this.runTest(testName, bloomType, tableSplitKeys, hfileRanges, false);
    }

    private void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap) throws Exception {
        byte[] TABLE_NAME = Bytes.toBytes((String)("mytable_" + testName));
        boolean preCreateTable = tableSplitKeys != null;
        TableName TABLE_WITHOUT_NS = TableName.valueOf((byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITHOUT_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, useMap, 2);
        if (preCreateTable) {
            this.runTest(testName + 2, TABLE_WITHOUT_NS, bloomType, true, tableSplitKeys, hfileRanges, false, 3);
        }
        TableName TABLE_WITH_NS = TableName.valueOf((byte[])Bytes.toBytes((String)NAMESPACE), (byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITH_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, useMap, 2);
    }

    private void runTest(String testName, TableName tableName, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, int depth) throws Exception {
        TableDescriptor htd = this.buildHTD(tableName, bloomType);
        this.runTest(testName, htd, preCreateTable, tableSplitKeys, hfileRanges, useMap, false, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadHFiles(String testName, TableDescriptor htd, HBaseTestingUtility util, byte[] fam, byte[] qual, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, boolean deleteFile, boolean copyFiles, int initRowCount, int factor, int depth) throws Exception {
        Path baseDirectory = util.getDataTestDirOnTestFS(testName);
        FileSystem fs = util.getTestFileSystem();
        Path parentDir = baseDirectory = baseDirectory.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        if (depth == 3) {
            assert (!useMap);
            parentDir = new Path(baseDirectory, "someRegion");
        }
        Path familyDir = new Path(parentDir, Bytes.toString((byte[])fam));
        int hfileIdx = 0;
        TreeMap<byte[], ArrayList<Path>> map = null;
        ArrayList<Path> list = null;
        if (useMap || copyFiles) {
            list = new ArrayList<Path>();
        }
        if (useMap) {
            map = new TreeMap<byte[], ArrayList<Path>>(Bytes.BYTES_COMPARATOR);
            map.put(fam, list);
        }
        Path last = null;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            Path path = new Path(familyDir, "hfile_" + hfileIdx++);
            HFileTestUtil.createHFile(util.getConfiguration(), fs, path, fam, qual, from, to, factor);
            if (!useMap) continue;
            last = path;
            list.add(path);
        }
        int expectedRows = hfileIdx * factor;
        TableName tableName = htd.getTableName();
        if (!util.getAdmin().tableExists(tableName) && (preCreateTable || map != null)) {
            util.getAdmin().createTable(htd, tableSplitKeys);
        }
        Configuration conf = util.getConfiguration();
        if (copyFiles) {
            conf.setBoolean("always.copy.files", true);
        }
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(conf);
        ArrayList args = Lists.newArrayList((Object[])new String[]{baseDirectory.toString(), tableName.toString()});
        if (depth == 3) {
            args.add("-loadTable");
        }
        if (useMap) {
            if (deleteFile) {
                fs.delete(last, true);
            }
            Map loaded = loader.bulkLoad(tableName, map);
            if (deleteFile) {
                expectedRows -= 1000;
                for (BulkLoadHFiles.LoadQueueItem item : loaded.keySet()) {
                    if (!item.getFilePath().getName().equals(last.getName())) continue;
                    Assert.fail((String)(last + " should be missing"));
                }
            }
        } else {
            loader.run(args.toArray(new String[0]));
        }
        if (copyFiles) {
            for (Path p : list) {
                Assert.assertTrue((String)(p + " should exist"), (boolean)fs.exists(p));
            }
        }
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)(initRowCount + expectedRows), (long)util.countRows(table));
        }
        return expectedRows;
    }

    private void runTest(String testName, TableDescriptor htd, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, boolean useMap, boolean copyFiles, int depth) throws Exception {
        TestLoadIncrementalHFiles.loadHFiles(testName, htd, util, FAMILY, QUALIFIER, preCreateTable, tableSplitKeys, hfileRanges, useMap, true, copyFiles, 0, 1000, depth);
        TableName tableName = htd.getTableName();
        Path stagingBasePath = new Path(CommonFSUtils.getRootDir((Configuration)util.getConfiguration()), "staging");
        FileSystem fs = util.getTestFileSystem();
        if (fs.exists(stagingBasePath)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(stagingBasePath)) {
                Assert.assertTrue((String)("Folder=" + file.getPath() + " is not cleaned up."), (file.getPath().getName() != "DONOTERASE" ? 1 : 0) != 0);
            }
        }
        util.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTagsSurviveBulkLoadSplit() throws Exception {
        Path dir = util.getDataTestDirOnTestFS(this.tn.getMethodName());
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        byte[][] tableSplitKeys = new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")};
        byte[] from = Bytes.toBytes((String)"ddd");
        byte[] to = Bytes.toBytes((String)"ooo");
        HFileTestUtil.createHFileWithTags(util.getConfiguration(), fs, new Path(familyDir, this.tn.getMethodName() + "_hfile"), FAMILY, QUALIFIER, from, to, 1000);
        int expectedRows = 1000;
        TableName tableName = TableName.valueOf((String)this.tn.getMethodName());
        TableDescriptor htd = this.buildHTD(tableName, BloomType.NONE);
        util.getAdmin().createTable(htd, (byte[][])tableSplitKeys);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), tableName.toString()};
        loader.run(args);
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
            HFileTestUtil.verifyTags(table);
        }
        util.deleteTable(tableName);
    }

    @Test
    public void testNonexistentColumnFamilyLoad() throws Exception {
        String testName = this.tn.getMethodName();
        byte[][][] hFileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}};
        byte[] TABLE = Bytes.toBytes((String)("mytable_" + testName));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])TABLE)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)new String(FAMILY).toUpperCase(Locale.ROOT)))).build();
        try {
            this.runTest(testName, htd, true, SPLIT_KEYS, hFileRanges, false, false, 2);
            Assert.assertTrue((String)"Loading into table with non-existent family should have failed", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
            String errMsg = e.getMessage();
            Assert.assertTrue((String)("Incorrect exception message, expected message: [Unmatched family names found], current message: [" + errMsg + "]"), (boolean)errMsg.contains(EXPECTED_MSG_FOR_NON_EXISTING_FAMILY));
        }
    }

    @Test
    public void testNonHfileFolderWithUnmatchedFamilyName() throws Exception {
        this.testNonHfileFolder("testNonHfileFolderWithUnmatchedFamilyName", true);
    }

    @Test
    public void testNonHfileFolder() throws Exception {
        this.testNonHfileFolder("testNonHfileFolder", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonHfileFolder(String tableName, boolean preCreateTable) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(tableName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_0"), FAMILY, QUALIFIER, Bytes.toBytes((String)"begin"), Bytes.toBytes((String)"end"), 500);
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(familyDir, "012356789"), 16384);
        String NON_FAMILY_FOLDER = "_logs";
        Path nonFamilyDir = new Path(dir, "_logs");
        fs.mkdirs(nonFamilyDir);
        fs.mkdirs(new Path(nonFamilyDir, "non-file"));
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(nonFamilyDir, "012356789"), 16384);
        Table table = null;
        try {
            table = preCreateTable ? util.createTable(TableName.valueOf((String)tableName), FAMILY) : util.getConnection().getTable(TableName.valueOf((String)tableName));
            String[] args = new String[]{dir.toString(), tableName};
            new LoadIncrementalHFiles(util.getConfiguration()).run(args);
            Assert.assertEquals((long)500L, (long)util.countRows(table));
        }
        finally {
            if (table != null) {
                table.close();
            }
            fs.delete(dir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createRandomDataFile(FileSystem fs, Path path, int size) throws IOException {
        try (FSDataOutputStream stream = fs.create(path);){
            byte[] data = new byte[1024];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(i & 0xFF);
            }
            while (size >= data.length) {
                stream.write(data, 0, data.length);
                size -= data.length;
            }
            if (size > 0) {
                stream.write(data, 0, size);
            }
        }
    }

    @Test
    public void testSplitStoreFile() throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFile");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        ColumnFamilyDescriptor familyDesc = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY);
        HFileTestUtil.createHFile(util.getConfiguration(), fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (ColumnFamilyDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    @Test
    public void testSplitStoreFileWithCreateTimeTS() throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitStoreFileWithCreateTimeTS");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        ColumnFamilyDescriptor familyDesc = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY);
        HFileTestUtil.createHFile(util.getConfiguration(), fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        BulkLoadHFilesTool.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (ColumnFamilyDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        this.verifyHFileCreateTimeTS(bottomOut);
        this.verifyHFileCreateTimeTS(topOut);
    }

    private void verifyHFileCreateTimeTS(Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        try (HFile.Reader reader = HFile.createReader((FileSystem)p.getFileSystem(conf), (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);){
            long fileCreateTime = reader.getHFileInfo().getHFileContext().getFileCreateTime();
            MatcherAssert.assertThat((Object)fileCreateTime, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    public void testSplitStoreFileWithNoneToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithEncodedToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.DIFF);
    }

    @Test
    public void testSplitStoreFileWithEncodedToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithNoneToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.DIFF);
    }

    private void testSplitStoreFileWithDifferentEncoding(DataBlockEncoding bulkloadEncoding, DataBlockEncoding cfEncoding) throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFileWithDifferentEncoding");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        ColumnFamilyDescriptor familyDesc = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setDataBlockEncoding(cfEncoding).build();
        HFileTestUtil.createHFileWithDataBlockEncoding(util.getConfiguration(), fs, testIn, bulkloadEncoding, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (ColumnFamilyDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    private int verifyHFile(Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)p.getFileSystem(conf), (Path)p, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        HFileScanner scanner = reader.getScanner(conf, false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        reader.close();
        return count;
    }

    private void addStartEndKeysForTest(TreeMap<byte[], Integer> map, byte[] first, byte[] last) {
        Integer value = map.containsKey(first) ? map.get(first) : Integer.valueOf(0);
        map.put(first, value + 1);
        value = map.containsKey(last) ? map.get(last) : Integer.valueOf(0);
        map.put(last, value - 1);
    }

    @Test
    public void testInferBoundaries() {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        String first = "a";
        String last = "e";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "r";
        last = "s";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "o";
        last = "p";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "g";
        last = "k";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "v";
        last = "x";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "c";
        last = "i";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "m";
        last = "q";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "s";
        last = "t";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "u";
        last = "w";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        byte[][] keysArray = LoadIncrementalHFiles.inferBoundaries(map);
        byte[][] compare = new byte[][]{"m".getBytes(), "r".getBytes(), "u".getBytes()};
        Assert.assertEquals((long)3L, (long)keysArray.length);
        for (int row = 0; row < keysArray.length; ++row) {
            Assert.assertArrayEquals((byte[])keysArray[row], (byte[])compare[row]);
        }
    }

    @Test
    public void testLoadTooMayHFiles() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("testLoadTooMayHFiles");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        byte[] from = Bytes.toBytes((String)"begin");
        byte[] to = Bytes.toBytes((String)"end");
        for (int i = 0; i <= 4; ++i) {
            HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + i), FAMILY, QUALIFIER, from, to, 1000);
        }
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), "mytable_testLoadTooMayHFiles"};
        try {
            loader.run(args);
            Assert.fail((String)"Bulk loading too many files should fail");
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)ie.getMessage().contains("Trying to load more than 4 hfiles"));
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testWithoutAnExistingTableAndCreateTableSetToNo() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.set("create.table", "no");
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{"directory", "nonExistingTable"};
        loader.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableWithCFNameStartWithUnderScore() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("cfNameStartWithUnderScore");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        String family = "_cf";
        Path familyDir = new Path(dir, family);
        byte[] from = Bytes.toBytes((String)"begin");
        byte[] to = Bytes.toBytes((String)"end");
        Configuration conf = util.getConfiguration();
        String tableName = this.tn.getMethodName();
        Table table = util.createTable(TableName.valueOf((String)tableName), family);
        HFileTestUtil.createHFile(conf, fs, new Path(familyDir, "hfile"), Bytes.toBytes((String)family), QUALIFIER, from, to, 1000);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{dir.toString(), tableName};
        try {
            loader.run(args);
            Assert.assertEquals((long)1000L, (long)util.countRows(table));
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkLoadByFamily() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("testBulkLoadByFamily");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        String tableName = this.tn.getMethodName();
        String[] families = new String[]{"cf1", "cf2", "cf3"};
        for (int i = 0; i < families.length; ++i) {
            byte[] from = Bytes.toBytes((String)(i + "begin"));
            byte[] to = Bytes.toBytes((String)(i + "end"));
            Path familyDir = new Path(dir, families[i]);
            HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile"), Bytes.toBytes((String)families[i]), QUALIFIER, from, to, 1000);
        }
        Table table = util.createTable(TableName.valueOf((String)tableName), families);
        final AtomicInteger attmptedCalls = new AtomicInteger();
        util.getConfiguration().setBoolean("hbase.mapreduce.bulkload.by.family", true);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration()){

            protected List<LoadIncrementalHFiles.LoadQueueItem> tryAtomicRegionLoad(Connection connection, TableName tableName, byte[] first, Collection<LoadIncrementalHFiles.LoadQueueItem> lqis, boolean copyFile) throws IOException {
                attmptedCalls.incrementAndGet();
                return super.tryAtomicRegionLoad(connection, tableName, first, lqis, copyFile);
            }
        };
        String[] args = new String[]{dir.toString(), tableName};
        try {
            loader.run(args);
            Assert.assertEquals((long)families.length, (long)attmptedCalls.get());
            Assert.assertEquals((long)(1000 * families.length), (long)util.countRows(table));
        }
        finally {
            if (null != table) {
                table.close();
            }
            util.getConfiguration().setBoolean("hbase.mapreduce.bulkload.by.family", false);
        }
    }

    @Test
    public void testFailIfNeedSplitHFile() throws IOException {
        TableName tableName = TableName.valueOf((String)this.tn.getMethodName());
        Table table = util.createTable(tableName, FAMILY);
        util.loadTable(table, FAMILY);
        FileSystem fs = util.getTestFileSystem();
        Path sfPath = new Path(fs.getWorkingDirectory(), new Path(Bytes.toString((byte[])FAMILY), "file"));
        HFileTestUtil.createHFile(util.getConfiguration(), fs, sfPath, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        util.getAdmin().split(tableName);
        util.waitFor(10000L, 1000L, () -> util.getAdmin().getRegions(tableName).size() > 1);
        Configuration config = new Configuration(util.getConfiguration());
        config.setBoolean("hbase.loadincremental.fail.if.need.split.hfile", true);
        BulkLoadHFilesTool tool = new BulkLoadHFilesTool(config);
        String[] args = new String[]{fs.getWorkingDirectory().toString(), tableName.toString()};
        Assert.assertThrows(IOException.class, () -> tool.run(args));
        util.getHBaseCluster().getRegions(tableName).forEach(r -> Assert.assertEquals((long)1L, (long)r.getStore(FAMILY).getStorefiles().size()));
    }
}

