/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.util.regex.Pattern;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.util.InputPolicy;
import software.amazon.s3.analyticsaccelerator.util.ObjectFormat;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class ObjectFormatSelector {
    private final Pattern parquetPattern;
    private final Pattern csvPattern;
    private final Pattern jsonPattern;
    private final Pattern txtPattern;
    private final boolean useFormatSpecificIO;

    public ObjectFormatSelector(LogicalIOConfiguration configuration) {
        this.parquetPattern = Pattern.compile(configuration.getParquetFormatSelectorRegex(), 2);
        this.csvPattern = Pattern.compile(configuration.getCsvFormatSelectorRegex(), 2);
        this.jsonPattern = Pattern.compile(configuration.getJsonFormatSelectorRegex(), 2);
        this.txtPattern = Pattern.compile(configuration.getTxtFormatSelectorRegex(), 2);
        this.useFormatSpecificIO = configuration.isUseFormatSpecificIO();
    }

    public ObjectFormat getObjectFormat(S3URI s3URI, OpenStreamInformation openStreamInformation) {
        if (!this.useFormatSpecificIO) {
            return ObjectFormat.DEFAULT;
        }
        String key = s3URI.getKey();
        if (openStreamInformation.getInputPolicy() != null && openStreamInformation.getInputPolicy().equals((Object)InputPolicy.Sequential) || this.isKeyExtensionSequential(key)) {
            return ObjectFormat.SEQUENTIAL;
        }
        if (this.parquetPattern.matcher(key).find()) {
            return ObjectFormat.PARQUET;
        }
        return ObjectFormat.DEFAULT;
    }

    private boolean isKeyExtensionSequential(String key) {
        return this.csvPattern.matcher(key).find() || this.jsonPattern.matcher(key).find() || this.txtPattern.matcher(key).find();
    }
}

