/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;

public class CSQueuePreemptionSettings {
    private final boolean preemptionDisabled;
    private final boolean intraQueuePreemptionDisabledInHierarchy;

    public CSQueuePreemptionSettings(CSQueue queue, CapacitySchedulerConfiguration configuration) {
        this.preemptionDisabled = this.isQueueHierarchyPreemptionDisabled(queue, configuration);
        this.intraQueuePreemptionDisabledInHierarchy = this.isIntraQueueHierarchyPreemptionDisabled(queue, configuration);
    }

    private boolean isQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerConfiguration configuration) {
        boolean systemWidePreemption = configuration.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        CSQueue parentQ = q.getParent();
        if (!systemWidePreemption) {
            return true;
        }
        if (parentQ == null) {
            return configuration.getPreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getPreemptionDisabled(q.getQueuePath(), parentQ.getPreemptionDisabled());
    }

    private boolean isIntraQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerConfiguration configuration) {
        boolean systemWideIntraQueuePreemption = configuration.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", false);
        if (!systemWideIntraQueuePreemption) {
            return true;
        }
        CSQueue parentQ = q.getParent();
        if (parentQ == null) {
            return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), parentQ.getIntraQueuePreemptionDisabledInHierarchy());
    }

    public boolean isIntraQueuePreemptionDisabled() {
        return this.intraQueuePreemptionDisabledInHierarchy || this.preemptionDisabled;
    }

    public boolean isIntraQueuePreemptionDisabledInHierarchy() {
        return this.intraQueuePreemptionDisabledInHierarchy;
    }

    public boolean isPreemptionDisabled() {
        return this.preemptionDisabled;
    }
}

