/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.hadoop.util.CleanerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferWrapper.class);
    private ByteBuffer byteBuffer;
    private File file;
    private RandomAccessFile randomAccessFile;

    ByteBufferWrapper(ByteBuffer byteBuffer) {
        this(byteBuffer, null, null);
    }

    ByteBufferWrapper(ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, File file) {
        this.byteBuffer = byteBuffer;
        this.file = file;
        this.randomAccessFile = randomAccessFile;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    boolean isDiskBuffer() {
        return this.file != null && this.randomAccessFile != null;
    }

    private void munmap(MappedByteBuffer buffer) {
        if (CleanerUtil.UNMAP_SUPPORTED) {
            try {
                CleanerUtil.getCleaner().freeBuffer((ByteBuffer)buffer);
            }
            catch (IOException e) {
                LOG.warn("Failed to unmap the buffer", (Throwable)e);
            }
        } else {
            LOG.trace(CleanerUtil.UNMAP_NOT_SUPPORTED_REASON);
        }
    }

    void close() throws IOException {
        if (null != this.byteBuffer) {
            this.byteBuffer.clear();
        }
        IOException exception = null;
        try {
            if (null != this.randomAccessFile) {
                this.randomAccessFile.close();
            }
        }
        catch (IOException e) {
            LOG.error("Close the random access file occurs an exception.", (Throwable)e);
            exception = e;
        }
        if (this.byteBuffer instanceof MappedByteBuffer) {
            this.munmap((MappedByteBuffer)this.byteBuffer);
        }
        if (null != this.file && this.file.exists() && !this.file.delete()) {
            LOG.warn("Delete the tmp file: [{}] failed.", (Object)this.file.getAbsolutePath());
        }
        if (null != exception) {
            throw exception;
        }
    }
}

