/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.security.IdMappingServiceProvider;

public class SysSecurityHandler
extends SecurityHandler {
    private final IdMappingServiceProvider iug;
    private final CredentialsSys mCredentialsSys;

    public SysSecurityHandler(CredentialsSys credentialsSys, IdMappingServiceProvider iug) {
        this.mCredentialsSys = credentialsSys;
        this.iug = iug;
    }

    @Override
    public String getUser() {
        return this.iug.getUserName(this.mCredentialsSys.getUID(), "nobody");
    }

    @Override
    public boolean shouldSilentlyDrop(RpcCall request) {
        return false;
    }

    @Override
    public VerifierNone getVerifer(RpcCall request) {
        return new VerifierNone();
    }

    @Override
    public int getUid() {
        return this.mCredentialsSys.getUID();
    }

    @Override
    public int getGid() {
        return this.mCredentialsSys.getGID();
    }

    @Override
    public int[] getAuxGids() {
        return this.mCredentialsSys.getAuxGIDs();
    }
}

