/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.StaticMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestNetworkTopologyServlet {
    @Test
    public void testPrintTopologyTextFormat() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        int dataNodesNum = 0;
        ArrayList<String> rackList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                rackList.add("/rack" + i);
                ++dataNodesNum;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(dataNodesNum).racks(rackList.toArray(new String[rackList.size()])).build();
        cluster.waitActive();
        String httpUri = cluster.getHttpUri(0);
        URL url = new URL(httpUri + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("/rack0"));
        Assert.assertTrue((boolean)topology.contains("/rack1"));
        Assert.assertTrue((boolean)topology.contains("/rack2"));
        Assert.assertTrue((boolean)topology.contains("/rack3"));
        Assert.assertTrue((boolean)topology.contains("/rack4"));
        Assert.assertEquals((long)(topology.split("127.0.0.1").length - 1), (long)dataNodesNum);
    }

    @Test
    public void testPrintTopologyJsonFormat() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        int dataNodesNum = 0;
        ArrayList<String> rackList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                rackList.add("/rack" + i);
                ++dataNodesNum;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(dataNodesNum).racks(rackList.toArray(new String[rackList.size()])).build();
        cluster.waitActive();
        String httpUri = cluster.getHttpUri(0);
        URL url = new URL(httpUri + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        String topology = out.toString();
        JsonNode racks = new ObjectMapper().readTree(topology);
        Assert.assertEquals((long)racks.size(), (long)5L);
        Iterator elements = racks.elements();
        int dataNodesCount = 0;
        while (elements.hasNext()) {
            JsonNode rack = (JsonNode)elements.next();
            Iterator fields = rack.fields();
            while (fields.hasNext()) {
                dataNodesCount += ((JsonNode)((Map.Entry)fields.next()).getValue()).size();
            }
        }
        Assert.assertEquals((long)dataNodesCount, (long)dataNodesNum);
    }

    @Test
    public void testPrintTopologyNoDatanodesTextFormat() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
        String httpUri = cluster.getHttpUri(0);
        URL url = new URL(httpUri + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("No DataNodes"));
    }

    @Test
    public void testPrintTopologyNoDatanodesJsonFormat() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        cluster.waitActive();
        String httpUri = cluster.getHttpUri(0);
        URL url = new URL(httpUri + "/topology");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setReadTimeout(20000);
        conn.setConnectTimeout(20000);
        conn.setRequestProperty("Accept", "application/json");
        conn.connect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        StringBuilder sb = new StringBuilder("-- Network Topology -- \n");
        sb.append(out);
        sb.append("\n-- Network Topology -- ");
        String topology = sb.toString();
        Assert.assertTrue((boolean)topology.contains("No DataNodes"));
    }
}

